package com.sun.portal.sample.j2ee.poll.provider;


import java.util.List;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.jsp.JSPProvider;
import com.sun.portal.providers.ProviderException;

import com.sun.portal.sample.j2ee.poll.ejb.Poll;
import com.sun.portal.sample.j2ee.poll.ejb.PollHome;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import java.rmi.RemoteException;


public class PollProvider extends JSPProvider {
    
    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res)
    throws ProviderException {
        
        String errMsg = null;
        
        Poll poll = lookupPoll();
        ProviderContext ctx = getProviderContext();
        
        if (poll != null) {
            String pollPage = req.getParameter("pollPage");
            
            if(pollPage == null || pollPage.equals("pollChannelContent")) {
                setupPollPage(poll);
            } else if (pollPage.equals("pollChannelResults")) {
                setupResultsPage(req,poll);
            }
        } else {
            //ctx.setSessionProperty("pollQuestion", errMsg);
        }
        
        return super.getContent(req, res);
        
    }
    
    private Poll lookupPoll() {
        Poll poll = null;
        String errMsg = null;
        try {
            Context ic = new InitialContext();
            Object objRef = ic.lookup("java:comp/env/ejb/poll");
            PollHome home = (PollHome)PortableRemoteObject.narrow(objRef, PollHome.class);
            poll = home.create();
        } catch (RemoteException ex) {
            errMsg = "Couldn't create poll bean."+ ex.getMessage();
        } catch (CreateException ex) {
            errMsg = "Couldn't create poll bean."+ ex.getMessage();
        } catch (NamingException ex) {
            errMsg = "Unable to lookup home: "+ "ejb/poll "+ ex.getMessage();
        }
        return poll;
    }
    
    private void setupPollPage(Poll poll) throws ProviderException {
        String action = null;
        boolean error = false; 
        ProviderContext ctx = getProviderContext();
        String pollName  = getStringProperty("pollName");
        String lastVoted = getStringProperty("lastVoted");
        if(pollName.equals(lastVoted)) {
            action = "CHANGE VOTE";
        } else {
            action = "VOTE";
        }
        try {
            String question = poll.getQuestion(pollName);
            List   choices  = poll.getChoices(pollName);
            
            if(question != null && !question.trim().equals("")) {
                ctx.setSessionProperty("pollChannelQuestion", question);
            } else {
                error = true;
            }
            
            if(choices != null && !choices.isEmpty()) {
                ctx.setSessionProperty("pollChannelChoice", choices );
             } else {
                error = true;
            }
            ctx.setSessionProperty("pollChannelAction",action);
            
            if(error) {
               ctx.setSessionProperty("pollChannelError","true");
               error = false;
            }
        } catch (java.rmi.RemoteException ex) {
            //errMsg = "Failed to access poll bean method. "+ ex.getMessage();
            //ctx.setSessionProperty("ejbcounter", errMsg);
        }
    }
    
    private void setupResultsPage(HttpServletRequest req, Poll poll) throws ProviderException{
        ProviderContext ctx = getProviderContext();
        String pollName  = getStringProperty("pollName");
        try {
            String action = req.getParameter("SUBMIT");
            ctx.setSessionProperty("pollChannelQuestion", poll.getQuestion(pollName));
            if(action == null || action.equals("RESULTS")) {
                ctx.setSessionProperty("pollChannelResults",poll.getResults(pollName));
            } else if(action.equals("VOTE")){
                String vote = req.getParameter("pollChannelVote");
                ctx.setSessionProperty("pollChannelResults",poll.vote(pollName,vote));
                setStringProperty("vote",vote);
                setStringProperty("lastVoted",pollName);
            } else if(action.equals("CHANGE VOTE")){
                String vote = req.getParameter("pollChannelVote");
                String oldVote = getStringProperty("vote");
                ctx.setSessionProperty("pollChannelResults",poll.changeVote(pollName,oldVote,vote));
                setStringProperty("vote",vote);
                setStringProperty("lastVoted",pollName);
             } else {
            }
        } catch (java.rmi.RemoteException ex) {
            //set errror page here
        }
    }
}

