<%-- 
  Copyright 2003 Sun Microsystems, Inc. All rights reserved 
  Use is subject to license terms. 
--%><%
%><%@ page errorPage="/jsp/default/errorpage.jsp" %><%
%><%@ page session="false" %><%

%><%@ taglib uri="/WEB-INF/wireless_cal.tld" prefix="cal" %><%
%><%@ taglib uri="/WEB-INF/wireless_util.tld" prefix="util" %><%

%><util:content /><%

%><util:catalog resource="cal" id="i18n" /><%
%><cal:context/><%


%><%--
	Get current view date from parameter and do a fetch. This is a workaround
        to synchronize task list when user selects browser "Back" button to 
        navigate.
--%><%

    %><cal:datetime id="view"><%
        %><cal:dateformat name="view" format="yyyyMMdd" parse="$(d)"/><%
    %></cal:datetime><%

    %><cal:fetch day="view"/><%


%><%-- 
 	Get task by tid argument and display task details:
	<card>
	<p>
	11:00 <br/>
	Title: Meeting<br/>
	Location: X File<br/>
	Staff Meeting<br/>
--%><%
    %><util:edit id="edit1"><%
      %><%-- No more than 25 characters for summary--%><%
      %><util:set property="truncation" value="$/SunMobileAppCalendarService:sunMobileAppCalendarJspSummaryLength:25/"/><%
      %><util:set property="escape" value="true"/><%
    %></util:edit><%

    %><util:edit id="edit2"><%
      %><%-- No more than 300 characters for description --%><%
      %><util:set property="truncation" value="$/SunMobileAppCalendarService:sunMobileAppCalendarJspDescLength:300/"/><%
      %><util:set property="escape" value="true"/><%
    %></util:edit><%



    %><%-- view task details --%>
<AmlDocument>
<AmlPage title="<util:msg name="i18n" key="changetask"/>" menu_pos="bottom">

    <cal:task id="task" index="$(tid)"><%

    %><%-- summary --%><%
    %><AmlText text="<util:msg name="i18n" key="title"/>: <cal:get property="summary" edit="edit1"/>"/><AmlBr/><%

    %><%-- due date and time --%><%
    %><util:if property="dueTime"><%
        %><cal:get id="duedate" property="dueDate"/><%

        %><AmlText text="<util:msg name="i18n" key="dueOn"/>"/> <%
            %><AmlText text=" <cal:dateformat name="duedate" format="$[i18n:parsedatefmt]" />"/><AmlBr/><%

        %><AmlText text="<util:msg name="i18n" key="dueAt"/>"/> <%
            %><AmlText text=" <cal:dateformat name="duedate" format="$[i18n:timefmt]"/>"/><AmlBr/><%
    %></util:if><%


    %><%-- details --%><%
    %><AmlText text="<util:msg name="i18n" key="details"/>: <cal:get property="description" edit="edit2"/>"/><AmlBr/><%


    %><%-- Status --%><%
    %><util:if property="completed"><%
       %><AmlText text="<util:msg name="i18n" key="stat"/>: <util:msg name="i18n" key="cmp"/>"/><%
    %></util:if><%
    %><util:ifnot property="completed"><%
       %><AmlText text="<util:msg name="i18n" key="stat"/>: <util:msg name="i18n" key="incmp"/>"/><%
    %></util:ifnot><%

    %><AmlGroup halign="left"><%
    %><%-- change task --%><%
        %><AmlLink>
                    <AmlURL action="<util:url file="taskSess.jsp" comp="cal"/>"><%
                        %><AmlParam name="d" value="<util:get eval="$(d)"/>"/><%
                        %><AmlParam name="tid" value="<util:get eval="$(tid)"/>"/><% 
                    %></AmlURL>

        <AmlText text="<util:msg name="i18n" key="change"/>"/></AmlLink><AmlBr/><%


    %><%-- delete task --%><%
        %><AmlLink>
                    <AmlURL action="<util:url file="deleteTask.jsp" comp="cal"/>"><%
                        %><AmlParam name="d" value="<util:get eval="$(d)"/>"/><%
                        %><AmlParam name="tid" value="<util:get eval="$(tid)"/>"/><% 
                    %></AmlURL>
        <AmlText text="<util:msg name="i18n" key="delete"/>"/></AmlLink><AmlBr/><%

%></cal:task><%
    %></AmlGroup>

    <AmlControlMenu><%
            %><AmlURL action="<util:url file="dayview.jsp" comp="cal"/>"><%
    	        %><AmlParam name="d" value="<util:get eval="$(d)"/>"/><%
            %></AmlURL><%
    %><AmlText text="<util:msg name="i18n" key="calhm"/>"/></AmlControlMenu>
</AmlPage>
</AmlDocument>
