<%-- 
  Copyright 2003 Sun Microsystems, Inc. All rights reserved 
  Use is subject to license terms. 
--%><%
%><%@ page errorPage="/jsp/default/errorpage.jsp" %><%
%><%@ page session="false" %><%

%><%@ taglib uri="/WEB-INF/wireless_cal.tld" prefix="cal" %><%
%><%@ taglib uri="/WEB-INF/wireless_util.tld" prefix="util" %><%

%><util:content /><%
%><util:catalog resource="cal" id="i18n" /><%
%><cal:context/><%


%><%--
	Get current view date from parameter and do a fetch. This is a workaround
        to synchronize event list when user selects browser "Back" button to 
        navigate.
--%><%
%><cal:datetime id="view"><%
%><cal:dateformat name="view" format="yyyyMMdd" parse="$(d)"/><%
%></cal:datetime><%

%><cal:fetch day="view"/><%


%><%-- set character entity escaping and truncation to 25 characters --%><%
%><%-- truncation is for summary --%><%
%><util:edit id="edit1"><%
  %><util:set property="truncation" value="$/SunMobileAppCalendarService:sunMobileAppCalendarJspSummaryLength:25/"/><%
  %><util:set property="escape" value="true"/><%
%></util:edit><%

%><%-- set character entity escaping and truncation to 300 characters --%><%
%><%-- truncation is for description --%><%
%><util:edit id="edit2"><%
  %><util:set property="truncation" value="$/SunMobileAppCalendarService:sunMobileAppCalendarJspDescLength:300/"/><%
  %><util:set property="escape" value="true"/><%
%></util:edit><%

%><%-- set character entity escaping and truncation to 25 characters --%><%
%><%-- truncation is for location --%><%
%><util:edit id="edit3"><%
  %><util:set property="truncation" value="$/SunMobileAppCalendarService:sunMobileAppCalendarJspLocationLength:25/"/><%
  %><util:set property="escape" value="true"/><%
%></util:edit><%

%><%-- Calendar event detail --%>
<AmlDocument title="<util:msg name="i18n" key="event"/>">
<AmlPage menu_pos="bottom"><%
%><%-- 
    display event detail
    * start time - end time
    * summary
    * location
    * description
    * is repeating event

--%><%
%><cal:event id="event" index="$(eid)"><%

  %><%-- is this an allday event? --%><%
  %><util:if property="allDay"><%
    %><AmlText text="<util:msg name="i18n" key="allday"/>"/><AmlBr/><%
  %></util:if><%

  %><%-- start time and end time --%><%
  %><util:ifnot property="allDay">
    <AmlText text="<cal:get id="start" property="start"/><%
    %><cal:dateformat name="start" format="$[i18n:timefmt]"/> - <%
    %><cal:get id="end" property="end"/><%
    %><cal:dateformat name="end" format="$[i18n:timefmt]"/>"/><AmlBr/><%
  %></util:ifnot><%

  %><%-- summary --%>
  <AmlText text="<util:msg name="i18n" key="title"/>: <cal:get property="summary" edit="edit1"/>"/><AmlBr/><%

  %><%-- location --%>
  <AmlText text="<util:msg name="i18n" key="location"/>: <cal:get property="location" edit="edit3"/>"/><AmlBr/><%

  %><%-- description --%>
  <AmlText text="<util:msg name="i18n" key="details"/>: <cal:get property="description" edit="edit2"/>"/> <AmlBr/><%

  %><%-- repeating event? --%>
  <util:if property="recurrence"><%
      %><AmlText text="<util:msg name="i18n" key="repeat"/>"/><AmlBr/>
  </util:if><%
  
  %><AmlBr/><%

%><util:if property="calIdTheOrganizer" >

<%-- change event --%>
<AmlLink> 

    <AmlURL action="<util:url file="eventSess.jsp" comp="cal"/>"><%
    	%><AmlParam name="d" value="<util:get eval="$(d)"/>"/><%
    	%><AmlParam name="eid" value="<util:get eval="$(eid)"/>"/><%
    %></AmlURL>

<AmlText text="<util:msg name="i18n" key="change"/>"/></AmlLink><AmlBr/><%

%><%-- delete event --%>
<AmlLink>
    <AmlURL action="<util:url file="delete.jsp" comp="cal"/>"><%
    	%><AmlParam name="d" value="<util:get eval="$(d)"/>"/><%
    	%><AmlParam name="eid" value="<util:get eval="$(eid)"/>"/><%
    %></AmlURL><%
    %><%-- 
           Present different delete label if this is a repeat event.
           SunONE: Delete
           Lotus: Delete All
    --%><%
    %><util:if property="recurrence"><%
      %><util:include file="deleteLabel.jsp" comp="cal"/><%
    %></util:if><%
    %><util:ifnot property="recurrence"><%
      %><AmlText text="<util:msg name="i18n" key="delete"/>"/><%
    %></util:ifnot><%
    %></AmlLink><AmlBr/><%
%> </util:if>

</cal:event>

<AmlControlMenu><%
    %><AmlURL action="<util:url file="dayview.jsp" comp="cal"/>"><%
    	%><AmlParam name="d" value="<util:get eval="$(d)"/>"/><%
    %></AmlURL><%
%><AmlText text="<util:msg name="i18n" key="calhm"/>"/></AmlControlMenu>

</AmlPage>
</AmlDocument>
