<%--
 Copyright 2003 Sun Microsystems, Inc. All rights reserved
 Use is subject to license terms.
--%>

<%@ page session="false" %>

<%-- layoutedit.jsp --%>
<%@ include file="layoutSetup.jsp" %>
<%@ taglib uri="/tld/desktopProviderContext.tld" prefix="dtpc" %>
<%@ taglib uri="/tld/desktopContainerProviderContext.tld" prefix="dtcpc" %>
<%@ taglib uri="/tld/desktop.tld" prefix="dt" %>
<%@ taglib uri="/tld/desktopTheme.tld" prefix="dttheme" %>
<%@ taglib uri="/tld/jx.tld" prefix="jx" %>

<%-- The presentation of content edit page --%>

<dt:obtainContainer container="$JSPProvider">
<jx:choose>
  <jx:when test="$pc == 'FrameTabContainer'">
    <jsp:include page="framePreferenceHeader.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPTabContainerProvider'">
    <jsp:include page="tabPreferenceHeader.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPTableContainerProvider'">
    <jsp:include page="tablePreferenceHeader.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPSingleContainerProvider'">
    <jsp:include page="singlePreferenceHeader.jsp" flush="true"/>
  </jx:when>
  <jx:otherwise>
    <jsp:include page="defaultHeader.jsp" flush="true"/>
  </jx:otherwise>
</jx:choose>

<script language="JavaScript">
  function arrangeContentProvider( direction, columnID ) {
    column = "order";
    selection = document.layoutForm[column].selectedIndex;
    if (selection != -1) {
      oText = document.layoutForm[column].options[selection].text;
      oValue = document.layoutForm[column].options[selection].value;
      if (selection > 0 && direction == 0) {
        document.layoutForm[column].options[selection].text = document.layoutForm[column].options[selection-1].text;
        document.layoutForm[column].options[selection].value = document.layoutForm[column].options[selection-1].value;
        document.layoutForm[column].options[selection-1].text = oText;
        document.layoutForm[column].options[selection-1].value = oValue;
        document.layoutForm[column].selectedIndex--;
      }
      else if (selection < document.layoutForm[column].length-1 && direction == 1) {
        document.layoutForm[column].options[selection].text = document.layoutForm[column].options[selection+1].text;
        document.layoutForm[column].options[selection].value = document.layoutForm[column].options[selection+1].value;
        document.layoutForm[column].options[selection+1].text = oText;
        document.layoutForm[column].options[selection+1].value = oValue;
        document.layoutForm[column].selectedIndex++;
      }
    }
    else alert("Please select a channel."); return false;
  }
</script>

<script language=JavaScript>
  function selectAll(){
    if (document.layoutForm["order"] != null) {
      for( var i=0; i < document.layoutForm["order"].length; i++ ){
        document.layoutForm["order"].options[i].selected = true;
      }
    }
  }
</script>

<center>
  <form action="<dtpc:getDesktopURL/>" method=POST name="layoutForm" onsubmit="selectAll()" enctype="application/x-www-form-urlencoded">
    <input type=hidden name="action" size=-1 value="process">
    <input type=hidden name="provider" size=-1 value="<dt:getName/>">
    <input type=hidden name="container" size=-1 value=<%=containerName%>>

    <table border="0" cellpadding="2" cellspacing="0" width="100%">
      <tr>
        <td valign="top" colspan="5" bgcolor=<dttheme:getAttribute name="titleBarColor"/>>
          <font size="+2" color=<dttheme:getAttribute name="bgColor"/> face=<dttheme:getAttribute name="fontFace"/>>
            <b><%=clientName%> Layout</b>
          </font>
        </td>
      </tr>
      <tr>
        <td colspan=5 bgcolor=<dttheme:getAttribute name="borderColor"/>>
          <font size="+0" face=<dttheme:getAttribute name="fontFace"/>>
            Organize your content the way you would like it displayed on your mobile
            device. Select a channel, then move it up and down in the list by 
            clicking the arrows.
          </font>
        </td>
      </tr>
      <tr>
        <td width="1%" align="left" bgcolor=<dttheme:getAttribute name="bgColor"/>>
          <font size=+0 face=<dttheme:getAttribute name="fontFace"/>>
	  </dt:obtainContainer>
            <center>
                <jx:if test="$hasMovableChannels == true" >
                  <select name="order" size="<%=listSize%>" multiple>
    				<% ContainerProvider c = (ContainerProvider) pageContext.getAttribute("clientContainer");
				    if(c instanceof WirelessJSPContainerProviderAdapter){
				    %>
                        <dt:obtainContainer container="$clientContainer">
                          <jx:forEach var="channel" items="$selectedChannels">
                            <dtcpc:obtainChannelFromContainer channel="$channel">
				              <option value="<dt:getName/>"><dt:getTitle/></option>
                            </dtcpc:obtainChannelFromContainer>
                          </jx:forEach>
                        </dt:obtainContainer>
				    <%
				    }%>
				    <%-- Have to do the following scriptlet code as the 
				     obtainContainer tag doesnt work if the container is 
					 TemplateDesktop Container.
			 	    --%>
					<%
				    if(c instanceof WirelessContainerProviderAdapter){ %>
                      <jx:forEach var="channel" items="$selectedChannels">
					    <%   
					    String title = context.getStringProperty((String)pageContext.getAttribute("channel"), "title");
                        %>
                        <option value="<%=pageContext.getAttribute("channel")%>"><%=title%></option>
                      </jx:forEach>
				    <% } %>
                  </select>
  		        </jx:if>
            </center>
          </font>
        </td>
        <td>
<dt:obtainContainer container="$JSPProvider">

          <table width="99%" align="left" cellpadding="4">
            <tr>
              <td>
                <a href="javascript:void(0)" onclick="return arrangeContentProvider(0,1)"><img src="<dt:scontent/>/desktop/images/b_up.gif" width="17" height="15" border="0" alt="Up"></a>
              </td>
            </tr>
            <tr>
              <td>
                <a href="javascript:void(0)" onclick="return arrangeContentProvider(1,1)"><img src="<dt:scontent/>/desktop/images/b_down.gif" width="17" height="15" border="0" alt="Down"></a>
              </td>
	    </tr>
          </table>
        </td>
      </tr>
      <% if (isMinimizable) { %>
      <tr>   
        <td colspan=5>&nbsp;</td> 
      </tr>
      <tr>
        <td colspan=5 bgcolor=<dttheme:getAttribute name="borderColor"/>>
          <font size="+0" face=<dttheme:getAttribute name="fontFace"/>>
            Choose whether all channels should be loaded with the desktop.  Performance of
            the desktop on mobile devices is improved if channels are not loaded at the
            same time as the desktop.
          </font>
        </td>
      </tr>
      <tr>
        <td colspan=5 align="left" bgcolor=<dttheme:getAttribute name="bgColor"/>>
          <font size=+0 face=<dttheme:getAttribute name="fontFace"/>>
          <input type="checkbox" name="loadChannels" id="load" value="1" border="0"
          <% if (!channelsAreMinimized) { %>
              checked
          <% } %>
          ><label for="load">Load channels with desktop</label>
          </font>
        </td>
      </tr>
      <% } %>
    </table>
    <br>
    <font size=+0 face=<dttheme:getAttribute name="fontFace"/>>
      <input type="submit" name="Submit" value="Finished" class="button" style='background-color:<dttheme:getAttribute name="titleBarColor" default="#333366"/>;color:<dttheme:getAttribute name="titleFontColor" default="#FFFFFF"/>'>
  	  <%
        Map map = new HashMap();
        map.put("action", "edit");
        map.put("provider", "WirelessJSPClientConfigContainer");
        pageContext.setAttribute("desktop_qmap", map);

      %>
      <input type="button" onclick="location='<dtpc:getDesktopURL querymap="$desktop_qmap" escape="true"/>'" value="Cancel" class="button" style='background-color:<dttheme:getAttribute name="titleBarColor" default="#333366"/>;color:<dttheme:getAttribute name="titleFontColor" default="#FFFFFF"/>'>
 
    </font>
    <br>
  </form>
  <p>
</center>
</body>

<jx:choose>
  <jx:when test="$pc == 'FrameTabContainer'">
    <jsp:include page="framePreferenceMenubar.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPTabContainerProvider'">
    <jsp:include page="tabPreferenceMenubar.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPTableContainerProvider'">
    <jsp:include page="tablePreferenceMenubar.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPSingleContainerProvider'">
    <jsp:include page="singlePreferenceMenubar.jsp" flush="true"/>
  </jx:when>
  <jx:otherwise>
    <jsp:include page="defaultMenubar.jsp" flush="true"/>
  </jx:otherwise>
</jx:choose>

</dt:obtainContainer>
