<%-- Generate the remove channel dialogs --%>
  <%-- Documents variables --%>
  <var name="action" expr="'process'"/>
  <var name="provider" expr="'WirelessJSPContentChannel'"/>
  <var name="container" expr="'<%=container%>'"/>
  <var name="mode" expr="'<%=mode%>'"/>
  <var name="channel"/>
  <var name="title"/>
  <var name="promptAudio"/>
  <var name="nextURL"/>

<jx:choose>
  <jx:when test="$isMultiRemove == 'true'">

  <link event="whatAreMyChoices">
    <grammar src="<dtpc:getStaticContentPath/>/<jx:expr value="$grammarURL"/>#Choices"/>
  </link>

  <%-- Main Menu --%>
  <menu id="removeMenu" dtmf="true">
    <prompt>
      <audio expr="promptPath + 'all_right.wav'"/>
      <audio expr="promptPath + 'you_can_remove_any_of_these_channels.wav'"/>
      <enumerate>
        <value expr="_prompt"/>
      </enumerate>
      <audio expr="promptPath + 'which_channel_would_you_like_to_remove.wav'"/>
    </prompt>
      
    <jx:forEach var="channel" items="$adjustedRemoveChannels">
      <dtcpc:obtainChannelFromContainer channel="$channel">
        <dtpc:providerContext>
          <choice next="#<dt:getName/>">
            <grammar src="<dtpc:getStaticContentPath/>/<dtpc:getStringProperty pfList="$pfList" key="grammarURL"/>"/>
            <audio src="<dtpc:getStringProperty pfList="$pfList" key="promptRoot"/>/<dtpc:getStringProperty pfList="$pfList" key="persona"/>/<dtpc:getStringProperty pfList="$pfList" key="channelPrompt"/>">
              <dt:getTitle/>
            </audio>
          </choice>
        </dtpc:providerContext>
      </dtcpc:obtainChannelFromContainer>
    </jx:forEach>

    <%-- Deal with no input, no match --%>
    <noinput count="1">
      <audio expr="promptPath + 'sorry_i_didnt_hear_anything.wav'"/>
      <prompt>	    
        <audio expr="promptPath + 'you_can_remove_any_of_these_channels.wav'"/>
        <enumerate>
          <value expr="_prompt"/>
        </enumerate>
        <audio expr="promptPath + 'tell_me_which_one_you_want_to_remove_or_say_cancel.wav'"/>
      </prompt>		  
    </noinput>

    <noinput count="2">
      <audio expr="promptPath + 'sorry_i_still_didnt_hear_anything.wav'"/>
      <audio expr="promptPath + 'say_the_name_of_the_channel_you_want_to_remove_or_.wav'"/>
    </noinput>
	
    <nomatch count="1">
      <audio expr="promptPath + 'sorry_i_didnt_get_that.wav'"/>
      <prompt>	    
        <audio expr="promptPath + 'you_can_remove_any_of_these_channels.wav'"/>
        <enumerate>
          <value expr="_prompt"/>
        </enumerate>
        <audio expr="promptPath + 'tell_me_which_one_you_want_to_remove_or_say_cancel.wav'"/>
      </prompt>		  
    </nomatch>

    <nomatch count="2">
      <audio expr="promptPath + 'sorry_i_still_didnt_get_that.wav'"/>
      <audio expr="promptPath + 'say_the_name_of_the_channel_you_want_to_remove_or_.wav'"/>
    </nomatch>

    <help>
      <audio expr="promptPath + 'ok_heres_some_help.wav'"/>
      <audio expr="promptPath + 'right_now_were_in_the_process_of_removing_one_of_t.wav'"/>
      <audio expr="promptPath + 'to_remove_a_channel_tell_me_which_one_you_want_to_.wav'"/>
      <audio expr="promptPath + 'if_you_want_to_hear_the_list_of_channels_you_can_r.wav'"/>
      <audio expr="promptPath + 'and_if_you_dont_want_to_remove_a_channel_right_now.wav'"/>
    </help>

    <catch event="whatAreMyChoices">
      <prompt>
        <audio expr="promptPath + 'you_can_remove_any_of_these_channels.wav'"/>
        <enumerate>
          <value expr="_prompt"/>
        </enumerate>
        <audio expr="promptPath + 'tell_me_which_one_you_want_to_remove_or_say_cancel.wav'"/>
      </prompt>
    </catch>

  </menu>
  </jx:when>
  <jx:otherwise>
  <%-- Single Channel --%>
  </jx:otherwise>
</jx:choose>

  <%-- Choosen channel --%>
  <jx:forEach var="channel" items="$adjustedRemoveChannels">
    <dtcpc:obtainChannelFromContainer channel="$channel">
      <form id="<dt:getName/>">
        <block>
          <assign name="channel" expr="'<dt:getName/>'"/>
          <assign name="title" expr="'<dt:getTitle/>'"/>
          <assign name="promptAudio" expr="'<dtpc:getStringProperty pfList="$pfList" key="promptRoot"/>/<dtpc:getStringProperty pfList="$pfList" key="persona"/>/<dtpc:getStringProperty pfList="$pfList" key="channelPrompt"/>'" />

          <dt:getName id="dtgn" />
          <%
            Map map = new HashMap();

            map.put("mode", "remove");
            map.put("action", "edit");
            map.put("provider", "WirelessJSPContentChannel");
            map.put("container", container);
            map.put("c", pageContext.getAttribute("dtgn"));

            pageContext.setAttribute("qmap", map);
          %>
          <assign name="nextURL" expr="'<dtpc:getDesktopURL querymap="$qmap" escape="true" />'" />
	      
          <goto next="#confirmRemove"/>
        </block>
      </form>
    </dtcpc:obtainChannelFromContainer>
  </jx:forEach>

  <form id="confirmRemove">
    <field name="yesno">
      <grammar src="<dtpc:getStaticContentPath/>/<jx:expr value="$grammarURL"/>#YesNo"/>

      <prompt>
        <audio expr="promptPath + 'just_to_confirm_you_want_to_remove_this_channel.wav'"/>
        <audio expr="promptAudio"><value expr="title"/></audio>
        <audio expr="promptPath + 'did_i_get_that_right.wav'"/>
      </prompt>

      <filled>
        <if cond="yesno == 'yes'">
          <goto next="#processEdit"/>
        <elseif cond="yesno == 'no'"/>
          <throw event="goMain"/>
        <else/>
          <throw event="nomatch"/>
        </if>
      </filled>
    </field>

    <%-- Deal with no input, no match --%>
    <noinput count="1">
      <audio expr="promptPath + 'sorry_i_didnt_hear_anything.wav'"/>
      <audio expr="promptPath + 'did_you_want_to_remove_this_channel.wav'"/>
    </noinput>

    <noinput count="2">
      <audio expr="promptPath + 'sorry_i_still_didnt_hear_anything.wav'"/>
      <audio expr="promptPath + 'im_trying_to_confirm_do_you_want_to_remove.wav'"/>
      <audio expr="promptAudio"><value expr="title"/></audio>
      <audio expr="promptPath + 'from_the_list_of_channels_at_the_main_menu_please_.wav'"/>
    </noinput>
	
    <nomatch count="1">
      <audio expr="promptPath + 'sorry_i_didnt_get_that.wav'"/>
      <audio expr="promptPath + 'did_you_want_to_remove_this_channel.wav'"/>
    </nomatch>

    <nomatch count="2">
      <audio expr="promptPath + 'sorry_i_still_didnt_get_that.wav'"/>
      <audio expr="promptPath + 'im_trying_to_confirm_do_you_want_to_remove.wav'"/>
      <audio expr="promptAudio"><value expr="title"/></audio>
      <audio expr="promptPath + 'from_the_list_of_channels_at_the_main_menu_please_.wav'"/>
    </nomatch>

    <catch event="whatAreMyChoices">
      <audio expr="promptPath + 'im_trying_to_confirm_do_you_want_to_remove.wav'"/>
      <audio expr="promptAudio"><value expr="title"/></audio>
      <audio expr="promptPath + 'from_the_list_of_channels_at_the_main_menu.wav'"/>
      <audio expr="promptPath + 'please_say_yes_if_you_do_or_no_if_you_dont.wav'"/>
    </catch>
  
    <help>
      <%-- Super long winded message --%>
      <audio expr="promptPath + 'ok_heres_some_help.wav'"/>
      <audio expr="promptPath + 'im_trying_to_confirm_do_you_want_to_remove.wav'"/>
      <audio expr="promptAudio"><value expr="title"/></audio>
      <audio expr="promptPath + 'from_the_list_of_channels_at_the_main_menu.wav'"/>
      <audio expr="promptPath + 'please_say_yes_or_no_or_say_main_menu.wav'"/>
    </help>
  </form>
  
  <form id="processEdit">
    <block>
      <submit method="get" namelist="action provider mode container channel nextURL" next="<dtpc:getDesktopURL/>" />
    </block>
  </form>

  <%-- Catching global grammars --%>

  <%-- Leaving --%>
  <catch event="goBye">
    <%
      pageContext.setAttribute("qstr", new StringBuffer("provider=").append(container).append("#goodbye").toString());
    %>
    <goto next="<dtpc:getDesktopURL querystring="$qstr" escape="true"/>" />
  </catch>

  <%-- Main Menu --%>
  <catch event="goMain">
    <audio expr="promptPath + 'ok_this_channel_was_not_removed.wav'"/>
    <%
      pageContext.setAttribute("qstr", new StringBuffer("provider=").append(container).append("#returningToMain").toString());
    %>
    <goto next="<dtpc:getDesktopURL querystring="$qstr" escape="true"/>" />
  </catch>

  <%-- Cancel --%>
  <catch event="goCancel">
    <%
      pageContext.setAttribute("qstr", new StringBuffer("provider=").append(container).append("#canceled").toString());
    %>
    <goto next="<dtpc:getDesktopURL querystring="$qstr" escape="true"/>" />
  </catch>
