#!/bin/ksh
# Author: Anurag Gupta
# Date  : Aug 21, 2002

Usage() {
  echo "Usage: memfoot <process_name> <time interval>"
  echo "       memfoot <pid> <time_interval>"
  echo
  echo "time_interval - Time between two successive readings."
  echo "                Default value is 20 seconds."
}

PROCESS=$1
if [ "$PROCESS" == "" ]; then
  Usage
  exit 1
fi

TIMER=$2
if [ "$TIMER" == "" ]; then
  TIMER="20"
fi

FILE=/tmp/memfoot.txt
echo "" > $FILE

while (true)
do
  echo "" >> $FILE
  date >> $FILE
  ps -o"pid ppid vsz rss pcpu comm" | head -1 >> $FILE
  ps -ef -o"pid ppid vsz rss pcpu comm" | grep $PROCESS | sort -k 3 -n -r | head -1 >> $FILE
  sleep $TIMER
done
