<%-- 
  Copyright 2003 Sun Microsystems, Inc. All rights reserved 
  Use is subject to license terms.
 --%> 

<%@ page import="javax.servlet.ServletContext" %>
<%@ page import="javax.servlet.ServletConfig" %>

<% response.setContentType("application/x-javascript"); %>
var WINDOW_COOKIE_NAME = "desktop.windowCookie";

function setCookie(name, value, expires, path) {
    var curCookie = name + "=" + escape(value) +
        ((expires) ? "; expires=" + expires.toGMTString() : "") +
        ((path) ? "; path=" + path : "");
    document.cookie = curCookie;
}

function getCookie(Name) {
   var search = Name + "="
   if (document.cookie.length > 0) { // if there are any cookies
      offset = document.cookie.indexOf(search) 
      if (offset != -1) { // if cookie exists 
         offset += search.length 
         // set index of beginning of value
         end = document.cookie.indexOf(";", offset) 
         // set index of end of cookie value
         if (end == -1) 
            end = document.cookie.length
         return unescape(document.cookie.substring(offset, end))
      } 
   }
   return null;
}
function getWindowCookie() {
   var c = getCookie(WINDOW_COOKIE_NAME);
   return c;
}
function setWindowCookie(cookieString) {
   setCookie(WINDOW_COOKIE_NAME, cookieString, "", "/");
}
function parseWindowCookie() {
   var c = getWindowCookie();
   if (c != null && c.length > 0) {
      var windowNames = c.split("|");
      return windowNames;
   }
   return new Array(0);
}
function windowOpened(windowName) {
   if (isWindowOpened(windowName)) {
     return;
   }

   var c = getWindowCookie();
   if (c != null && c.length > 0) {
      c += "|" + windowName;
   } else {
      c = windowName;
   }
   //alert("windowOpened(): marked as open windowName=" + windowName + ", c=" + c);
   setWindowCookie(c);
}
function getWindowCookieString(windowNames) {
   if (windowNames != null && windowNames.length > 0) {
      var c = windowNames.join("|");
      return c;
   }
   return "";
}
function isWindowOpened(windowName) {
   var windowNames = parseWindowCookie();
   for (var i = 0; i < windowNames.length; i++) {
     if (windowNames[i] == windowName) {
        return true;
     }
   }
   return false;
}
function windowClosed(windowName) {
   var windowNames = parseWindowCookie();
   for (var i = 0; i < windowNames.length; i++) {
     if (windowNames[i] == windowName) {
       //alert("windowClosed(): marked as closed windowName=" + windowNames[i]);
        windowNames.splice(i, 1);
        // don't break, just in case window
        // was added twice
     }
   }
   var cookieString = getWindowCookieString(windowNames);
   setWindowCookie(cookieString);
}
function closeWindows() {
  closeWindows(null);
}
function closeWindows(regexp) {
   var thisWindow = window.name;
   var closeThisWindow = false;

   //special code for proxylet
   if(self.proxyletcleanup ){
        proxyletcleanup();
   }

   var windowNames = parseWindowCookie();

   for (var i = 0; i < windowNames.length; i++) {
     if (regexp == null || windowNames[i].match(regexp)) {
       if (thisWindow == windowNames[i]) {
         closeThisWindow = true;
       } else {
         //alert("closeWindows(): closing windowName=" + windowNames[i]);
         windowClosed(windowNames[i]);
         closeWindow(windowNames[i]);
       }
     }
   }

   if (closeThisWindow) {
     windowClosed(thisWindow);
     closeWindow(thisWindow);     
   }
}
function closeWindow(windowName) {
   <% String staticContextPath = config.getServletContext().getInitParameter("staticContext"); %>
   window.open("<%= staticContextPath %>/close.html", windowName);
}
