/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.netlet;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.desktop.DesktopException;
import com.sun.portal.desktop.context.ContextException;
import com.sun.portal.desktop.util.I18n;
import com.sun.portal.desktop.util.ParameterMap;
import com.sun.portal.desktop.util.Target;
import com.sun.portal.netlet.util.NetletConstants;
import com.sun.portal.netlet.util.UrlEncoder;
import com.sun.portal.netlet.util.UserAttributes;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContextException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetletProvider
extends ProfileProviderAdapter
implements NetletConstants {
    private ResourceBundle bundle = null;
    private final String NC_NAME = "/NetletConfig";
    private final String NC_STARTURL = "?func=makepage";
    private final String NC_JNLP_STARTURL = "?func=makeJnlpPage&startNetlet=true";
    private String editContainer = null;
    private String container = null;
    private String statusMsg = null;
    private String netletStatus = null;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
        this.bundle = this.getResourceBundle("srapNetletProvider");
    }

    public String getNetletConfigURI(HttpServletRequest req) {
        String cp = req.getContextPath();
        String ncuri = cp + "/NetletConfig";
        return ncuri;
    }

    private int callNetletConfig(String func, HttpServletRequest httpreq) throws IOException, ContextException, SSOException {
        String psNetletHeader = httpreq.getHeader("PS-Netlet");
        String host = httpreq.getServerName();
        int port = httpreq.getServerPort();
        String proto = httpreq.getScheme();
        String cookieName = SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
        String ncURI = this.getNetletConfigURI(httpreq);
        String ncURL = proto + "://" + host + ":" + port + ncURI;
        URL nc = new URL(ncURL + "?func=" + func);
        HttpURLConnection ncc = (HttpURLConnection)nc.openConnection();
        ncc.setDoOutput(true);
        ncc.setDoInput(true);
        ncc.setUseCaches(false);
        ncc.setRequestProperty("Cookie", cookieName + "=" + URLEncoder.encode(SSOTokenManager.getInstance().createSSOToken(httpreq).getTokenID().toString()));
        if (psNetletHeader != null) {
            ncc.setRequestProperty("PS-Netlet", psNetletHeader);
        }
        int response = ncc.getResponseCode();
        ncc.disconnect();
        return response;
    }

    private boolean isReauthEnabled(HttpServletRequest httpreq) {
        UserAttributes attrs = this.getNetletUserAttributes(httpreq);
        return attrs == null ? false : attrs.getBoolean("sunPortalNetletDoReauth", false);
    }

    private boolean hasStaticRule(List netletRules) {
        if (netletRules == null || netletRules.isEmpty()) {
            return false;
        }
        boolean hasStatic = false;
        for (int x = 0; x < netletRules.size(); ++x) {
            String nr = (String)netletRules.get(x);
            if (nr.endsWith("EXTEND")) {
                nr = nr.substring(0, nr.lastIndexOf("|"));
            }
            StringTokenizer tok = new StringTokenizer(nr, "|");
            boolean isTarget = false;
            try {
                String func = (String)tok.nextElement();
                String tmp = (String)tok.nextElement();
                tmp = (String)tok.nextElement();
                while (tok.hasMoreElements() && !isTarget) {
                    tmp = (String)tok.nextElement();
                    tmp = (String)tok.nextElement();
                    if (tmp.equals("TARGET")) {
                        isTarget = true;
                    }
                    tmp = (String)tok.nextElement();
                }
            }
            catch (NoSuchElementException nsee) {
                continue;
            }
            if (isTarget) continue;
            hasStatic = true;
        }
        return hasStatic;
    }

    private boolean hasDynamicRule(List netletRules, String ruleName) {
        if (netletRules == null || netletRules.isEmpty()) {
            return false;
        }
        for (int x = 0; x < netletRules.size(); ++x) {
            String nr = (String)netletRules.get(x);
            if (nr.endsWith("EXTEND")) {
                nr = nr.substring(0, nr.lastIndexOf("|"));
            }
            StringTokenizer tok = new StringTokenizer(nr, "|");
            boolean isTarget = false;
            try {
                String func = (String)tok.nextElement();
                StringTokenizer tempTok = new StringTokenizer(func, "^");
                func = tempTok.nextToken();
                if (ruleName == null || ruleName.trim().length() == 0 || !func.equals(ruleName)) continue;
                String tmp = (String)tok.nextElement();
                tmp = (String)tok.nextElement();
                while (tok.hasMoreElements() && !isTarget) {
                    tmp = (String)tok.nextElement();
                    tmp = (String)tok.nextElement();
                    if (tmp.equals("TARGET")) {
                        return true;
                    }
                    tmp = (String)tok.nextElement();
                }
                continue;
            }
            catch (NoSuchElementException nsee) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean hasDynamicRule(List netletRules) {
        if (netletRules == null || netletRules.isEmpty()) {
            return false;
        }
        for (int x = 0; x < netletRules.size(); ++x) {
            String nr = (String)netletRules.get(x);
            if (nr.endsWith("EXTEND")) {
                nr = nr.substring(0, nr.lastIndexOf("|"));
            }
            StringTokenizer tok = new StringTokenizer(nr, "|");
            boolean isTarget = false;
            try {
                String func = (String)tok.nextElement();
                String tmp = (String)tok.nextElement();
                tmp = (String)tok.nextElement();
                while (tok.hasMoreElements() && !isTarget) {
                    tmp = (String)tok.nextElement();
                    tmp = (String)tok.nextElement();
                    if (tmp.equals("TARGET")) {
                        return true;
                    }
                    tmp = (String)tok.nextElement();
                }
                continue;
            }
            catch (NoSuchElementException nsee) {
                // empty catch block
            }
        }
        return false;
    }

    private String trimHostNamesList(String hostNames) {
        String newHostNameList = null;
        StringTokenizer st = new StringTokenizer(hostNames, "+");
        try {
            newHostNameList = st.nextToken().trim();
            while (st.hasMoreTokens()) {
                newHostNameList = newHostNameList + "+";
                newHostNameList = newHostNameList + st.nextToken().trim();
            }
        }
        catch (NoSuchElementException nse) {
            this.getProviderContext().debugError((Object)("NetletProvider: Invalid hostname(s) -> " + nse));
        }
        return newHostNameList;
    }

    private List updateTargets(List currentTargets, List currentRules) {
        if (currentTargets == null || currentTargets.isEmpty()) {
            return currentTargets;
        }
        ArrayList newTargets = new ArrayList();
        for (int i = 0; i < currentTargets.size(); ++i) {
            Target target = new Target((String)currentTargets.get(i));
            if (!this.hasDynamicRule(currentRules, target.getName())) continue;
            newTargets.add(currentTargets.get(i));
        }
        return newTargets;
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer content = new StringBuffer();
        StringBuffer targetsToSet = new StringBuffer(100);
        UserAttributes attrs = this.getNetletUserAttributes(req);
        String launchModeStr = attrs.getString("sunPortalNetletLaunchMode");
        boolean jwsMode = false;
        if (launchModeStr != null && launchModeStr.equalsIgnoreCase("Java Web Start")) {
            jwsMode = true;
        }
        List netletRules = attrs.getStringList("sunPortalNetletRules");
        boolean serviceEnabled = attrs.isAllowed();
        boolean noNetletRules = netletRules == null || netletRules.isEmpty();
        boolean openPortal = true;
        boolean netletDisabled = true;
        String psNetletHeader = req.getHeader("PS-Netlet");
        this.getProviderContext().debugMessage((Object)("Netlet header -> " + psNetletHeader));
        if (psNetletHeader != null) {
            String token;
            openPortal = false;
            StringTokenizer tokenizer = new StringTokenizer(psNetletHeader, ";");
            if (tokenizer.hasMoreTokens() && "enabled=true".equals(token = tokenizer.nextToken().trim())) {
                netletDisabled = false;
            }
        }
        if (!serviceEnabled || noNetletRules || openPortal || netletDisabled) {
            content.append("<table><tr><td>\n").append("<font FACE=\"").append(this.getStringProperty("fontFace1")).append("\" size=\"-1\">\n");
            if (openPortal) {
                content.append(this.bundle.getString("noGateway"));
            } else if (netletDisabled) {
                content.append(this.bundle.getString("netletDisabled"));
            } else if (!serviceEnabled) {
                content.append(this.bundle.getString("noService"));
            } else if (noNetletRules) {
                content.append(this.bundle.getString("noRules"));
            }
            content.append("</font></td></tr></table>\n");
            return content;
        }
        String ncURI = this.getNetletConfigURI(req);
        String ncStartURL = ncURI + "?func=makepage";
        String ncJNLPStartURL = ncURI + "?func=makeJnlpPage&startNetlet=true";
        ArrayList targets = null;
        try {
            Map l = this.getProviderContext().getCollectionProperty(this.getName(), "targets");
            if (l != null || !l.isEmpty()) {
                targets = new ArrayList(l.values());
            }
        }
        catch (ProviderContextException pce) {
            this.getProviderContext().debugError((Object)"NetletProvider: getContent() Unable to retrieve current targets", (Throwable)pce);
            targets = null;
        }
        targets = this.updateTargets(targets, netletRules);
        boolean hasTargets = targets != null && !targets.isEmpty();
        boolean hasDynamicRule = this.hasDynamicRule(netletRules);
        boolean startNetlet = this.hasStaticRule(netletRules);
        if (!startNetlet) {
            String macload = req.getParameter("macload");
            String agent = req.getHeader("user-agent");
            if (macload != null && macload.equals("dynamic") || agent != null && agent.indexOf("Mac_PowerPC") != -1 && agent.indexOf("MSIE") != -1) {
                startNetlet = true;
            }
        }
        content.append("<table><tr><td>\n").append("<font FACE=\"[tag:iwtDesktop-fontFace1]\" ").append("size=\"-1\">\n");
        if (!hasTargets && hasDynamicRule) {
            content.append(this.bundle.getString("noTargets"));
        } else {
            String wait = "";
            wait = startNetlet ? this.bundle.getString("wait") : this.bundle.getString("targets");
            content.append(wait);
        }
        content.append("</font>\n");
        if (startNetlet) {
            int response = 0;
            try {
                response = this.callNetletConfig("isLoaded", req);
                if (response == 204) {
                    this.callNetletConfig("setLoading", req);
                    if (jwsMode) {
                        content.append("<script language=\"JavaScript\">\n").append("launchJWS(\"").append(ncJNLPStartURL).append("\", null );\n").append("</script>\n");
                    } else {
                        content.append("<script language=\"JavaScript\">\n").append("netletWinOpen(\"").append(ncStartURL).append("\", true );\n").append("</script>\n");
                    }
                }
            }
            catch (IOException mue) {
                this.getProviderContext().debugError((Object)("NetletProvider.getContent()" + mue));
                throw new ProviderException("invalid netlet config url", (Throwable)mue);
            }
            catch (ContextException ce) {
                this.getProviderContext().debugError((Object)("NetletProvider.getContent()" + (Object)((Object)ce)));
                throw new ProviderException("error calling netlet config", (Throwable)ce);
            }
            catch (SSOException ssoe) {
                this.getProviderContext().debugError((Object)("NetletProvider.getContent()" + (Object)((Object)ssoe)));
                throw new ProviderException("error calling netlet config", (Throwable)ssoe);
            }
        }
        content.append("<br><hr></td></tr>\n");
        if (hasTargets) {
            for (int x = 0; x < targets.size(); ++x) {
                String targ = (String)targets.get(x);
                Target target = new Target(targ);
                String trimmedValue = this.trimHostNamesList(target.getValue());
                StringBuffer url = new StringBuffer().append(ncURI).append("?func=").append(UrlEncoder.encode(target.getName())).append("&machine=").append(trimmedValue);
                targetsToSet.append(target.getName()).append("=").append(trimmedValue).append("|");
                StringTokenizer st = new StringTokenizer(target.getValue(), "+");
                String displayName = "";
                if (st.countTokens() == 1) {
                    displayName = target.getValue().trim();
                } else {
                    try {
                        displayName = "[ " + st.nextToken().trim();
                        while (st.hasMoreElements()) {
                            displayName = displayName + ", ";
                            displayName = displayName + st.nextToken().trim();
                        }
                        displayName = displayName + " ]";
                    }
                    catch (NoSuchElementException nse) {
                        this.getProviderContext().debugError((Object)"NetletProvider.getContent(): error reading target hosts");
                    }
                }
                StringBuffer href = new StringBuffer().append("<a href=\"#");
                if (jwsMode) {
                    href.append("\" onClick=\"launchJWS(");
                    if (startNetlet) {
                        href.append("null, '");
                    } else {
                        href.append("'" + ncJNLPStartURL + "', '");
                    }
                } else {
                    href.append("\" onClick=\"netletConfigOpen('").append(ncStartURL + "', '");
                }
                href.append(url.toString()).append("'); return false;\">").append(target.getName()).append(" " + this.bundle.getString("NameHostSeparator") + " ").append(displayName).append("</a>\n");
                StringBuffer row = new StringBuffer().append("<tr><td><font FACE=\"[tag:iwtDesktop-fontFace1]\" ").append("size=\"-1\">").append(href.toString()).append("</font></td></tr>\n");
                content.append(row.toString());
            }
        }
        content.append("</table>\n");
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        tagTable.put("content", content.toString());
        tagTable.put("iwtDesktop-fontFace1", this.getStringProperty("fontFace1"));
        content = this.getTemplate("display.template", tagTable);
        return content;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String invalidHost;
        StringBuffer content = new StringBuffer();
        StringBuffer targetList = new StringBuffer("");
        this.editContainer = req.getParameter("provider");
        this.container = req.getParameter("containerName");
        ArrayList targets = null;
        UserAttributes attrs = this.getNetletUserAttributes(req);
        List netletRules = attrs.getStringList("sunPortalNetletRules");
        try {
            Map l = this.getProviderContext().getCollectionProperty(this.getName(), "targets");
            if (l != null || !l.isEmpty()) {
                targets = new ArrayList(l.values());
            }
        }
        catch (ProviderContextException pce) {
            this.getProviderContext().debugError((Object)"NetletProvider: getEdit() Unable to retrieve current targets", (Throwable)pce);
            targets = null;
        }
        targets = this.updateTargets(targets, netletRules);
        boolean hasTargets = targets != null && !targets.isEmpty();
        int count = 0;
        if (hasTargets) {
            for (int x = 0; x < targets.size(); ++x) {
                String targ = (String)targets.get(x);
                Target target = new Target(targ);
                targetList.append("<TR><TD><CENTER><INPUT TYPE=\"CHECKBOX\" ").append("VALUE=\"1\" NAME=\"remove").append(count).append("\"></CENTER></TD>\n").append("<TD><FONT FACE=\"[tag:iwtDesktop-fontFace1]\" ").append("SIZE=\"+0\">\n").append(this.genRuleSelect("rule" + count, target.getName(), req)).append("\n</FONT></TD>\n").append("<TD><FONT FACE=").append("\"[tag:iwtDesktop-fontFace1]\" ").append("SIZE=\"+0\"><INPUT TYPE=\"TEXT\" ").append("RPROXY-NOPARSE VALUE=\"").append(this.trimHostNamesList(target.getValue())).append("\" SIZE=\"30\" NAME=\"host").append(count).append("\"></FONT></TD></TR>\n");
                ++count;
            }
        }
        String newRuleSelect = this.genRuleSelect("newRule", req);
        String newAlgorithmSelect = this.genAlgorithmSelect(req);
        String string = invalidHost = this.bundle == null ? null : this.bundle.getString("invalidHost");
        if (invalidHost == null || invalidHost.trim().length() == 0) {
            invalidHost = new String("You must enter a valid host name(s).");
        }
        Hashtable<String, CharSequence> tagTable = new Hashtable<String, CharSequence>();
        String targetCount = Integer.toString(count);
        tagTable.put("targetCount", targetCount);
        tagTable.put("targetList", targetList.toString());
        tagTable.put("newRuleSelect", newRuleSelect);
        tagTable.put("launchModeSelect", this.genLaunchModeSelect("launchMode", req));
        tagTable.put("newAlgorithmSelect", newAlgorithmSelect);
        tagTable.put("clientBindIP", attrs.getString("sunPortalNetletClientBindIP", "127.0.0.1"));
        tagTable.put("invalidHostName", invalidHost);
        tagTable.put("iwtDesktop-fontFac/e1", this.getStringProperty("fontFace1"));
        if (this.isReauthEnabled(req)) {
            Hashtable<String, String> changePasswordTagTable = new Hashtable<String, String>();
            if (this.statusMsg != null && this.statusMsg.trim().length() != 0) {
                changePasswordTagTable.put("changePasswdMsg", this.statusMsg);
                this.statusMsg = null;
            }
            StringBuffer changePasswordTemplate = this.getTemplate("changepassword.template", changePasswordTagTable);
            tagTable.put("changePasswordTemplate", changePasswordTemplate);
        }
        content = this.getTemplate("edit.template", tagTable);
        return content;
    }

    public Vector getExistingTargets(ParameterMap params, boolean ignoreRemove) {
        int targetCount = params.getInt("targetCount");
        Vector<String> targets = new Vector<String>();
        boolean removeFlag = false;
        for (int i = 0; i < targetCount; ++i) {
            if (!ignoreRemove) {
                String checkBoxValue = params.getString("remove" + i);
                boolean bl = checkBoxValue == null ? false : (removeFlag = checkBoxValue.trim().equals("1"));
            }
            if (removeFlag) continue;
            String ruleString = "rule" + i;
            String hostString = "host" + i;
            String rule = params.getString(ruleString);
            String host = params.getString(hostString);
            if (!I18n.isAscii((String)host)) {
                this.getProviderContext().debugError((Object)"NetletProvider: Non ascii host name(s) is not allowed");
                continue;
            }
            if (host == null || host.trim().equals("")) {
                this.getProviderContext().debugError((Object)"NetletProvider: Empty host name(s) is not allowed");
                continue;
            }
            Target target = new Target(rule, host);
            targets.add(target.toString());
        }
        return targets;
    }

    private SSOToken getSSOToken(HttpServletRequest req) {
        SSOToken ssoToken = null;
        try {
            ssoToken = SSOTokenManager.getInstance().createSSOToken(req);
            ssoToken = SSOTokenManager.getInstance().createSSOToken(req);
        }
        catch (SSOException ssoe) {
            this.getProviderContext().debugError((Object)("NetletProvider: Unable to create ssoToken -> " + (Object)((Object)ssoe)));
        }
        return ssoToken;
    }

    private UserAttributes getNetletUserAttributes(HttpServletRequest req) {
        SSOToken ssoToken = this.getSSOToken(req);
        UserAttributes netletuserAttrs = new UserAttributes(ssoToken);
        try {
            this.netletStatus = ssoToken.getProperty("ClientStatus");
        }
        catch (SSOException e) {
            this.getProviderContext().debugError((Object)("SSOException " + (Object)((Object)e)));
        }
        return netletuserAttrs;
    }

    private ParameterMap getParameterMap(HttpServletRequest req) {
        ParameterMap map = null;
        try {
            map = new ParameterMap(this.getProviderContext().getCharset(), req, true);
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] val = req.getParameterValues(name);
                map.put((Object)name, (Object)val);
            }
        }
        catch (DesktopException de) {
            this.getProviderContext().debugError((Object)("NetletProvider: Unable to get page parameters -> " + (Object)((Object)de)));
        }
        return map;
    }

    private URL getNetletProviderURL(HttpServletRequest req) {
        URL netletProviderURL = null;
        try {
            netletProviderURL = new URL(this.getProviderContext().getDesktopURL(req) + "?action=edit&provider=" + URLEncoder.encode(this.editContainer) + "&targetprovider=" + URLEncoder.encode(this.getName()) + "&containerName=" + URLEncoder.encode(this.container));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return netletProviderURL;
    }

    private void addTarget(ParameterMap params, Vector targets) {
        String newHost;
        if (targets == null) {
            targets = new Vector<String>();
        }
        if ((newHost = params.getString("newHost")) != null && !newHost.equals("")) {
            if (!I18n.isAscii((String)newHost)) {
                this.getProviderContext().debugError((Object)"NetletProvider: Can not add non ascii host name.");
            }
            String newRule = params.getString("newRule");
            Target target = new Target(newRule, newHost);
            targets.add(target.toString());
        }
        try {
            this.getProviderContext().setCollectionProperty(this.getName(), "targets", targets);
        }
        catch (ProviderContextException pce) {
            this.getProviderContext().debugError((Object)"NetletProvider: Unable to add new target to the list", (Throwable)pce);
        }
    }

    private void changePassword(ParameterMap params, UserAttributes netletuserAttrs) {
        String password = netletuserAttrs.getString("sunPortalNetletPassword", "srap-netlet");
        String oldPassword = params.getString("oldPassword");
        String newPassword = params.getString("newPassword");
        String confirmNewPassword = params.getString("confirmNewPassword");
        if (!password.equals(oldPassword)) {
            this.statusMsg = this.bundle.getString("authError");
        } else if (newPassword == null || newPassword.trim().length() == 0) {
            this.statusMsg = this.bundle.getString("emptyPasswd");
        } else if (!newPassword.equals(confirmNewPassword)) {
            this.statusMsg = this.bundle.getString("checkFailed");
        } else {
            netletuserAttrs.setString("sunPortalNetletPassword", newPassword);
            this.statusMsg = this.bundle.getString("passwdChanged");
        }
    }

    private void changeAlgorithm(ParameterMap params, UserAttributes netletuserAttrs) {
        List netletRules = netletuserAttrs.getStringList("sunPortalNetletRules");
        ArrayList<String> userCiphers = new ArrayList<String>();
        for (int x = 0; x < netletRules.size(); ++x) {
            String nr = (String)netletRules.get(x);
            if (nr.endsWith("EXTEND")) {
                nr = nr.substring(0, nr.lastIndexOf("|"));
            }
            StringTokenizer tok = new StringTokenizer(nr, "|");
            boolean isTarget = false;
            try {
                String func = (String)tok.nextElement();
                tok = new StringTokenizer(func, "^");
                String rulename = (String)tok.nextElement();
                StringBuffer sbuffer = new StringBuffer();
                sbuffer.append(rulename);
                String[] algos = params.getArray(rulename);
                if (algos == null) continue;
                boolean algoAppended = false;
                for (int i = 0; i < algos.length; ++i) {
                    if (algos[i].trim().length() == 0) continue;
                    sbuffer.append("|" + algos[i]);
                    algoAppended = true;
                }
                if (!algoAppended) continue;
                userCiphers.add(sbuffer.toString());
                continue;
            }
            catch (NoSuchElementException nsee) {
                this.getProviderContext().debugError((Object)("processEdit() - " + nsee));
            }
        }
        netletuserAttrs.setStringList("sunPortalNetletUserCipher", userCiphers);
    }

    private void changeClientBindIP(ParameterMap params, UserAttributes netletuserAttrs) {
        String clientBindIP = netletuserAttrs.getString("sunPortalNetletClientBindIP", "127.0.0.1");
        String newClientBindIP = params.getString("clientBindIP");
        if (clientBindIP != null && !clientBindIP.equals(newClientBindIP)) {
            netletuserAttrs.setString("sunPortalNetletClientBindIP", newClientBindIP);
        }
    }

    private void changeLaunchMode(ParameterMap params, UserAttributes netletuserAttrs) {
        String launchMode = netletuserAttrs.getString("sunPortalNetletLaunchMode");
        String newLaunchMode = params.getString("launchMode");
        if (launchMode != null && !launchMode.equals(newLaunchMode)) {
            netletuserAttrs.setString("sunPortalNetletLaunchMode", newLaunchMode);
        }
    }

    private void processFinished(ParameterMap params, Vector targets, UserAttributes netletuserAttrs) {
        this.addTarget(params, targets);
        if (this.netletStatus == null || this.netletStatus.trim().equals("UNLOADED")) {
            this.changeLaunchMode(params, netletuserAttrs);
        }
        this.changeAlgorithm(params, netletuserAttrs);
        this.changeClientBindIP(params, netletuserAttrs);
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ParameterMap params = this.getParameterMap(req);
        if (params == null) {
            return null;
        }
        this.editContainer = req.getParameter("provider");
        this.container = req.getParameter("containerName");
        UserAttributes netletuserAttrs = this.getNetletUserAttributes(req);
        Vector targets = null;
        String addMore = params.getString("add_more");
        String changePassword = params.getString("change_password");
        if (addMore != null && addMore.length() > 0) {
            try {
                targets = new Vector(this.getProviderContext().getCollectionProperty(this.getName(), "targets").values());
            }
            catch (ProviderContextException pce) {
                this.getProviderContext().debugError((Object)"NetletProvider: Unable to retrieve existing targets", (Throwable)pce);
            }
            this.addTarget(params, targets);
            return this.getNetletProviderURL(req);
        }
        if (changePassword != null && changePassword.trim().length() > 0) {
            this.changePassword(params, netletuserAttrs);
            return this.getNetletProviderURL(req);
        }
        targets = this.getExistingTargets(params, false);
        this.processFinished(params, targets, netletuserAttrs);
        super.processEdit((Map)params);
        return null;
    }

    private String genLaunchModeSelect(String name, HttpServletRequest httpreq) {
        StringBuffer ruleSelect = new StringBuffer();
        ruleSelect.append("<select name=\"").append(name).append("\">\n");
        UserAttributes attrs = this.getNetletUserAttributes(httpreq);
        String launchModeStr = attrs.getString("sunPortalNetletLaunchMode");
        ruleSelect.append("<option selected>").append(launchModeStr).append("</option>\n");
        if (launchModeStr != null && launchModeStr.equalsIgnoreCase("Applet")) {
            ruleSelect.append("<option>").append("Java Web Start").append("</option>\n");
        } else {
            ruleSelect.append("<option>").append("Applet").append("</option>\n");
        }
        ruleSelect.append("</select>\n");
        return ruleSelect.toString();
    }

    private String genRuleSelect(String name, HttpServletRequest httpreq) {
        return this.genRuleSelect(name, "", httpreq);
    }

    private String genRuleSelect(String name, String selected, HttpServletRequest httpreq) {
        StringBuffer ruleSelect = new StringBuffer(512);
        ruleSelect.append("<select name=\"").append(name).append("\">\n");
        UserAttributes attrs = this.getNetletUserAttributes(httpreq);
        List netletRules = attrs.getStringList("sunPortalNetletRules");
        for (int x = 0; x < netletRules.size(); ++x) {
            String nr = (String)netletRules.get(x);
            if (nr.endsWith("EXTEND")) {
                nr = nr.substring(0, nr.lastIndexOf("|"));
            }
            StringTokenizer tok = new StringTokenizer(nr, "|");
            boolean isTarget = false;
            try {
                String func = (String)tok.nextElement();
                String tmp = (String)tok.nextElement();
                tmp = (String)tok.nextElement();
                while (tok.hasMoreElements() && !isTarget) {
                    tmp = (String)tok.nextElement();
                    tmp = (String)tok.nextElement();
                    if (tmp.equals("TARGET")) {
                        isTarget = true;
                    }
                    tmp = (String)tok.nextElement();
                }
                if (!isTarget) continue;
                tok = new StringTokenizer(func, "^");
                if ((func = (String)tok.nextElement()).equals(selected)) {
                    ruleSelect.append("<option selected>").append(func).append("</option>\n");
                    continue;
                }
                ruleSelect.append("<option>").append(func).append("</option>\n");
                continue;
            }
            catch (NoSuchElementException nsee) {
                // empty catch block
            }
        }
        ruleSelect.append("</select>\n");
        return ruleSelect.toString();
    }

    private String genAlgorithmSelect(HttpServletRequest httpreq) {
        StringBuffer algorithmSelect = new StringBuffer();
        UserAttributes netletuserAttrs = this.getNetletUserAttributes(httpreq);
        List netletRules = netletuserAttrs.getStringList("sunPortalNetletRules");
        List netletUserciphers = netletuserAttrs.getStringList("sunPortalNetletUserCipher");
        for (int x = 0; x < netletRules.size(); ++x) {
            String nr = (String)netletRules.get(x);
            if (nr.endsWith("EXTEND")) {
                nr = nr.substring(0, nr.lastIndexOf("|"));
            }
            StringTokenizer tok = new StringTokenizer(nr, "|");
            boolean isTarget = false;
            try {
                String func = (String)tok.nextElement();
                tok = new StringTokenizer(func, "^");
                String rulename = (String)tok.nextElement();
                Vector<String> selectAlgo = new Vector<String>();
                if (!tok.hasMoreElements()) {
                    selectAlgo.add(netletuserAttrs.getString("sunPortalNetletKSSLDefaultCipher", "KSSL_SSL3_RSA_WITH_RC4_128_MD5"));
                    selectAlgo.add(netletuserAttrs.getString("sunPortalNetletJSSEDefaultCipher", "SSL_RSA_WITH_RC4_128_MD5"));
                } else {
                    selectAlgo.add((String)tok.nextElement());
                }
                algorithmSelect.append("<tr>");
                algorithmSelect.append("<td align=right width=35%>");
                algorithmSelect.append("<font face=\"[tag:iwtDesktop-fontFace1]\" size=+0>");
                algorithmSelect.append("<b>");
                algorithmSelect.append(rulename);
                algorithmSelect.append(": </b></font></td>");
                algorithmSelect.append("<td>");
                algorithmSelect.append("<font face=\"[tag:iwtDesktop-fontFace1]\" size=+0>");
                algorithmSelect.append("<select multiple size=\"8\" name=\"" + rulename + "\">");
                if (tok.hasMoreElements()) {
                    selectAlgo = new Vector();
                    for (int i = 0; i < netletUserciphers.size(); ++i) {
                        String algoString = (String)netletUserciphers.get(i);
                        StringTokenizer tmp_st = new StringTokenizer(algoString, "|");
                        String tmp_rulename = tmp_st.nextToken();
                        if (!rulename.equals(tmp_rulename)) continue;
                        while (tmp_st.hasMoreTokens()) {
                            selectAlgo.add(tmp_st.nextToken());
                        }
                        break;
                    }
                    tok = new StringTokenizer((String)tok.nextElement(), "+");
                    while (tok.hasMoreElements()) {
                        String algo = (String)tok.nextElement();
                        if (selectAlgo.contains(algo)) {
                            algorithmSelect.append("<option selected value=\"" + algo + "\">" + algo);
                            continue;
                        }
                        algorithmSelect.append("<option value=\"" + algo + "\">" + algo);
                    }
                } else {
                    Iterator iter = selectAlgo.iterator();
                    while (iter.hasNext()) {
                        String algo = (String)iter.next();
                        algorithmSelect.append("<option selected value=\"" + algo + "\">" + algo);
                    }
                }
                algorithmSelect.append("<option value=\"\">__________________________________________________</option>");
                algorithmSelect.append("</select></font></td></tr>");
                algorithmSelect.append("<tr><td></td></tr>");
                continue;
            }
            catch (NoSuchElementException nsee) {
                this.getProviderContext().debugError((Object)"genAlgorithmSelect() - ", (Throwable)nsee);
                continue;
            }
            catch (Exception ex) {
                this.getProviderContext().debugError((Object)"genAlgorithmSelect() - ", (Throwable)ex);
            }
        }
        return algorithmSelect.toString();
    }
}

