/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.ui.CacheableProcessor;
import com.iplanet.xslui.ui.CacheableTranslator;
import com.iplanet.xslui.ui.CacheableXML;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XMLTranslator;
import com.iplanet.xslui.xslutil.XSLProcessorPool;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.w3c.dom.Document;

public class XSLXMLCache {
    private boolean _reloadOnChange = false;
    private Hashtable _xmlHashtable = null;
    private Hashtable _transHashtable = null;
    private Hashtable _xslHashtable = null;
    private XSLXMLLogHandler _logHandler = null;
    private String _uiRootPath = null;

    public XSLXMLCache(boolean reloadOnChange, XSLXMLLogHandler logHandler, String uiRootPath) {
        this._reloadOnChange = reloadOnChange;
        this._xmlHashtable = new Hashtable();
        this._transHashtable = new Hashtable();
        this._xslHashtable = new Hashtable();
        this._logHandler = logHandler;
        this._uiRootPath = uiRootPath;
    }

    public XSLXMLCache(boolean reloadOnChange, XSLXMLLogHandler logHandler) {
        this._reloadOnChange = reloadOnChange;
        this._xmlHashtable = new Hashtable();
        this._transHashtable = new Hashtable();
        this._xslHashtable = new Hashtable();
        this._logHandler = logHandler;
    }

    public Document getXMLTemplateDocument(String fileName, String[] pathList) throws XMLProcessingException {
        return this.getXMLTemplateDocument(fileName, null, pathList);
    }

    public CacheableXML getXMLTemplateCacheable(String fileName, String[] pathList) throws XMLProcessingException {
        return this.getXMLTemplateCacheable(fileName, null, pathList);
    }

    public Document getXMLTemplateDocument(String fileName, String dictionaryName, String[] pathList) throws XMLProcessingException {
        CacheableXML cacheEntry = this.getXMLTemplateCacheable(fileName, dictionaryName, pathList);
        return (Document)cacheEntry.getObject();
    }

    public CacheableXML getXMLTemplateCacheable(String fileName, String dictionaryName, String[] pathList) throws XMLProcessingException {
        CacheableXML cacheEntry = null;
        String id = dictionaryName != null ? pathList[0] + fileName + "." + dictionaryName : pathList[0] + fileName;
        cacheEntry = (CacheableXML)this._xmlHashtable.get(id);
        if (cacheEntry != null) {
            boolean isOutdated = false;
            if (this._reloadOnChange) {
                isOutdated = cacheEntry.isOutdated();
            }
            if (!isOutdated) {
                return cacheEntry;
            }
            this._xmlHashtable.remove(id);
        }
        if ((cacheEntry = this.findCacheableXML(fileName, dictionaryName, pathList, true)) == null) {
            return null;
        }
        return cacheEntry;
    }

    protected synchronized CacheableXML findCacheableXML(String fileName, String dictionaryName, String[] pathList, boolean loopThroughList) throws XMLProcessingException {
        CacheableXML cacheEntry = null;
        CacheableXML currentCacheEntry = null;
        String filePath = pathList[0] + fileName;
        String id = dictionaryName != null ? filePath + "." + dictionaryName : filePath;
        cacheEntry = (CacheableXML)this._xmlHashtable.get(id);
        if (cacheEntry != null) {
            boolean isOutdated = false;
            if (this._reloadOnChange) {
                isOutdated = cacheEntry.isOutdated();
            }
            if (!isOutdated) {
                return cacheEntry;
            }
            this._xmlHashtable.remove(id);
        }
        if (dictionaryName == null) {
            File xmlDocFile = new File(filePath);
            if (xmlDocFile.isFile()) {
                cacheEntry = new CacheableXML(xmlDocFile, this._logHandler);
                this._xmlHashtable.put(id, cacheEntry);
                return cacheEntry;
            }
        } else {
            currentCacheEntry = this.findCacheableXML(fileName, null, pathList, false);
            if (currentCacheEntry != null && currentCacheEntry.getType() == 1) {
                CacheableTranslator cacheableTranslator = this.findCacheableTranslator(dictionaryName, pathList, false);
                if (cacheableTranslator != null) {
                    XMLTranslator translator = (XMLTranslator)cacheableTranslator.getObject();
                    Document origDoc = (Document)currentCacheEntry.getObject();
                    Document newDoc = null;
                    newDoc = translator.translate(origDoc);
                    cacheEntry = new CacheableXML(this._logHandler);
                    cacheEntry.setObject(newDoc);
                    cacheEntry.dependsOn(currentCacheEntry);
                    cacheEntry.dependsOn(cacheableTranslator);
                    this._xmlHashtable.put(id, cacheEntry);
                    return cacheEntry;
                }
                cacheEntry = new CacheableXML(this._logHandler);
                cacheEntry.setParent(currentCacheEntry);
                this._xmlHashtable.put(id, cacheEntry);
                return cacheEntry;
            }
        }
        if (!loopThroughList) {
            return null;
        }
        if (pathList.length <= 1) {
            return null;
        }
        String[] newPathList = new String[pathList.length - 1];
        System.arraycopy(pathList, 1, newPathList, 0, pathList.length - 1);
        currentCacheEntry = this.findCacheableXML(fileName, dictionaryName, newPathList, true);
        if (currentCacheEntry != null) {
            cacheEntry = new CacheableXML(this._logHandler);
            cacheEntry.setParent(currentCacheEntry);
            this._xmlHashtable.put(id, cacheEntry);
            return cacheEntry;
        }
        return null;
    }

    public XMLTranslator getXMLTranslator(String dictionaryName, String[] pathList) throws XMLProcessingException {
        CacheableTranslator cacheEntry = null;
        String id = pathList[0] + dictionaryName;
        cacheEntry = (CacheableTranslator)this._transHashtable.get(id);
        if (cacheEntry != null) {
            boolean isOutdated = false;
            if (this._reloadOnChange) {
                isOutdated = cacheEntry.isOutdated();
            }
            if (!isOutdated) {
                return (XMLTranslator)cacheEntry.getObject();
            }
            this._transHashtable.remove(id);
        }
        if ((cacheEntry = this.findCacheableTranslator(dictionaryName, pathList, false)) == null) {
            return null;
        }
        return (XMLTranslator)cacheEntry.getObject();
    }

    public XSLProcessorPool getXSLProcessorPool(String fileName, String dictionaryName, String[] pathList) throws XMLProcessingException {
        CacheableProcessor cacheEntry = null;
        String id = dictionaryName != null ? pathList[0] + fileName + "." + dictionaryName : pathList[0] + fileName;
        cacheEntry = (CacheableProcessor)this._xslHashtable.get(id);
        if (cacheEntry != null) {
            boolean isOutdated = false;
            if (this._reloadOnChange) {
                isOutdated = cacheEntry.isOutdated();
            }
            if (!isOutdated) {
                return (XSLProcessorPool)cacheEntry.getObject();
            }
            this._xslHashtable.remove(id);
        }
        if ((cacheEntry = this.findCacheableProcessor(fileName, dictionaryName, pathList, true)) == null) {
            return null;
        }
        return (XSLProcessorPool)cacheEntry.getObject();
    }

    public void clear() {
        this._xmlHashtable.clear();
        this._transHashtable.clear();
        this._xslHashtable.clear();
    }

    private synchronized CacheableTranslator findCacheableTranslator(String dictionaryName, String[] pathList, boolean loopThroughList) {
        CacheableTranslator cacheEntry = null;
        CacheableTranslator currentCacheEntry = null;
        String id = pathList[0] + dictionaryName;
        int end = 1;
        if (loopThroughList) {
            end = pathList.length;
        }
        for (int i = 0; i < end; ++i) {
            File xmlDocFile;
            String filePath = pathList[i] + dictionaryName;
            currentCacheEntry = (CacheableTranslator)this._transHashtable.get(filePath);
            if (currentCacheEntry != null) {
                boolean isOutdated = false;
                if (this._reloadOnChange) {
                    try {
                        isOutdated = currentCacheEntry.isOutdated();
                    }
                    catch (XMLProcessingException xpe) {
                        this._logHandler.error("XSLXMLCache.findCacheableTranslator: got " + xpe.getMessage() + " while processing " + filePath);
                    }
                }
                if (!isOutdated) {
                    if (i != 0) {
                        cacheEntry = new CacheableTranslator(this._logHandler);
                        cacheEntry.setParent(currentCacheEntry);
                        this._transHashtable.put(id, cacheEntry);
                        return cacheEntry;
                    }
                    return currentCacheEntry;
                }
                this._transHashtable.remove(filePath);
            }
            if (!(xmlDocFile = new File(filePath)).isFile()) continue;
            try {
                currentCacheEntry = new CacheableTranslator(xmlDocFile, this._logHandler);
            }
            catch (XMLProcessingException xe) {
                this._logHandler.error("XSLXMLCache.findCacheableTranslator: Couldn't parse " + filePath + " : " + xe.getMessage());
                return null;
            }
            this._transHashtable.put(filePath, currentCacheEntry);
            if (i != 0) {
                cacheEntry = new CacheableTranslator(this._logHandler);
                cacheEntry.setParent(currentCacheEntry);
                this._transHashtable.put(id, cacheEntry);
                return cacheEntry;
            }
            return currentCacheEntry;
        }
        return null;
    }

    private synchronized CacheableProcessor findCacheableProcessor(String fileName, String dictionaryName, String[] pathList, boolean loopThroughList) throws XMLProcessingException {
        CacheableProcessor cacheEntry = null;
        CacheableProcessor currentCacheEntry = null;
        String filePath = pathList[0] + fileName;
        String id = dictionaryName != null ? filePath + "." + dictionaryName : filePath;
        if (this._uiRootPath != null) {
            try {
                File fl = new File(id);
                id = fl.getCanonicalPath();
                fl = new File(this._uiRootPath);
                this._uiRootPath = fl.getAbsoluteFile().getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new XMLProcessingException("findCacheableProcessor: Trouble getting the canonical path of either: " + id + " or " + this._uiRootPath);
            }
            id = id.substring(this._uiRootPath.length());
            id = id.replace('.', '_');
            id = id.replace('-', '_');
            id = id.replace('/', '_');
        }
        if ((cacheEntry = (CacheableProcessor)this._xslHashtable.get(id)) != null) {
            boolean isOutdated = false;
            if (this._reloadOnChange) {
                isOutdated = cacheEntry.isOutdated();
            }
            if (!isOutdated) {
                return cacheEntry;
            }
            this._xslHashtable.remove(id);
        }
        if (new File(pathList[0]).isDirectory()) {
            cacheEntry = new CacheableProcessor(fileName, dictionaryName, pathList, this, this._logHandler, id);
            this._xslHashtable.put(id, cacheEntry);
            return cacheEntry;
        }
        String[] newPathList = new String[pathList.length - 1];
        System.arraycopy(pathList, 1, newPathList, 0, pathList.length - 1);
        currentCacheEntry = this.findCacheableProcessor(fileName, dictionaryName, newPathList, true);
        if (currentCacheEntry != null) {
            cacheEntry = new CacheableProcessor(this._logHandler);
            cacheEntry.setParent(currentCacheEntry);
            this._xslHashtable.put(id, cacheEntry);
            return cacheEntry;
        }
        return null;
    }
}

