/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.ui.CacheableObject;
import com.iplanet.xslui.ui.CacheableXML;
import com.iplanet.xslui.ui.XSLXMLCache;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLIncludeResolver;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import com.iplanet.xslui.xslutil.XSLProcessorPool;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import org.w3c.dom.Document;

public class CacheableProcessor
extends CacheableObject
implements XSLIncludeResolver {
    private String _fileName = null;
    private String _dictionaryName = null;
    private String[] _pathList = null;
    private XSLXMLCache _cache = null;

    public CacheableProcessor(XSLXMLLogHandler errorHandler) {
        super(errorHandler);
    }

    public CacheableProcessor(String fileName, String dictionaryName, String[] pathList, XSLXMLCache cache, XSLXMLLogHandler errorHandler, String id) throws XMLProcessingException {
        super(errorHandler);
        this._fileName = fileName;
        this._dictionaryName = dictionaryName;
        this._pathList = pathList;
        this._cache = cache;
        CacheableXML cacheEntry = cache.findCacheableXML(this._fileName, this._dictionaryName, this._pathList, true);
        if (cacheEntry == null) {
            throw new XMLProcessingException("CacheableProcessor: Couldn't find " + this._pathList[0] + this._fileName + "." + this._dictionaryName);
        }
        Document xmlDoc = (Document)cacheEntry.getObject();
        XSLProcessorPool processorPool = new XSLProcessorPool();
        processorPool.setXSLDoc(xmlDoc);
        processorPool.setCacheHandler((XSLIncludeResolver)this);
        processorPool.setErrorHandler(this._errorHandler);
        processorPool.setId(id);
        super.setObject(processorPool);
        super.dependsOn(cacheEntry);
    }

    public Document getXSLInclude(String includeFileName) throws XSLProcessingException {
        CacheableXML cacheEntry = null;
        try {
            cacheEntry = this._cache.findCacheableXML(includeFileName, this._dictionaryName, this._pathList, true);
        }
        catch (XMLProcessingException xe) {
            throw new XSLProcessingException("CacheableProcessor: Can't find cache for " + this._pathList[0] + includeFileName + "." + this._dictionaryName + " : " + xe.getMessage());
        }
        if (cacheEntry == null) {
            throw new XSLProcessingException("CacheableProcessor: Couldn't find " + this._pathList[0] + includeFileName + "." + this._dictionaryName);
        }
        Document xmlDoc = (Document)cacheEntry.getObject();
        super.dependsOn(cacheEntry);
        return xmlDoc;
    }

    public boolean checkReloadLeaf() throws XMLProcessingException {
        throw new XMLProcessingException("CacheableProcessor: checkReloadLeaf() method should never be called from here.");
    }
}

