/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.LDAPUserSession;
import com.iplanet.xslui.auth.LDAPUserSessionFactory;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.UserSessionFactory;
import com.iplanet.xslui.auth.XSLAuthFilter;
import com.iplanet.xslui.tools.LDAPConfigReader;
import com.iplanet.xslui.tools.LDAPPool;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class LDAPAuthFilter
extends XSLAuthFilter {
    public static final String CONFIG_FILENAME = "xslauth.properties";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    public static final String LDAPAUTHCONFIGPREFIX = "ldapauth.";
    private static final String CONFIG_STOREPASSWORD = "ldapauth.storepasswordinsession";
    public static final String CONFIG_PROXYUSERS = "ldapauth.admins";
    private static final String CONFIG_AUTHSDKPATH = "authsdkpath";
    private static final String CONFIG_IPSECURITY = "ipsecurity";
    public static final int LDAPVERSION = 3;
    private UserSessionFactory _userFactory = null;
    private String _defaultDomain = null;
    private LDAPPool _ldapPool = null;
    private String[] _proxyUsers = null;
    private String _authSDKPath = null;
    private boolean _ipSecurity = false;
    private boolean _storePassword = false;

    public void init(FilterConfig config) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(config);
        PropertyReader propertyReader = super.getPropertyReader();
        this._defaultDomain = propertyReader.getStringProperty(CONFIG_DEFAULTDOMAIN, "iplanet.com");
        this._proxyUsers = propertyReader.getStringArrayProperty(CONFIG_PROXYUSERS, "");
        this._authSDKPath = propertyReader.getStringProperty(CONFIG_AUTHSDKPATH, "/authSDK");
        this._ipSecurity = propertyReader.getBooleanProperty(CONFIG_IPSECURITY, "false");
        this._storePassword = propertyReader.getBooleanProperty(CONFIG_STOREPASSWORD, "false");
        try {
            this._ldapPool = LDAPConfigReader.getLDAPPool((PropertyReader)propertyReader, (String)LDAPAUTHCONFIGPREFIX);
        }
        catch (LDAPException le) {
            throw new ServletException("LDAPAuthFilter: Cant get LDAP pool: " + le.getMessage());
        }
        this._userFactory = new LDAPUserSessionFactory();
        boolean init = this._userFactory.init(propertyReader.getConfigFile());
        if (!init) {
            throw new ServletException("LDAPAuthFilter: Cant init LDAPUserSessionFactory");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpSession session = request.getSession(true);
        UserSession userSession = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
        if (userSession != null) {
            if (this._ipSecurity) {
                String clientIP = (String)session.getAttribute("com.iplanet.xslui.ui.clientIP");
                String requestClientIP = request.getRemoteAddr();
                if (request.getRequestURI().equals(this._authSDKPath)) {
                    requestClientIP = request.getParameter("clientIP");
                }
                if (clientIP.equals(requestClientIP)) {
                    req.setAttribute("validClientIP", (Object)new String("true"));
                } else {
                    req.setAttribute("validClientIP", (Object)new String("false"));
                }
            }
            chain.doFilter(req, response);
            if (XSLAuthFilter.invalidateSession(request)) {
                session.invalidate();
            }
            return;
        }
        String uid = (String)session.getAttribute("uid");
        String domain = (String)session.getAttribute("domainname");
        if (domain == null || domain.length() <= 0) {
            session.setAttribute("domainname", (Object)this._defaultDomain);
        }
        boolean needAuth = true;
        if (uid != null && uid.length() > 0 && domain != null && domain.length() > 0) {
            needAuth = false;
            Logging.trace(64, "LDAPAuthFilter: user already authenticated: " + uid + "@" + domain);
        } else {
            String login = XSLAuthFilter.getUserFromRequest(request);
            if (login == null) {
                chain.doFilter(req, response);
                return;
            }
            int sep = login.lastIndexOf("@");
            if (sep != -1) {
                uid = login.substring(0, sep);
                domain = login.substring(sep + 1);
            } else {
                uid = login;
                domain = this._defaultDomain;
            }
        }
        Logging.trace(64, "LDAPAuthFilter: login from " + uid);
        userSession = this._userFactory.newUserSession(uid, domain);
        if (userSession == null) {
            Logging.trace(64, "couldnt create user " + uid + "(domain " + domain + ")");
            chain.doFilter(req, response);
            return;
        }
        if (needAuth) {
            String userDN = userSession.getDN();
            Logging.trace(64, "LDAPAuthFilter: Authenticating " + userDN);
            String userPassword = XSLAuthFilter.getPasswordFromRequest(request);
            if (userPassword == null || userPassword.equals("")) {
                Logging.trace(64, "no password provided for " + userDN);
                chain.doFilter(req, response);
                return;
            }
            LDAPConnection lc = null;
            try {
                lc = this._ldapPool.getConnection();
                if (lc == null) {
                    Logging.error(64, "couldnt log in DN=" + userDN + " : couldn't get conn from the pool");
                    chain.doFilter(req, response);
                    return;
                }
                lc.authenticate(3, userDN, userPassword);
            }
            catch (LDAPException le) {
                Logging.trace(64, "couldnt log in DN=" + userDN + " : " + le.errorCodeToString() + " : " + le.getLDAPErrorMessage() + " : " + le.getLDAPResultCode());
                this._ldapPool.close(lc);
                chain.doFilter(req, response);
                return;
            }
            this._ldapPool.close(lc);
            String proxyauth = request.getParameter("proxyauth");
            String fullUserId = uid + "@" + domain;
            boolean isProxy = false;
            String clientIP = request.getRemoteAddr();
            if (request.getRequestURI().equals(this._authSDKPath)) {
                clientIP = request.getParameter("clientIP");
            }
            if (this._proxyUsers != null && proxyauth != null) {
                for (int proxyCount = 0; proxyCount < this._proxyUsers.length; ++proxyCount) {
                    if (!fullUserId.trim().equalsIgnoreCase(this._proxyUsers[proxyCount].trim())) continue;
                    isProxy = true;
                    break;
                }
            }
            if (proxyauth != null && proxyauth.length() != 0 && isProxy) {
                userSession = null;
                int sep = proxyauth.lastIndexOf("@");
                if (sep != -1) {
                    uid = proxyauth.substring(0, sep);
                    domain = proxyauth.substring(sep + 1);
                } else {
                    uid = proxyauth;
                    domain = this._defaultDomain;
                }
                userSession = this._userFactory.newUserSession(uid, domain);
                if (userSession == null || clientIP == null) {
                    userSession = null;
                    Logging.trace(64, "couldnt create user [ for proxyauth ] " + uid + "(domain " + domain + ")");
                    chain.doFilter(req, response);
                    return;
                }
            }
            if (this._ipSecurity) {
                session.setAttribute("com.iplanet.xslui.ui.clientIP", (Object)clientIP);
                req.setAttribute("validClientIP", (Object)new String("true"));
            }
            session.setAttribute("uid", (Object)uid);
            session.setAttribute("domainname", (Object)domain);
            if (!isProxy && this._storePassword && userSession instanceof LDAPUserSession) {
                ((LDAPUserSession)userSession).setPassword(userPassword);
            }
            Logging.trace(64, "LDAPAuthFilter: user " + uid + "@" + domain + " authenticated");
        }
        String lang = userSession.getPreferredLanguage();
        session.setAttribute("userlang", (Object)lang);
        session.setAttribute("com.iplanet.xslui.ui.usersession", (Object)userSession);
        Logging.trace(64, "LDAPAuthFilter: user " + uid + "@" + domain + " session created");
        chain.doFilter(req, response);
        if (XSLAuthFilter.invalidateSession(request)) {
            session.invalidate();
        }
    }

    public void destroy() {
    }
}

