/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.client;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.client.GetResponseException;
import com.sun.portal.rproxy.configservlet.client.HostChooser;
import com.sun.portal.rproxy.configservlet.client.SendRequestException;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.HostAvailabilityEvent;
import com.sun.portal.util.HostAvailabilityEventImpl;
import com.sun.portal.util.HostAvailabilityMediator;
import com.sun.portal.util.SSOUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class SrapClient {
    private static HostChooser hostChooser = new HostChooser();
    private static final String PORTAL_SERVER = "__sra_portal_server__";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response execute(Request request) throws SendRequestException, GetResponseException {
        HostAvailabilityEventImpl event;
        URLConnection conn = null;
        String portalHost = null;
        try {
            request.setGatewaySessionID();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            String sessionServerURL = SrapClient.getSessionServerURL(request);
            if (sessionServerURL != null) {
                if (hostChooser.isAvailable(sessionServerURL)) {
                    portalHost = sessionServerURL;
                } else {
                    portalHost = hostChooser.getHost();
                    if (portalHost == null || portalHost.trim().length() == 0) {
                        Response response = null;
                        return response;
                    }
                }
            } else {
                portalHost = hostChooser.getHost();
                if (portalHost == null || portalHost.trim().length() == 0) {
                    Response response = null;
                    return response;
                }
            }
            conn = new URL(portalHost).openConnection();
            if (PerfContextObject.ENABLE_PERF) {
                SocketCount.incrementPlainSockets();
            }
            SrapClient.sendRequest(conn, request);
            Response retres = SrapClient.getResponse(conn);
            if (retres.getNeedRecreateSession()) {
                GWLogManager.createAppSessionIfInvalid();
                request.setGatewaySessionID();
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write((String)"RProxy", (String)"App session is invalid !");
                }
                Response response = SrapClient.execute(request);
                return response;
            }
            Response response = retres;
            return response;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Bad URL - check the url of the servlet");
        }
        catch (SendRequestException e) {
            event = new HostAvailabilityEventImpl();
            event.setHost(portalHost);
            HostAvailabilityMediator.getHostAvailabilityMediator();
            HostAvailabilityMediator.notifyListeners((HostAvailabilityEvent)event);
            Response response = SrapClient.execute(request);
            return response;
        }
        catch (IOException ioe) {
            event = new HostAvailabilityEventImpl();
            event.setHost(portalHost);
            HostAvailabilityMediator.getHostAvailabilityMediator();
            HostAvailabilityMediator.notifyListeners((HostAvailabilityEvent)event);
            Response response = SrapClient.execute(request);
            return response;
        }
        finally {
            conn = null;
            if (PerfContextObject.ENABLE_PERF) {
                SocketCount.decrementPlainSockets();
            }
        }
    }

    public static Response bootupExecute(Request request) throws SendRequestException, GetResponseException {
        URLConnection conn = null;
        String portalHost = HostChooser.getBootupPortalServer();
        try {
            request.setGatewaySessionID();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            conn = new URL(portalHost).openConnection();
            if (PerfContextObject.ENABLE_PERF) {
                SocketCount.incrementPlainSockets();
            }
            SrapClient.sendRequest(conn, request);
            Response ex = SrapClient.getResponse(conn);
            return ex;
        }
        catch (Exception e) {
            throw new RuntimeException("Bad URL - check the url of the servlet or Application Login failed");
        }
        finally {
            conn = null;
            if (PerfContextObject.ENABLE_PERF) {
                SocketCount.decrementPlainSockets();
            }
        }
    }

    private static void sendRequest(URLConnection connection, Request request) throws SendRequestException {
        try {
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            ObjectOutputStream objectStream = new ObjectOutputStream(connection.getOutputStream());
            objectStream.writeObject(request);
            objectStream.flush();
        }
        catch (Exception e) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Exception while sending request to server.", (Throwable)e);
            }
            throw new SendRequestException(e.getMessage());
        }
    }

    private static Response getResponse(URLConnection connection) throws GetResponseException {
        try {
            ObjectInputStream objectStream = new ObjectInputStream(connection.getInputStream());
            Response ret = (Response)objectStream.readObject();
            objectStream.close();
            return ret;
        }
        catch (Exception e) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Exception while reading response to server.", (Throwable)e);
            }
            throw new GetResponseException(e.getMessage());
        }
    }

    private static String getSessionServerURL(Request req) {
        String sid = req.getSSOTokenId();
        String portalServer = null;
        SSOToken token = null;
        if (sid == null || sid.equals("null") || sid.trim().length() == 0) {
            return null;
        }
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            token = SSOUtil.getSSOTokenNoDecode((String)sid);
            manager.validateToken(token);
            portalServer = token.getProperty(PORTAL_SERVER);
            if (portalServer != null) {
                return portalServer;
            }
            portalServer = hostChooser.getHost();
            token.setProperty(PORTAL_SERVER, portalServer);
            manager.refreshSession(token);
            return portalServer;
        }
        catch (Exception ssoEx) {
            return null;
        }
    }
}

