/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.client;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.HostAvailabilityEvent;
import com.sun.portal.util.HostAvailabilityListener;
import com.sun.portal.util.HostChecker;
import com.sun.portal.util.SystemProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HostChooser
extends HostAvailabilityListener {
    private static final String SERVLET_URL = SystemProperties.get((String)"gateway.dsame.agent");
    private String path;
    private List portalServers;
    private Iterator roundRobin;
    private static int orginalSize = 0;
    private Map unavailableServers;

    public HostChooser() {
        block2: {
            this.path = null;
            this.portalServers = null;
            this.roundRobin = null;
            this.unavailableServers = new HashMap();
            try {
                this.path = new URL(SERVLET_URL).getPath();
            }
            catch (MalformedURLException me) {
                if (!GWDebug.debug.errorEnabled()) break block2;
                GWDebug.debug.error("Gateway Aborting: Invalid gateway.dsame.agent url ");
            }
        }
        this.addHostAvailabilityListener(this);
    }

    private synchronized void initialize() {
        Iterator itr = GatewayProfile.getStringList("PortalServerList").iterator();
        this.portalServers = new ArrayList();
        while (itr.hasNext()) {
            this.portalServers.add(itr.next().toString().toLowerCase());
        }
        this.roundRobin = this.portalServers.iterator();
    }

    public synchronized String getHost() {
        int count = 0;
        if (this.portalServers == null) {
            try {
                this.initialize();
            }
            catch (NullPointerException ne) {
                return SERVLET_URL;
            }
            orginalSize = this.portalServers.size();
        }
        String retval = null;
        while (count < orginalSize) {
            String host = this.getHostImpl();
            if (this.isAvailable(host)) {
                retval = host;
                break;
            }
            ++count;
        }
        return retval;
    }

    private synchronized String getHostImpl() {
        if (this.portalServers.size() == 0 || this.portalServers.size() == this.unavailableServers.size()) {
            return null;
        }
        if (orginalSize < 2) {
            return SERVLET_URL;
        }
        if (this.roundRobin == null) {
            this.roundRobin = this.portalServers.iterator();
        }
        if (this.roundRobin.hasNext()) {
            return this.roundRobin.next().toString() + this.path;
        }
        this.roundRobin = this.portalServers.iterator();
        return this.roundRobin.next().toString() + this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(String host) {
        try {
            if (this.portalServers == null) {
                this.initialize();
            }
            URL tmpurl = new URL(host);
            StringBuffer portalHost = new StringBuffer();
            portalHost.append(tmpurl.getProtocol()).append("://").append(tmpurl.getHost()).append(":").append(tmpurl.getPort());
            String requestedHost = portalHost.toString().toLowerCase();
            Map map = this.unavailableServers;
            synchronized (map) {
                if (!this.unavailableServers.isEmpty() && this.unavailableServers.get(requestedHost) != null) {
                    return false;
                }
            }
            URL url = new URL(requestedHost);
            return HostChecker.isHostAvailable((URL)url, (int)2);
        }
        catch (MalformedURLException mue) {
            return false;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void hostAvailabilityChanged(HostAvailabilityEvent hae) {
        if (this.portalServers == null) {
            this.initialize();
        }
        if (hae.getHostType() == 2) {
            if (hae.getHostStatus() == 1) {
                this.removeHost(hae.getHost());
            } else if (hae.getHostStatus() == 2) {
                this.addHost(hae.getHost());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHost(String host) {
        Map map = this.unavailableServers;
        synchronized (map) {
            if (!this.unavailableServers.isEmpty() && this.unavailableServers.get(host) != null) {
                this.unavailableServers.remove(host);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHost(String host) {
        Map map = this.unavailableServers;
        synchronized (map) {
            if (this.unavailableServers.isEmpty() || this.unavailableServers.get(host) == null) {
                this.unavailableServers.put(host, new Long(System.currentTimeMillis()));
            }
        }
    }

    public static String getBootupPortalServer() {
        return SERVLET_URL;
    }
}

