/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.util;

import com.sun.portal.desktop.util.Base64;
import com.sun.portal.desktop.util.Target;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class PIParser {
    public static final String DESKTOP_ARGS = "desktop.args";
    public static final String DESKTOP_AUTHLESS = "desktop.authless";
    public static final String SEPARATOR = "$";

    public static Map parse(String piString) {
        String pi = null;
        if (piString == null || piString.length() <= 1) {
            return Collections.EMPTY_MAP;
        }
        pi = piString.substring(1);
        int delimIndex = pi.indexOf(SEPARATOR);
        HashMap<String, Map> pathInfoMap = new HashMap<String, Map>();
        if (delimIndex != -1) {
            StringTokenizer st = new StringTokenizer(pi, SEPARATOR);
            while (st.hasMoreTokens()) {
                String key;
                String keyValue = st.nextToken();
                int index = keyValue.indexOf("=");
                if (index == -1 || pathInfoMap.containsKey(key = keyValue.substring(0, index)) || !key.equals(DESKTOP_ARGS) && !key.equals(DESKTOP_AUTHLESS)) continue;
                String value = keyValue.substring(index + 1);
                Map valueMap = PIParser.decodeKeyValueString(value);
                pathInfoMap.put(key, valueMap);
            }
        } else {
            String key;
            int index = pi.indexOf("=");
            if (index != -1 && ((key = pi.substring(0, index)).equals(DESKTOP_ARGS) || key.equals(DESKTOP_AUTHLESS))) {
                String value = pi.substring(index + 1);
                Map valueMap = PIParser.decodeKeyValueString(value);
                pathInfoMap.put(key, valueMap);
            }
        }
        return pathInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPathInfoString(Map piMap) {
        StringBuffer piBuffer;
        if (piMap == null) {
            return null;
        }
        Map map = piMap;
        synchronized (map) {
            Set keys = piMap.keySet();
            piBuffer = new StringBuffer();
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Map value = (Map)piMap.get(key);
                String encodedPathInfoString = PIParser.encodeKeyValueMap(value);
                piBuffer.append(key).append("=").append(encodedPathInfoString);
                if (!i.hasNext()) continue;
                piBuffer.append(SEPARATOR);
            }
        }
        return piBuffer.toString();
    }

    public static Map decodeKeyValueString(String s) {
        if (s == null) {
            return null;
        }
        HashMap<String, String> cp = null;
        s = new String(Base64.decode(s.getBytes()));
        StringTokenizer t = new StringTokenizer(s, "&");
        while (t.hasMoreTokens()) {
            String p = t.nextToken();
            Target property = new Target(p, '=', 0);
            if (property.getName() == null) continue;
            if (cp == null) {
                cp = new HashMap<String, String>();
            }
            String name = property.getName();
            String value = property.getValue();
            cp.put(name, value);
        }
        return cp;
    }

    public static String encodeKeyValueMap(Map pathInfo) {
        if (pathInfo == null) {
            return null;
        }
        StringBuffer piBuffer = new StringBuffer();
        Iterator i = pathInfo.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)pathInfo.get(key);
            if (value == null) continue;
            piBuffer.append(key).append("=").append(value);
            if (!i.hasNext()) continue;
            piBuffer.append("&");
        }
        String encodedPathInfoString = Base64.encode(piBuffer.toString());
        return encodedPathInfoString;
    }
}

