/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netmail.protocol;

import com.sun.portal.netmail.protocol.Account;
import com.sun.portal.netmail.protocol.Controller;
import com.sun.portal.netmail.protocol.Message;
import com.sun.portal.netmail.protocol.Preferences;
import com.sun.portal.netmail.protocol.Requestor;
import com.sun.portal.netmail.protocol.SearchCriteria;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Folder
implements Serializable,
Requestor {
    public Account account;
    public String name;
    String IMAPname = "";
    public Hashtable messageTable = new Hashtable();
    public int exists = 0;
    public int nextCloneUID = -1;
    public boolean isParent = false;
    public boolean isPrimordial = false;
    public boolean isDeleted = false;
    public boolean isReadOnly = false;
    public long UID = -1L;
    public static final int OK = 0;
    public static final int READONLY = 1;
    public static final int NOEXIST = 2;
    public static final int OTHER = 0;
    public static final int EXPUNGE = 1;
    public static final int CREATE = 2;
    public static final int NEWMESSAGES = 3;
    public static final int RENAME = 4;
    public static final int DELETE = 5;

    public Ref getRef() {
        return new Ref(this);
    }

    public Folder(Account account, String string, boolean bl) {
        this.isPrimordial = !bl;
        this.account = account;
        if (string.equalsIgnoreCase("INBOX")) {
            string = string.toUpperCase();
        }
        this.name = string;
        this.IMAPname = string;
        if (this.account != null) {
            this.account.addFolder(this);
        }
    }

    public void create(Controller controller) {
        controller.getRequest().startOp((Requestor)this, 10, this.getRef());
    }

    public void delete(Controller controller) {
        this.isDeleted = true;
        controller.getRequest().startOp((Requestor)this, 12, this.getRef());
    }

    public void rename(Controller controller, String string) {
        this.account.removeFolder(this);
        this.name = string;
        this.account.addFolder(this);
        Serializable[] serializableArray = new Serializable[]{this.getRef(), string};
        controller.getRequest().startOp((Requestor)this, 11, serializableArray);
    }

    public void expunge(Controller controller) {
        controller.getRequest().startOp((Requestor)this, 4, this.getRef());
    }

    public void open(Controller controller, int n) {
        long l = 0L;
        Enumeration enumeration = this.messageTable.elements();
        while (enumeration.hasMoreElements()) {
            Message message = (Message)enumeration.nextElement();
            if (message.UID() <= l) continue;
            l = message.UID();
        }
        controller.getRequest().startOp((Requestor)this, 9, new Serializable[]{this.getRef(), new Long(l), new Integer(n)});
    }

    public void resync(Controller controller) {
        if (this.isParent) {
            return;
        }
        long[] lArray = new long[this.messageTable.size()];
        int n = 0;
        Enumeration enumeration = this.messageTable.elements();
        while (enumeration.hasMoreElements()) {
            Message message = (Message)enumeration.nextElement();
            lArray[n++] = message.UID();
            message.resync(controller);
        }
        if (lArray.length > 0) {
            controller.getRequest().startOp((Requestor)this, 21, new Serializable[]{this.getRef(), lArray});
        }
    }

    public void fetchHeaders(Controller controller, int n, int n2) {
        Serializable[] serializableArray = new Serializable[]{this.getRef(), new Integer(n), new Integer(n2)};
        controller.getRequest().startOp((Requestor)this, 5, serializableArray);
    }

    public void search(Controller controller, SearchCriteria searchCriteria) {
        Serializable[] serializableArray = this.messageTable.elements();
        while (serializableArray.hasMoreElements()) {
            Message message = (Message)serializableArray.nextElement();
            message.found = false;
        }
        serializableArray = new Serializable[]{this.getRef(), searchCriteria, this.makeMsgBitmap()};
        controller.getRequest().startOp((Requestor)this, 6, serializableArray);
    }

    private int[] makeMsgBitmap() {
        int[] nArray = new int[this.exists / 32 + 1];
        Enumeration enumeration = this.messageTable.elements();
        while (enumeration.hasMoreElements()) {
            Message message = (Message)enumeration.nextElement();
            int n = message.IMAPnumber();
            int n2 = n / 32;
            int n3 = n % 32;
            int n4 = n2;
            nArray[n4] = nArray[n4] | 1 << n3;
        }
        return nArray;
    }

    public void opCompleted(Controller controller, int n, Serializable[] serializableArray, Serializable[] serializableArray2) {
        switch (n) {
            case 10: {
                boolean bl = (Boolean)serializableArray2[0];
                if (bl) {
                    this.isPrimordial = false;
                } else {
                    if (this.account != null) {
                        this.account.removeFolder(this);
                    }
                    this.account = null;
                }
                controller.folderUpdated(this, 2, -1);
                break;
            }
            case 12: {
                this.account.removeFolder(this);
                Account account = this.account;
                this.account = null;
                controller.folderUpdated(this, 5, -1);
                controller.accountUpdated(account);
                break;
            }
            case 11: {
                this.IMAPname = (String)((Object)serializableArray[1]);
                controller.folderUpdated(this, 4, -1);
                break;
            }
            case 6: {
                Message[] messageArray;
                int n2;
                long[] lArray = (long[])serializableArray2[0];
                Vector vector = (Vector)serializableArray2[1];
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    messageArray = (Message)vector.elementAt(n2);
                    this.addMessage((Message)messageArray);
                }
                messageArray = new Message[lArray.length];
                for (n2 = 0; n2 < lArray.length; ++n2) {
                    messageArray[n2] = (Message)this.messageTable.get(new Long(lArray[n2]));
                    if (messageArray[n2] == null) continue;
                    messageArray[n2].found = true;
                }
                controller.foundMessages(messageArray);
                break;
            }
            case 5: {
                for (int i = 0; i < serializableArray2.length; ++i) {
                    this.addMessage((Message)serializableArray2[i]);
                }
                controller.folderUpdated(this, 3, serializableArray2.length);
                break;
            }
            case 9: {
                int n3 = (Integer)serializableArray2[0];
                long l = (Long)serializableArray2[1];
                int n4 = (Integer)serializableArray2[2];
                Vector vector = (Vector)serializableArray2[3];
                if (n3 == 2) {
                    if (this.account != null) {
                        this.account.removeFolder(this);
                    }
                    this.account = null;
                } else {
                    if (l != this.UID) {
                        this.messageTable = new Hashtable();
                        this.nextCloneUID = 0;
                        this.exists = 0;
                        this.UID = l;
                    }
                    this.isReadOnly = n3 == 1;
                    this.isPrimordial = false;
                    for (int i = 0; i < vector.size(); ++i) {
                        this.addMessage((Message)vector.elementAt(i));
                    }
                    this.exists = n4;
                }
                controller.folderUpdated(this, 3, vector.size());
                break;
            }
            case 4: {
                int n5;
                Message message;
                int[] nArray = (int[])serializableArray2[0];
                Message[] messageArray = new Message[this.exists + 1];
                Enumeration enumeration = this.messageTable.elements();
                while (enumeration.hasMoreElements()) {
                    message = (Message)enumeration.nextElement();
                    n5 = message.IMAPnumber();
                    if (n5 <= 0 || n5 > this.exists) continue;
                    messageArray[n5] = message;
                }
                int n6 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    message = messageArray[nArray[i]];
                    if (message != null) {
                        this.messageTable.remove(new Long(message.UID));
                        message.folder = null;
                    }
                    ++n6;
                    n5 = i + 1 < nArray.length ? nArray[i + 1] : this.exists + 1;
                    for (int j = nArray[i] + 1; j < n5; ++j) {
                        Message message2 = messageArray[j];
                        if (message2 == null) continue;
                        message2.setIMAPnumber(message2.IMAPnumber() - n6);
                    }
                    if (message == null) continue;
                    controller.messageUpdated(message);
                }
                this.exists -= n6;
                controller.folderUpdated(this, 1, -1);
                break;
            }
            case 21: {
                long[] lArray = (long[])serializableArray[1];
                int[] nArray = (int[])serializableArray2[0];
                byte[] byArray = (byte[])serializableArray2[1];
                Hashtable<Long, Message> hashtable = new Hashtable<Long, Message>();
                this.exists = 0;
                for (int i = 0; i < lArray.length; ++i) {
                    Long l = new Long(lArray[i]);
                    Message message = (Message)this.messageTable.get(l);
                    if (message == null || i >= nArray.length || nArray[i] == 0) continue;
                    message.resyncFlags = message.serverFlags = byArray[i];
                    message.flags = message.serverFlags;
                    message.markStatus();
                    message.setIMAPnumber(nArray[i]);
                    hashtable.put(l, message);
                    if (nArray[i] <= this.exists) continue;
                    this.exists = nArray[i];
                }
                this.messageTable = hashtable;
                controller.folderUpdated(this, 0, -1);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.IMAPname;
    }

    public String setName(String string) {
        this.name = string;
        return this.IMAPname;
    }

    public Enumeration getMessages() {
        return this.messageTable.elements();
    }

    public Enumeration getIMAPuids() {
        return this.messageTable.keys();
    }

    public boolean isCreated() {
        return !this.isPrimordial;
    }

    public int size() {
        return this.messageTable.size();
    }

    public void addMessage(Message message) {
        int n = message.IMAPnumber();
        if (n > this.exists) {
            this.exists = n;
        }
        this.messageTable.put(new Long(message.UID), message);
        message.folder = this;
    }

    public void removeMessage(Message message) {
        this.messageTable.remove(new Long(message.UID));
    }

    public Message getMsg(Long l) {
        return (Message)this.messageTable.get(l);
    }

    public int lastMissingMsg() {
        boolean[] blArray = new boolean[this.exists + 1];
        Enumeration enumeration = this.messageTable.elements();
        while (enumeration.hasMoreElements()) {
            int n = ((Message)enumeration.nextElement()).IMAPnumber();
            if (n <= 0 || n > this.exists) continue;
            blArray[n] = true;
        }
        for (int i = this.exists; i > 0; --i) {
            if (blArray[i]) continue;
            return i;
        }
        return 0;
    }

    public int firstMsgBefore(int n) {
        int n2 = 0;
        Enumeration enumeration = this.messageTable.elements();
        while (enumeration.hasMoreElements()) {
            int n3 = ((Message)enumeration.nextElement()).IMAPnumber();
            if (n3 <= n2 || n3 >= n) continue;
            n2 = n3;
        }
        return n2;
    }

    public boolean isSentMessagesFolder(Preferences preferences) {
        return this.getName().equals(preferences.sentMessagesFolder);
    }

    public static class Ref
    implements Serializable {
        public Account.Ref account;
        public String name;
        public long UID;

        public Ref(Folder folder) {
            if (folder.account != null) {
                this.account = folder.account.getRef();
            }
            this.name = folder.IMAPname;
            this.UID = folder.UID;
        }

        public String toArgString() {
            return this.account.toArgString() + "&folder=" + URLEncoder.encode(this.name) + "&fUID=" + this.UID;
        }
    }
}

