/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.util.GWDebug;
import java.net.URLDecoder;

public class SSOUtil {
    public static SSOToken getSSOToken(String strSessionId) throws Exception {
        boolean decode = true;
        String cookieEncode = SystemProperties.get((String)"com.iplanet.am.cookie.encode");
        if (cookieEncode.equals("false")) {
            decode = false;
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Value of the AMConfig encode property = " + cookieEncode + " decoding cookies = " + decode);
        }
        if (decode) {
            return SSOUtil.getSSOTokenNoDecode(URLDecoder.decode(strSessionId));
        }
        return SSOUtil.getSSOTokenNoDecode(strSessionId);
    }

    public static SSOToken getSSOTokenThrowExceptionToClient(String strSessionId) throws Exception {
        boolean decode = true;
        String cookieEncode = SystemProperties.get((String)"com.iplanet.am.cookie.encode");
        if (cookieEncode.equals("false")) {
            decode = false;
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Value of the AMConfig encode property = " + cookieEncode + " decoding cookies = " + decode);
        }
        if (decode) {
            return SSOUtil.getSSOTokenNoDecodeX(URLDecoder.decode(strSessionId));
        }
        return SSOUtil.getSSOTokenNoDecodeX(strSessionId);
    }

    public static SSOToken getSSOTokenNoDecode(String strSessionId) throws Exception {
        try {
            return SSOUtil.getSSOTokenNoDecodeX(strSessionId);
        }
        catch (SSOException ssoEx) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("SSOUtil: Unable to create SSOToken -> ", ssoEx);
            }
            throw ssoEx;
        }
        catch (Exception e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("SSOUtil: Unable to decode the SessionID -> ", e);
            }
            throw e;
        }
    }

    public static SSOToken getSSOTokenNoDecodeX(String strSessionId) throws SSOException {
        SSOToken ssoToken = null;
        SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
        if (!ssoTokenManager.isValidToken(ssoToken = ssoTokenManager.createSSOToken(strSessionId))) {
            throw new SSOException("SSOToken creation suceeded , but it is not valid");
        }
        return ssoToken;
    }
}

