/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.util.GWDebug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImplFactory;
import org.mozilla.jss.ssl.SSLSocket;

public class SRAPSocket
extends Socket {
    private Socket sock = null;
    private BufferedInputStream in = null;
    private BufferedOutputStream out = null;
    private boolean isHTTPS;

    public SRAPSocket(Socket sock) throws IOException {
        this.sock = sock;
        this.isHTTPS = sock instanceof SSLSocket;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new BufferedInputStream(this.sock.getInputStream());
        }
        return this.in;
    }

    public void close() throws IOException {
        if (PerfContextObject.ENABLE_PERF) {
            if (this.isHTTPS) {
                SocketCount.decrementSSLSockets();
            } else {
                SocketCount.decrementPlainSockets();
            }
        }
        this.sock.close();
    }

    public InetAddress getInetAddress() {
        return this.sock.getInetAddress();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.sock.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.sock.getLocalAddress();
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
        }
        return this.out;
    }

    public int getPort() {
        return this.sock.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.sock.getReceiveBufferSize();
    }

    public int getSendBufferSize() throws SocketException {
        return this.sock.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.sock.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.sock.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.sock.getTcpNoDelay();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.sock.setKeepAlive(on);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.sock.setReceiveBufferSize(size);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.sock.setSendBufferSize(size);
    }

    public static void setSocketImplFactory(SocketImplFactory fac) throws UnsupportedOperationException {
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("setSocketImplFactory(SocketImplFactory fac) called in SRAPSocket");
        }
        throw new UnsupportedOperationException("Not supported");
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.sock.setSoLinger(on, linger);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.sock.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.sock.setTcpNoDelay(on);
    }

    public void shutdownInput() throws IOException {
        this.in.skip(this.in.available());
        this.sock.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.out.flush();
        this.sock.shutdownOutput();
    }

    public String toString() {
        try {
            return this.sock.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isSSLSocket() {
        return this.isHTTPS;
    }

    public Socket getActualSocket() {
        return this.sock;
    }
}

