/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.server;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWNSSInit;
import com.sun.portal.util.SRAPServerSocket;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;

public class ServerSocketFactory {
    private static final String HTTPPROXY_PORT = "HTTPProxyPort";
    private static final int HTTPPROXY_DEFAULT_PORT = 10443;
    private static boolean allow40bitBrowser;
    private static boolean enableSSLV2;
    private static boolean enableSSLV3;
    private static boolean disableNullCiphers;
    private static boolean individualCipherSelectionMode;
    private static List enabledSSL2CipherList;
    private static List enabledSSL3CipherList;
    private static List enabledTLSCipherList;

    private ServerSocketFactory() {
    }

    public static ServerSocket createNormalServerSocket(int port) {
        try {
            String address = SystemProperties.get("gateway.bindipaddress");
            ServerSocket serverSocket = null;
            serverSocket = address == null ? new ServerSocket(port) : new ServerSocket(port, 50, InetAddress.getByName(address));
            if (PerfContextObject.ENABLE_PERF) {
                SocketCount.incrementServerSockets();
            }
            return serverSocket;
        }
        catch (IOException ex) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("FATAL: Not able to create Http Server Socket:" + port, ex);
            }
            return null;
        }
    }

    public static ServerSocket createSSLSocketServer(int port) throws SocketException {
        SSLServerSocket sock;
        block12: {
            boolean doingPDC;
            SSLServerSocket.configServerSessionIDCache((int)15000, (int)86400, (int)86400, null);
            ServerSocketFactory.certificationAdministration();
            sock = null;
            int qlen = GatewayProfile.getInt("EProxyConnectionQueue", 50);
            String _address = SystemProperties.get("gateway.bindipaddress");
            try {
                if (_address == null) {
                    _address = "127.0.0.1";
                }
                sock = new SSLServerSocket(port, qlen, InetAddress.getByName(_address));
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("ServerSocketFactory:createSSLSocketServer  nickname = " + GWNSSInit.nickname);
                }
                sock.setServerCertNickname(GWNSSInit.nickname);
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.incrementServerSockets();
                }
            }
            catch (UnknownHostException ue) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ServerSocketFactory:createSSLSocketServer localhost unknown host", ue);
                }
                sock = null;
            }
            catch (IOException e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ServerSocketFactory:createSSLSocketServer cannot create server socket", e);
                }
                sock = null;
            }
            String rphost = SystemProperties.get("gateway.host", null);
            List certSet = ServerSocketFactory.toLowerCase(GatewayProfile.getStringList("CertificateEnabledList"));
            boolean bl = doingPDC = certSet.contains(rphost.toLowerCase()) && ServiceIdentifier.isGateway();
            if (doingPDC) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Doing PDC");
                }
                try {
                    sock.requestClientAuth(true);
                }
                catch (SocketException se) {
                    if (!GWDebug.debug.errorEnabled()) break block12;
                    GWDebug.debug.error("Unable to request client authentication");
                }
            }
        }
        return sock;
    }

    private static void certificationAdministration() throws SocketException {
        if (individualCipherSelectionMode) {
            GWNSSInit.disableAllCiphers();
            ServerSocketFactory.enableCipherList(enabledSSL2CipherList);
            ServerSocketFactory.enableCipherList(enabledSSL3CipherList);
            ServerSocketFactory.enableCipherList(enabledTLSCipherList);
        } else {
            if (!enableSSLV2) {
                GWNSSInit.disableCipher(GWNSSInit.cipherSuites128BitSSL2);
            }
            if (!enableSSLV3) {
                GWNSSInit.disableCipher(GWNSSInit.cipherSuites128BitSSL3);
            }
            if (disableNullCiphers || !allow40bitBrowser) {
                GWNSSInit.disableCipher(GWNSSInit.cipherSuitesSSL3Null);
            }
            if (!allow40bitBrowser) {
                GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL2);
                GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL3);
                GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL2);
                GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL3);
                GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersTLS);
            } else {
                if (!enableSSLV2) {
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL2);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL2);
                }
                if (!enableSSLV3) {
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuites40BitSSL3);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersSSL3);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesSSL3Null);
                    GWNSSInit.disableCipher(GWNSSInit.cipherSuitesOthersTLS);
                }
            }
        }
    }

    private static void enableCipherList(List list) throws SocketException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ServerSocketFactory.enableCipher((String)list.get(i));
        }
    }

    private static void enableCipher(String cipher) throws SocketException {
        if (!enableSSLV2 && cipher.toLowerCase().indexOf("ssl2") != -1) {
            return;
        }
        if (!enableSSLV3 && cipher.toLowerCase().indexOf("ssl3") != -1) {
            return;
        }
        if (!enableSSLV3 && cipher.toLowerCase().indexOf("ssl_rsa_fips") != -1) {
            return;
        }
        if (disableNullCiphers && cipher.toLowerCase().indexOf("null") != -1) {
            return;
        }
        cipher = cipher.trim();
        if (!allow40bitBrowser && (cipher.equalsIgnoreCase("SSL2_RC2_128_CBC_EXPORT40_WITH_MD5") || cipher.equalsIgnoreCase("SSL2_RC4_128_EXPORT40_WITH_MD5") || cipher.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC4_40_MD5") || cipher.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC2_CBC_40_MD5") || cipher.equalsIgnoreCase("SSL2_DES_64_CBC_WITH_MD5") || cipher.equalsIgnoreCase("SSL3_RSA_WITH_DES_CBC_SHA") || cipher.equalsIgnoreCase("SSL3_RSA_WITH_NULL_MD5") || cipher.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA") || cipher.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_RC4_56_SHA") || cipher.equalsIgnoreCase("SSL_RSA_FIPS_WITH_DES_CBC_SHA") || cipher.equalsIgnoreCase("SSL3_FORTEZZA_DMS_WITH_NULL_SHA") || cipher.equalsIgnoreCase("SSL3_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA"))) {
            return;
        }
        if (cipher.equalsIgnoreCase("SSL2_RC2_128_CBC_WITH_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)65283, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_DES_192_EDE3_CBC_WITH_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)65287, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_RC4_128_WITH_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)65281, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_3DES_EDE_CBC_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)10, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_RC4_128_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)4, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_RC4_128_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)5, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)65279, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_FORTEZZA_DMS_WITH_RC4_128_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)30, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_RC2_128_CBC_EXPORT40_WITH_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)65284, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_RC4_128_EXPORT40_WITH_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)65282, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC4_40_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)3, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_EXPORT_WITH_RC2_CBC_40_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)6, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL2_DES_64_CBC_WITH_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)65286, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_DES_CBC_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)9, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_RSA_WITH_NULL_MD5")) {
            SSLSocket.setCipherPreferenceDefault((int)1, (boolean)true);
        } else if (cipher.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)98, (boolean)true);
        } else if (cipher.equalsIgnoreCase("TLS_RSA_EXPORT1024_WITH_RC4_56_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)100, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL_RSA_FIPS_WITH_DES_CBC_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)65278, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_FORTEZZA_DMS_WITH_NULL_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)28, (boolean)true);
        } else if (cipher.equalsIgnoreCase("SSL3_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA")) {
            SSLSocket.setCipherPreferenceDefault((int)29, (boolean)true);
        }
    }

    private static List toLowerCase(List list) {
        int size = list.size();
        ArrayList<String> ret = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String host = (String)list.get(i);
            ret.add(host.toLowerCase());
        }
        return ret;
    }

    public static ServerSocket createSRAPServerSocket(int port) {
        int qlen = GatewayProfile.getInt("EProxyConnectionQueue", 50);
        String _address = SystemProperties.get("gateway.bindipaddress");
        if (_address == null) {
            _address = "127.0.0.1";
        }
        try {
            SRAPServerSocket socket = new SRAPServerSocket(port, qlen, InetAddress.getByName(_address));
            if (PerfContextObject.ENABLE_PERF) {
                SocketCount.incrementServerSockets();
            }
            return socket;
        }
        catch (IOException e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("EProxyConnection cannot create server socket on " + port, e);
            }
            return null;
        }
    }

    static {
        enableSSLV2 = true;
        enableSSLV3 = true;
        disableNullCiphers = false;
        enabledSSL2CipherList = null;
        enabledSSL3CipherList = null;
        enabledTLSCipherList = null;
        String tmpstr = GatewayProfile.getString("Allow40BitConnections", "true");
        allow40bitBrowser = tmpstr.equals("true");
        tmpstr = GatewayProfile.getString("EnableSSLv2", "true");
        enableSSLV2 = tmpstr.equals("true");
        tmpstr = GatewayProfile.getString("EnableSSLv3", "true");
        enableSSLV3 = tmpstr.equals("true");
        tmpstr = GatewayProfile.getString("DisableNull", "false");
        disableNullCiphers = tmpstr.equals("true");
        tmpstr = GatewayProfile.getString("EnableIndividualCipherSelectionMode", "false");
        individualCipherSelectionMode = tmpstr.equals("true");
        if (individualCipherSelectionMode) {
            enabledSSL2CipherList = GatewayProfile.getStringList("EnabledSSL2CipherList");
            enabledSSL3CipherList = GatewayProfile.getStringList("EnabledSSL3CipherList");
            enabledTLSCipherList = GatewayProfile.getStringList("EnabledTLSCipherList");
        }
    }
}

