/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.dispatcher;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.dispatcher.CompressorReaper;
import com.sun.portal.wireless.util.MAConfigProperties;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class Compressor {
    private static HashMap compressorCache = new HashMap(100);
    private static String dispatchServletName = MAConfigProperties.get((String)"ma.dispatch.servlet.name", (String)"ma");
    private static String dispatchParmName = MAConfigProperties.get((String)"ma.dispatch.parm.name", (String)"uI");
    private static String dispatchErrorPage = MAConfigProperties.get((String)"ma.dispatch.error.page", (String)"/jsp/default/errorpage.jsp");
    private static boolean compressorEnable;
    private static int maxUrlCount;
    private HashMap urlToNumberCache = new HashMap(100);
    private HashMap numberToUrlCache = new HashMap(100);
    private SSOToken token = null;
    private int urlCounter = 0;
    private int cacheCounter = 0;

    private Compressor(SSOToken ssoToken) {
        this.token = ssoToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Compressor getCompressor(SSOToken ssoToken) {
        Compressor compressor;
        SSOTokenID tokenID = ssoToken.getTokenID();
        String hashKey = tokenID.toString();
        HashMap hashMap = compressorCache;
        synchronized (hashMap) {
            compressor = (Compressor)compressorCache.get(hashKey);
            if (compressor == null) {
                compressor = new Compressor(ssoToken);
                compressorCache.put(hashKey, compressor);
                CompressorReaper reaper = new CompressorReaper(hashKey, compressorCache);
                try {
                    ssoToken.addSSOTokenListener((SSOTokenListener)reaper);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return compressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compressURL(String urlString) {
        String urlNumber;
        if (!compressorEnable) {
            StringBuffer result = new StringBuffer(128);
            result.append("/").append(dispatchServletName).append("?");
            int paramIndex = urlString.indexOf("?");
            if (paramIndex != -1) {
                String target = urlString.substring(0, paramIndex);
                String targetParams = urlString.substring(paramIndex + 1);
                result.append(targetParams).append("&amp;target=").append(target);
            } else {
                result.append("target=").append(urlString);
            }
            return result.toString();
        }
        HashMap hashMap = this.urlToNumberCache;
        synchronized (hashMap) {
            urlNumber = (String)this.urlToNumberCache.get(urlString);
            if (urlNumber == null) {
                urlNumber = this.getUrlCounterString();
                String oldUrlString = (String)this.numberToUrlCache.get(urlNumber);
                if (oldUrlString != null) {
                    this.urlToNumberCache.remove(oldUrlString);
                }
                this.urlToNumberCache.put(urlString, urlNumber);
                this.numberToUrlCache.put(urlNumber, urlString);
            }
        }
        return "/" + dispatchServletName + "?" + dispatchParmName + "=" + this.getCacheCounterString() + urlNumber;
    }

    public static String getDispatcherServletName() {
        return dispatchServletName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieveURL(HttpServletRequest request) {
        String urlString;
        String urlNumber = request.getParameter(dispatchParmName);
        if (urlNumber == null) {
            Util.logWarning(this.getClass().getName() + ".retrieveURL:  request is missing \"" + dispatchParmName + "\" parameter");
            return dispatchErrorPage;
        }
        urlNumber = urlNumber.substring(2);
        HashMap hashMap = this.urlToNumberCache;
        synchronized (hashMap) {
            urlString = (String)this.numberToUrlCache.get(urlNumber);
        }
        if (urlString == null) {
            Util.logWarning(this.getClass().getName() + ".retrieveURL:  mapping failed.");
            urlString = dispatchErrorPage;
        }
        return urlString;
    }

    public boolean isCompressionEnabled() {
        return compressorEnable;
    }

    private String getUrlCounterString() {
        String count = Integer.toHexString(this.urlCounter++ % maxUrlCount);
        switch (count.length()) {
            case 4: {
                return count;
            }
            case 3: {
                return "0" + count;
            }
            case 2: {
                return "00" + count;
            }
            case 1: {
                return "000" + count;
            }
        }
        return count;
    }

    private String getCacheCounterString() {
        String count = Integer.toHexString(this.cacheCounter++ % 256);
        switch (count.length()) {
            case 2: {
                return count;
            }
            case 1: {
                return "0" + count;
            }
        }
        return count;
    }

    static {
        try {
            maxUrlCount = Integer.parseInt(MAConfigProperties.get((String)"ma.compressor.max.url", (String)"4096"));
        }
        catch (Exception e) {
            maxUrlCount = 4096;
        }
        String compressorEnableString = MAConfigProperties.get((String)"ma.compressor.enable", (String)"true");
        compressorEnable = Boolean.valueOf(compressorEnableString);
    }
}

