/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.base;

import com.iplanet.am.sdk.AMEvent;
import com.iplanet.am.sdk.AMEventListener;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.sun.portal.wireless.taglibs.base.Context;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.ssoadapter.config.PSClientAwareContextFactory;
import java.util.HashMap;

public class ContextCache {
    protected static HashMap contextCache = new HashMap(5);
    protected static final int START_SIZE = 1023;
    protected HashMap contexts = new HashMap(1023);
    private static boolean clearCacheUsingNotification = false;

    public static synchronized ContextCache getInstance(String className) {
        ContextCache c = (ContextCache)contextCache.get(className);
        if (c != null) {
            return c;
        }
        c = new ContextCache();
        contextCache.put(className, c);
        return c;
    }

    public void put(Context context, String configName) {
        this.put(context, configName, true);
    }

    public synchronized void put(Context context, String configName, boolean listener) {
        SSOTokenID sid = context.getSessionID();
        String sidString = sid.toString();
        if (configName != null) {
            sidString = sidString + configName;
        }
        this.contexts.put(sidString, context);
        if (listener) {
            HashMapReaper reaper = new HashMapReaper(sidString, this.contexts);
            try {
                context.getSession().addSSOTokenListener((SSOTokenListener)reaper);
                if (clearCacheUsingNotification) {
                    AMStoreConnection conn = new AMStoreConnection(context.getSession());
                    AMUser user = conn.getUser(context.getSession().getPrincipal().getName());
                    user.addEventListener((AMEventListener)reaper);
                }
            }
            catch (SSOException e) {
                Util.logError(this.getClass().getName() + ".put() failed.  " + "Couldn't add session listener for sidString=" + sidString, e);
            }
        }
    }

    public synchronized void remove(Context context, String configName) {
        SSOTokenID sid = context.getSessionID();
        String sidString = sid.toString();
        if (configName != null) {
            sidString = sidString + configName;
        }
        Context lcontext = (Context)this.contexts.get(sidString);
        this.contexts.remove(sidString);
    }

    public synchronized Context get(SSOToken session, String configName) {
        if (session == null) {
            return null;
        }
        String sidString = session.getTokenID().toString();
        if (configName != null) {
            sidString = sidString + configName;
        }
        Context context = (Context)this.contexts.get(sidString);
        return context;
    }

    static {
        try {
            clearCacheUsingNotification = PSClientAwareContextFactory.getInstance().clearCacheUsingNotification();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class HashMapReaper
    implements SSOTokenListener,
    AMEventListener {
        private String key;
        private HashMap hashMap;

        HashMapReaper(String key, HashMap hashMap) {
            this.key = key;
            this.hashMap = hashMap;
        }

        public void ssoTokenChanged(SSOTokenEvent evt) {
            try {
                SSOToken token = evt.getToken();
                int evtType = evt.getType();
                if (evtType != 3) {
                    if (evtType != 1) {
                        if (evtType != 2) {
                            return;
                        }
                    }
                }
                this.clearCache();
            }
            catch (Exception e) {
                Util.logError(this.getClass().getName() + ".ssoTokenChanged():  failed:  " + e);
            }
        }

        public void clearCache() {
            try {
                Context tempContext = (Context)this.hashMap.get(this.key);
                tempContext.closeConnection();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hashMap.remove(this.key);
        }

        public void objectChanged(AMEvent event) {
            this.clearCache();
        }

        public void objectRemoved(AMEvent event) {
            this.clearCache();
        }

        public void objectRenamed(AMEvent event) {
            this.clearCache();
        }
    }
}

