/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.util;

import java.util.Date;

public class StopWatch {
    private long startTime;
    private long stopTime;
    private long firstStartTime;
    private long lapTime;
    private long elapsedTime;
    private int state;
    private static final int INDETERMINATE = -1;
    private static final int STOPPED = 1;
    private static final int RUNNING = 2;

    public StopWatch() {
        this.reset();
    }

    public void reset() {
        this.state = -1;
        this.startTime = -1L;
        this.firstStartTime = -1L;
        this.stopTime = -1L;
        this.elapsedTime = -1L;
    }

    private long now() {
        return new Date().getTime();
    }

    public void start() {
        if (this.state == 2) {
            return;
        }
        if (this.state == -1) {
            this.elapsedTime = 0L;
        }
        this.state = 2;
        this.lapTime = this.startTime = this.now();
        if (this.firstStartTime == -1L) {
            this.firstStartTime = this.startTime;
        }
        this.stopTime = -1L;
    }

    public void stop() {
        if (this.state != 2) {
            return;
        }
        this.state = 1;
        this.stopTime = this.now();
        this.elapsedTime += this.stopTime - this.startTime;
    }

    public long elapsedTime() {
        if (this.state == -1) {
            return -1L;
        }
        if (this.state == 2) {
            return this.elapsedTime + this.now() - this.startTime;
        }
        return this.elapsedTime;
    }

    public long lapTime() {
        long l;
        if (this.state == -1) {
            return -1L;
        }
        if (this.state == 2) {
            long l2 = this.now();
            l = l2 - this.lapTime;
            this.lapTime = l2;
        } else {
            l = this.stopTime - this.lapTime;
            this.lapTime = this.stopTime;
        }
        return l;
    }

    public long realTime() {
        if (this.firstStartTime == -1L) {
            return -1L;
        }
        return this.now() - this.firstStartTime;
    }

    public long startTime() {
        return this.startTime;
    }

    public long stopTime() {
        return this.state == 1 ? this.stopTime : -1L;
    }

    public String toString() {
        return "StopWatch:  strt: " + this.startTime() + " stop: " + this.stopTime() + " elps: " + this.elapsedTime() + " lap: " + this.lapTime() + " real: " + this.realTime() + " state: " + this.state;
    }
}

