/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.util;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class Encoder {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    static String dfltEncName;

    private Encoder() {
    }

    public static String urlEncode(String string) {
        String string2 = null;
        try {
            string2 = Encoder.urlEncode(string, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public static String urlEncode(String string, String string2) throws UnsupportedEncodingException {
        boolean bl = false;
        int n = 10;
        StringBuffer stringBuffer = new StringBuffer(n * string.length());
        if (string2 != null) {
            string = new String(string.getBytes(string2), "ISO-8859-1");
        }
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i);
            if (dontNeedEncoding.get(n2)) {
                if (n2 == 32) {
                    n2 = 43;
                }
                stringBuffer.append((char)n2);
                continue;
            }
            stringBuffer.append('%');
            char c = Character.forDigit(n2 >> 4 & 0xF, 16);
            if (Character.isLetter(c)) {
                c = (char)(c - 32);
            }
            stringBuffer.append(c);
            c = Character.forDigit(n2 & 0xF, 16);
            if (Character.isLetter(c)) {
                c = (char)(c - 32);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String quotedEscape(String string) {
        return Encoder.quotedEscape(string, false);
    }

    public static String quotedEscape(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        if (bl) {
            stringBuffer.append("\"");
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuffer.append("\\r");
                continue;
            }
            if (c == '\\' || c == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public static StringBuffer htmlEncode(String string, StringBuffer stringBuffer) {
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&#39;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer;
    }

    public static String htmlEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return Encoder.htmlEncode(string, stringBuffer).toString();
    }

    public static final String unicodeEscape(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        if (c >= '\u001e' && c <= '~') {
            return "" + c;
        }
        stringBuffer.append("\\u");
        String string = Integer.toHexString(c);
        switch (string.length()) {
            case 1: {
                string = "000" + string;
                break;
            }
            case 2: {
                string = "00" + string;
                break;
            }
            case 3: {
                string = "0" + string;
            }
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static final String unicodeEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(Encoder.unicodeEscape(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    static {
        int n;
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            dontNeedEncoding.set(n);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dfltEncName = "ISO-8859-1";
    }
}

