/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.soif;

import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFBuffer;
import com.sun.portal.search.soif.SOIFException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Set;

public class SOIFInputStream {
    private DataInputStream sis;
    private boolean EOS;
    private String encoding = SOIF.defaultEncoding;
    private int enc_ = 0;
    private boolean convert8bit = false;
    Set allowed;
    public final boolean debug = false;

    public SOIFInputStream(String string) throws FileNotFoundException {
        this(new DataInputStream(new BufferedInputStream(new FileInputStream(string))));
    }

    public SOIFInputStream(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        this(new DataInputStream(new BufferedInputStream(new FileInputStream(string))), string2);
    }

    public SOIFInputStream(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(new DataInputStream(new ByteArrayInputStream(byArray)));
    }

    public SOIFInputStream(byte[] byArray) {
        this(new DataInputStream(new ByteArrayInputStream(byArray)));
    }

    public SOIFInputStream(SOIFBuffer sOIFBuffer) {
        this(sOIFBuffer.toByteArray());
    }

    public SOIFInputStream(InputStream inputStream) {
        this.sis = !(inputStream instanceof DataInputStream) ? new DataInputStream(inputStream) : (DataInputStream)inputStream;
    }

    public SOIFInputStream(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this(inputStream);
        if (string.equalsIgnoreCase("UTF-8")) {
            this.enc_ = 0;
        } else if (string.equalsIgnoreCase("UTF-16")) {
            string = "UTF-16BE";
            this.enc_ = 1;
        } else {
            this.enc_ = 2;
            if (!string.equalsIgnoreCase("ISO8859-1")) {
                this.convert8bit = true;
            }
        }
        this.encoding = string;
    }

    public void setAllowed(Set set) {
        this.allowed = set;
    }

    char getChar(InputStream inputStream) throws Exception, IOException {
        boolean bl = false;
        if (this.enc_ == 0) {
            int n = inputStream.read();
            if (n == -1) {
                throw new EOFException();
            }
            switch ((n &= 0xFF) >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return (char)n;
                }
                case 12: 
                case 13: {
                    int n2;
                    if (!bl) {
                        inputStream.mark(8);
                    }
                    if ((n2 = inputStream.read()) == -1) {
                        if (bl) {
                            throw new EOFException();
                        }
                        return (char)n;
                    }
                    if ((n2 & 0xC0) != 128) {
                        if (bl) {
                            throw new EOFException();
                        }
                        inputStream.reset();
                        return (char)n;
                    }
                    return (char)((n & 0x1F) << 6 | n2 & 0x3F);
                }
                case 14: {
                    inputStream.mark(8);
                    int n3 = inputStream.read();
                    if (n3 == -1) {
                        if (bl) {
                            throw new EOFException();
                        }
                        return (char)n;
                    }
                    int n4 = inputStream.read();
                    if (n4 == -1) {
                        if (bl) {
                            throw new EOFException();
                        }
                        inputStream.reset();
                        return (char)n;
                    }
                    if ((n3 & 0xC0) != 128 || (n4 & 0xC0) != 128) {
                        if (bl) {
                            throw new Exception("UTF-8 Data Format Error");
                        }
                        inputStream.reset();
                        return (char)n;
                    }
                    return (char)((n & 0xF) << 12 | (n3 & 0x3F) << 6 | (n4 & 0x3F) << 0);
                }
            }
            if (bl) {
                throw new Exception("UTF-8 Data Format Error");
            }
            return (char)n;
        }
        if (this.enc_ == 1) {
            int n = inputStream.read();
            if (n == -1) {
                throw new EOFException();
            }
            int n5 = inputStream.read();
            if (n5 == -1) {
                throw new EOFException();
            }
            return (char)(n << 8 | n5 & 0xFF);
        }
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (char)n;
    }

    char getToken(String string, String string2, String string3, String string4, StringBuffer stringBuffer) throws Exception {
        char c = this.getChar(this.sis);
        if (string != null) {
            while (string.indexOf(c) != -1) {
                c = this.getChar(this.sis);
            }
        }
        while (string2 == null || string2.indexOf(c) == -1) {
            if (string3 != null && string3.indexOf(c) == -1) {
                throw new Exception();
            }
            if (string4 != null && string4.indexOf(c) != -1) {
                throw new Exception();
            }
            stringBuffer.append(c);
            c = this.getChar(this.sis);
        }
        if (this.convert8bit) {
            try {
                byte[] byArray = stringBuffer.toString().getBytes();
                stringBuffer.setLength(0);
                stringBuffer.append(new String(byArray, this.encoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SOIFException("Unsupported encoding: " + unsupportedEncodingException.getMessage());
            }
        }
        return c;
    }

    public SOIF readSOIF() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(64);
        SOIF sOIF = new SOIF();
        sOIF.encoding = this.encoding;
        if (this.EOS) {
            throw new EOFException();
        }
        try {
            int n;
            int n2 = 10;
            do {
                n = n2;
            } while ((n2 = (int)this.getChar(this.sis)) != 64 || n != 10 && n != 13);
            n2 = this.getToken(null, " ", null, "\r\n", stringBuffer);
            sOIF.setSchemaName(new String(stringBuffer));
            n2 = this.getToken(" ", "{", " ", "\r\n", stringBuffer);
            stringBuffer.setLength(0);
            n2 = this.getToken(" ", "\r\n", null, null, stringBuffer);
            sOIF.setURL(new String(stringBuffer));
            while (true) {
                stringBuffer.setLength(0);
                n2 = this.getToken("\r\n", "{}", null, "\r\n", stringBuffer);
                if (n2 == 125) {
                    return sOIF;
                }
                String string = new String(stringBuffer);
                int n3 = -1;
                while (48 <= (n2 = (int)this.getChar(this.sis)) && n2 <= 57) {
                    if (n3 == -1) {
                        n3 = 0;
                    }
                    n3 = n3 * 10 + n2 - 48;
                }
                if (n2 != 125 || n3 == -1) {
                    throw new Exception();
                }
                int n4 = n3;
                if (this.getChar(this.sis) != ':' || this.getChar(this.sis) != '\t') {
                    throw new Exception();
                }
                int n5 = 0;
                int n6 = string.lastIndexOf(45);
                if (n6 != -1) {
                    int n7;
                    int n8 = string.length();
                    int n9 = 0;
                    for (n7 = n6 + 1; n7 < n8 && (n2 = (int)string.charAt(n7)) >= 48 && n2 <= 57; ++n7) {
                        n9 = n9 * 10 + n2 - 48;
                    }
                    if (n7 == n8) {
                        n5 = n9 > 0 ? n9 - 1 : 0;
                        string = string.substring(0, n6);
                    }
                }
                if (this.allowed == null || this.allowed.contains(string.toLowerCase())) {
                    byte[] byArray = new byte[n4];
                    this.sis.readFully(byArray);
                    sOIF.insert(string, byArray, n5);
                    continue;
                }
                this.sis.skip(n3);
            }
        }
        catch (Exception exception) {
            if (exception instanceof EOFException) {
                this.EOS = true;
                this.sis.close();
                return null;
            }
            String string = SOIF.INVALIDSOIF;
            if (exception.getMessage() != null) {
                string = string + ": " + exception.getMessage();
            }
            if (sOIF != null && sOIF.getURL() != null) {
                string = string + ": " + sOIF.getURL();
            }
            throw new SOIFException(string);
        }
    }

    public boolean isEOS() {
        return this.EOS;
    }

    public boolean close() {
        try {
            this.sis.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

