/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.rdmserver;

import com.sun.kt.search.Result;
import com.sun.portal.search.db.NovaResultSet;
import com.sun.portal.search.db.RDMDb;
import com.sun.portal.search.db.RDMResultSet;
import com.sun.portal.search.db.SToken;
import com.sun.portal.search.rdm.RDMCallback;
import com.sun.portal.search.rdm.RDMClassification;
import com.sun.portal.search.rdm.RDMHeader;
import com.sun.portal.search.rdm.RDMQuery;
import com.sun.portal.search.rdm.RDMRequest;
import com.sun.portal.search.rdm.RDMResponse;
import com.sun.portal.search.rdm.RDMTaxonomy;
import com.sun.portal.search.rdm.RDMTransaction;
import com.sun.portal.search.rdm.RDMView;
import com.sun.portal.search.rdmserver.DbAccess;
import com.sun.portal.search.rdmserver.RDMService;
import com.sun.portal.search.rdmserver.RDMServiceDescriptor;
import com.sun.portal.search.soif.AVPair;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFBuffer;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.CSLog;
import com.sun.portal.search.util.Encoder;
import com.sun.portal.search.util.SearchConfig;
import java.io.File;
import java.util.Date;

public class TaxonomyService
extends RDMService {
    public static final String CLASS_KEY = "statistics:classification";
    public static final String CLASS_NAME = "s_class";
    public static final String CLASS_NODES = "s_nodes";
    public static final String CLASS_THIS = "s_nodecnt";
    public static final String CLASS_IDXBATCH = "s_idxbatch";
    RDMTaxonomy theTax = null;
    static Date theTax_lmt = null;
    static Date theTax_refresh = null;
    static int theTax_refresh_rate = 60;
    public static final String QL_TAX_BASIC = "taxonomy-basic";
    public static final String QL_SEARCH = "search";
    public static final String QL_CLASSIFICATION = "classification";
    public static final String QL_LEGACY_COMPASS = "compass";
    public static final String QL_LEGACY_NSIR = "nsir";
    public static final String QL_LEGACY_VERITY = "verity";
    public static final String QL_LEGACY_VERITY_QL = "verity-ql";
    DbAccess dbaccess;

    public TaxonomyService() {
        this.supportedServices.add(new RDMServiceDescriptor("taxonomy-description-request", null));
        this.supportedServices.add(new RDMServiceDescriptor("taxonomy-description-request", QL_TAX_BASIC));
        this.supportedServices.add(new RDMServiceDescriptor("taxonomy-description-request", QL_SEARCH));
        this.supportedServices.add(new RDMServiceDescriptor("taxonomy-description-request", QL_LEGACY_COMPASS));
        this.supportedServices.add(new RDMServiceDescriptor("taxonomy-description-request", QL_LEGACY_NSIR));
        this.supportedServices.add(new RDMServiceDescriptor("taxonomy-description-request", QL_LEGACY_VERITY));
        this.supportedServices.add(new RDMServiceDescriptor("taxonomy-description-request", QL_LEGACY_VERITY_QL));
        this.dbaccess = DbAccess.getInstance();
    }

    public void init(String string) throws Exception {
        String string2 = SearchConfig.getValue("taxonomy-description");
        String string3 = SearchConfig.getValue("taxonomy-description-refresh-rate");
        theTax_lmt = new Date(0L);
        theTax_refresh = new Date(0L);
        if (string2 == null) {
            CSLog.error(1, 1, "Missing 'taxonomy-description' parameter");
            throw new Exception("Failed to initialize");
        }
        if (string3 != null) {
            theTax_refresh_rate = Integer.parseInt(string3);
        }
        try {
            this.loadTaxonomy(string2);
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "Failed to load " + string2);
            throw exception;
        }
    }

    public void service(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        String string;
        this.normalizeRequest(rDMRequest);
        rDMRequest.setSToken(new SToken(null, false, false));
        this.refreshTaxonomy(rDMRequest.getQuery().getDatabase());
        rDMResponse.getHeader().setType("taxonomy-description-response");
        rDMResponse.getHeader().setResponseInterpret("0 results out of 0 hits across 0 documents");
        if (this.theTax != null) {
            string = this.theTax.getId();
            rDMResponse.getHeader().getSOIF().replace("taxonomy-id", string);
        }
        if (rDMRequest.getQuery() == null) {
            rDMResponse.getHeader().setErrorMessage("Bad or missing query");
            return;
        }
        string = rDMRequest.getHeader().getQueryLanguage();
        if (string.equalsIgnoreCase(QL_SEARCH)) {
            this.ql_search_service(rDMRequest, rDMResponse);
        } else if (string.equalsIgnoreCase(QL_TAX_BASIC) || string.equalsIgnoreCase(QL_CLASSIFICATION)) {
            this.ql_tax_basic_service(rDMRequest, rDMResponse);
        } else if (string.equalsIgnoreCase(QL_LEGACY_NSIR) || string.equalsIgnoreCase(QL_LEGACY_COMPASS) || string.equalsIgnoreCase(QL_LEGACY_VERITY) || string.equalsIgnoreCase(QL_LEGACY_VERITY_QL)) {
            rDMRequest.getHeader().setQueryLanguage(QL_SEARCH);
            this.ql_search_service(rDMRequest, rDMResponse);
        }
    }

    public void ql_tax_basic_service(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        QLTaxQuery qLTaxQuery = new QLTaxQuery();
        String string = rDMRequest.getQuery().getScope();
        try {
            this.taxBasicScopeParse(string, qLTaxQuery);
        }
        catch (Exception exception) {
            CSLog.warn(1, 20, "Got invalid scope: '" + string + "'");
            rDMResponse.getHeader().setErrorMessage("Invalid Scope");
            rDMResponse.getHeader().setResponseInterpret("0 results out of 0 hits across 0 documents");
            return;
        }
        this.getTaxBasicResults(rDMRequest, rDMResponse, qLTaxQuery);
    }

    public void ql_search_service(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        QLSearchQuery qLSearchQuery = new QLSearchQuery();
        String string = rDMRequest.getQuery().getScope();
        try {
            this.searchScopeParse(string, qLSearchQuery);
        }
        catch (Exception exception) {
            CSLog.warn(1, 20, "Got invalid scope: '" + string + "'");
            rDMResponse.getHeader().setErrorMessage("Invalid Scope");
            rDMResponse.getHeader().setResponseInterpret("0 results out of 0 hits across 0 documents");
            return;
        }
        this.getSearchResults(rDMRequest, rDMResponse, qLSearchQuery);
    }

    protected boolean searchScopeParse(String string, QLSearchQuery qLSearchQuery) {
        if (string != null) {
            qLSearchQuery.scope = string;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getSearchResults(RDMRequest rDMRequest, RDMResponse rDMResponse, QLSearchQuery qLSearchQuery) throws Exception {
        int n;
        long l;
        long l2;
        block10: {
            RDMView rDMView = new RDMView(rDMRequest);
            RDMDb rDMDb = null;
            l2 = 0L;
            l = 0L;
            n = 0;
            SToken sToken = rDMRequest.getSToken();
            RDMTransaction rDMTransaction = rDMRequest.getTransaction();
            try {
                try {
                    rDMDb = this.dbaccess.readStart(sToken, rDMRequest.getQuery().getDatabase());
                }
                catch (Exception exception) {
                    CSLog.error(1, 1, "Cannot access database.", exception);
                    throw new Exception("Cannot access database.");
                }
                boolean bl = false;
                String string = qLSearchQuery.scope;
                if (string == null) {
                    string = qLSearchQuery.scope;
                }
                RDMResultSet rDMResultSet = rDMDb.search(sToken, string, rDMView.hits.max, rDMView.attr, rDMView.order, rDMTransaction);
                l = rDMResultSet.getHitCount();
                int n2 = (int)Math.min(l, Integer.MAX_VALUE);
                int n3 = rDMView.hits.min == 0 ? 0 : Math.min(rDMView.hits.min - 1, n2);
                int n4 = Math.min(rDMView.hits.max, n2);
                int n5 = n4 - n3;
                l2 = rDMDb.count(sToken, rDMTransaction);
                rDMResponse.getHeader().setResponseInterpret(n5 + " results out of " + l + " hits across " + l2 + " documents");
                rDMResponse.sendHeader();
                for (int i = n3; i < n4; ++i) {
                    SOIF sOIF;
                    Result result = ((NovaResultSet)rDMResultSet).getHit(i);
                    String string2 = (String)result.getField("id");
                    if (string2 == null) {
                        CSLog.error(1, 1, "Search hit has no Id");
                        continue;
                    }
                    RDMClassification rDMClassification = this.theTax.find(string2);
                    if (rDMClassification == null) {
                        CSLog.error(1, 1, "Classification hit not found in taxonomy: " + string2);
                        sOIF = new SOIF("CLASSIFICATION", "-");
                        sOIF.replace("id", string2);
                    } else {
                        SOIF sOIF2 = rDMClassification.getSOIF();
                        sOIF = new SOIF(sOIF2.getSchemaName(), sOIF2.getURL());
                        sOIF.merge(sOIF2);
                    }
                    sOIF.replace("score", "" + Math.round(result.getScore() * 100.0f));
                    rDMResponse.getOutputStream().write(sOIF, rDMView.attr);
                    ++n;
                }
                Object var27_25 = null;
                if (rDMDb == null) break block10;
            }
            catch (Throwable throwable) {
                Object var27_26 = null;
                if (rDMDb != null) {
                    this.dbaccess.readFinish(sToken, rDMDb);
                }
                throw throwable;
            }
            this.dbaccess.readFinish(sToken, rDMDb);
        }
        rDMRequest.logRDM("db=" + rDMRequest.getQuery().getDatabase() + " hits=" + n + "/" + l + "/" + l2 + " scope=\"" + Encoder.quotedEscape(qLSearchQuery.scope) + "\"");
    }

    public void normalizeRequest(RDMRequest rDMRequest) {
        RDMHeader rDMHeader = rDMRequest.getHeader();
        RDMQuery rDMQuery = rDMRequest.getQuery();
        String string = rDMHeader.getType();
        if (string.equalsIgnoreCase("taxonomy-description-request")) {
            String string2;
            String string3;
            if (rDMQuery.getDatabase() == null) {
                rDMQuery.setDatabase(SearchConfig.getValue("taxonomy-database-name"));
            }
            if ((string3 = rDMHeader.getQueryLanguage()) == null || string3.length() == 0) {
                rDMHeader.setQueryLanguage(QL_TAX_BASIC);
            }
            if (rDMRequest.getQuery() == null) {
                rDMRequest.setQuery(new RDMQuery((String)null));
            }
            if ((string2 = rDMRequest.getQuery().getScope()) == null || string2.length() == 0) {
                rDMRequest.getQuery().setScope("descendant ROOT");
            }
        }
    }

    protected void taxBasicScopeParse(String string, QLTaxQuery qLTaxQuery) throws Exception {
        char c;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        qLTaxQuery.depth = -1;
        qLTaxQuery.class_id = null;
        qLTaxQuery.retrieve_rd = false;
        qLTaxQuery.advise_doc_count = false;
        qLTaxQuery.doc_count = 0;
        if (string.regionMatches(true, 0, "anklebiter", 0, 10)) {
            n += 10;
            qLTaxQuery.depth = 1;
        } else if (string.regionMatches(true, 0, "children", 0, 8)) {
            qLTaxQuery.depth = 1;
            if (string.charAt(n += 8) == '*') {
                ++n;
                qLTaxQuery.exclude_first_node = true;
            }
        } else if (string.regionMatches(true, 0, "descendant", 0, 10)) {
            if (string.charAt(n += 10) == '/') {
                ++n;
                while ('0' <= (c = string.charAt(n)) && c <= '9') {
                    n2 = n2 * 10 + c - 48;
                    ++n;
                }
                qLTaxQuery.depth = n2;
            }
        } else if (string.regionMatches(true, 0, "advise-doc-count", 0, 16)) {
            if (string.charAt(n += 16) == '/') {
                ++n;
                while ('0' <= (c = string.charAt(n)) && c <= '9') {
                    n2 = n2 * 10 + c - 48;
                    ++n;
                }
            } else {
                throw new Exception("invalid scope");
            }
            qLTaxQuery.doc_count = n2;
            qLTaxQuery.advise_doc_count = true;
        } else {
            throw new Exception("invalid scope");
        }
        if (string.charAt(n) != ' ') {
            throw new Exception("invalid scope");
        }
        while (string.charAt(n) == ' ') {
            ++n;
        }
        qLTaxQuery.class_id = string.substring(n).trim();
    }

    protected synchronized void refreshTaxonomy(String string) throws Exception {
        Date date = new Date();
        if (this.theTax == null || theTax_refresh.before(date)) {
            this.init(string);
            theTax_refresh = new Date(date.getTime() + (long)(theTax_refresh_rate * 1000));
        }
    }

    protected void getTaxBasicResults(RDMRequest rDMRequest, RDMResponse rDMResponse, QLTaxQuery qLTaxQuery) throws Exception {
        RDMTaxonomy rDMTaxonomy = this.theTax;
        RDMClassification rDMClassification = null;
        rDMClassification = rDMTaxonomy.find(qLTaxQuery.class_id);
        if (rDMClassification == null) {
            rDMResponse.getHeader().setResponseInterpret("0 results out of 0 hits across 0 documents");
            return;
        }
        if (qLTaxQuery.advise_doc_count) {
            this.handleBrowseAdvice(rDMRequest, rDMResponse, qLTaxQuery, rDMClassification);
            return;
        }
        RDMView rDMView = new RDMView(rDMRequest);
        if (rDMRequest.getQuery().getViewHits() == null) {
            rDMView.hits.max = 1000000;
        }
        SOIFBuffer sOIFBuffer = new SOIFBuffer();
        SOIFOutputStream sOIFOutputStream = new SOIFOutputStream(sOIFBuffer);
        if (!qLTaxQuery.retrieve_rd) {
            sOIFOutputStream.write(rDMTaxonomy.getSOIF());
        }
        if (rDMView != null && rDMView.attr != null) {
            sOIFOutputStream.setAllowed(rDMView.attr);
        }
        QLTaxTraverse qLTaxTraverse = new QLTaxTraverse();
        qLTaxTraverse.t = rDMTaxonomy;
        qLTaxTraverse.qry = qLTaxQuery;
        qLTaxTraverse.results = 0;
        qLTaxTraverse.hits = 0;
        qLTaxTraverse.total = 0;
        qLTaxTraverse.min = rDMView.hits.min;
        qLTaxTraverse.max = rDMView.hits.max;
        qLTaxTraverse.depth_start = rDMTaxonomy.depth(rDMClassification);
        qLTaxTraverse.depth_max = qLTaxQuery.depth == -1 ? -1 : qLTaxQuery.depth + qLTaxTraverse.depth_start;
        qLTaxTraverse.ss = sOIFOutputStream;
        rDMClassification.apply(0, qLTaxTraverse);
        rDMResponse.getHeader().setResponseInterpret(qLTaxTraverse.results + " results out of " + qLTaxTraverse.hits + " hits across " + qLTaxTraverse.total + " documents");
        rDMRequest.logRDM("xfer=" + qLTaxTraverse.results + " scope=\"" + Encoder.quotedEscape(rDMRequest.getQuery().getScope()) + "\"");
        rDMResponse.sendHeader();
        rDMResponse.getOutputStream().write(sOIFBuffer.toByteArray());
    }

    protected void handleBrowseAdvice(RDMRequest rDMRequest, RDMResponse rDMResponse, QLTaxQuery qLTaxQuery, RDMClassification rDMClassification) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n2 = qLTaxQuery.doc_count;
        n = rDMClassification.getNumDocs();
        n3 = n2 - n;
        if (n3 != 0) {
            RDMClassification rDMClassification2 = rDMClassification;
            rDMClassification2.setNumDocs(n2);
            rDMClassification2.getSOIF().replace("categorized-count", "" + rDMClassification2.getNumDocs());
            do {
                int n4;
                if ((n4 = rDMClassification2.getNumDescDocs() + n3) < 0) {
                    CSLog.warn(1, 1, "Count went -ve while adjusting classified doc counts");
                    break;
                }
                rDMClassification2.setNumDescDocs(n4);
                rDMClassification2.getSOIF().replace("subcategorized-count", "" + n4);
            } while ((rDMClassification2 = rDMClassification2.getParent()) != null);
            this.saveCategorizedCount(rDMRequest.getSToken(), SearchConfig.getValue("database-name"), qLTaxQuery.class_id, n2, rDMRequest.getTransaction());
        }
        rDMRequest.logRDM("taxonomy advise - old count=" + n + " scope=\"" + Encoder.quotedEscape(rDMRequest.getQuery().getScope()) + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SOIF readCategorized(SToken sToken, String string, RDMTransaction rDMTransaction) throws Exception {
        SOIF sOIF = null;
        RDMDb rDMDb = null;
        try {
            try {
                rDMDb = this.dbaccess.readStart(sToken, string);
                sOIF = rDMDb.fetch(sToken, CLASS_KEY, null, 0, rDMTransaction);
            }
            catch (Exception exception) {
                CSLog.error(1, 1, "Error when reading classification statistics", exception);
                SOIF sOIF2 = null;
                Object var9_7 = null;
                if (rDMDb == null) return sOIF2;
                this.dbaccess.readFinish(sToken, rDMDb);
                return sOIF2;
            }
            Object var9_6 = null;
            if (rDMDb == null) return sOIF;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (rDMDb == null) throw throwable;
            this.dbaccess.readFinish(sToken, rDMDb);
            throw throwable;
        }
        this.dbaccess.readFinish(sToken, rDMDb);
        return sOIF;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCategorized(SToken sToken, String string, SOIF sOIF, RDMTransaction rDMTransaction) throws Exception {
        RDMDb rDMDb = null;
        try {
            try {
                rDMDb = this.dbaccess.writeStart(sToken, string);
                rDMDb.store(sToken, sOIF, null, 0x8000000, rDMTransaction);
            }
            catch (Exception exception) {
                CSLog.error(1, 1, "Cannot open db for updating categorized statistics", exception);
                throw exception;
            }
            Object var8_6 = null;
            if (rDMDb == null) return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (rDMDb == null) throw throwable;
            this.dbaccess.writeFinish(sToken, rDMDb);
            throw throwable;
        }
        this.dbaccess.writeFinish(sToken, rDMDb);
    }

    public static int getCategorizedCount(SOIF sOIF, String string) {
        AVPair aVPair = sOIF.getAVPair(CLASS_NAME);
        AVPair aVPair2 = sOIF.getAVPair(CLASS_THIS);
        for (int i = 0; i <= aVPair.getMaxIndex(); ++i) {
            String string2;
            if (!aVPair.nthValid(i) || !aVPair2.nthValid(i) || !(string2 = aVPair.getValue(i)).equals(string)) continue;
            string2 = aVPair2.getValue(i);
            if (string2 == null) break;
            return Integer.parseInt(string2);
        }
        return 0;
    }

    public synchronized void saveCategorizedCount(SToken sToken, String string, String string2, int n, RDMTransaction rDMTransaction) throws Exception {
        AVPair aVPair;
        int n2 = 0;
        SOIF sOIF = this.readCategorized(sToken, string, rDMTransaction);
        if (sOIF == null) {
            sOIF = new SOIF(CLASS_KEY, CLASS_KEY);
        }
        if ((aVPair = sOIF.getAVPair(CLASS_NAME)) != null) {
            for (n2 = 0; n2 <= aVPair.getMaxIndex(); ++n2) {
                String string3;
                if (!aVPair.nthValid(n2) || (string3 = aVPair.getValue(n2)) == null || !string3.equals(string2)) continue;
                if (n > 0) {
                    sOIF.replace(CLASS_THIS, String.valueOf(n), n2);
                } else {
                    sOIF.remove(CLASS_NAME, n2);
                    sOIF.remove(CLASS_THIS, n2);
                    aVPair.squeeze();
                    sOIF.replace(CLASS_NODES, String.valueOf(aVPair.getMaxIndex() + 1));
                }
                this.writeCategorized(sToken, string, sOIF, rDMTransaction);
                return;
            }
        }
        if (n == 0) {
            return;
        }
        if (aVPair == null || n2 > aVPair.getMaxIndex()) {
            String string4 = String.valueOf(n);
            if (!sOIF.insert(CLASS_NAME, string2, n2) || !sOIF.insert(CLASS_THIS, string4, n2)) {
                CSLog.error(1, 1, "Failed to update classification stats");
                return;
            }
            string4 = String.valueOf(aVPair != null ? aVPair.valueCount() : 1);
            sOIF.replace(CLASS_NODES, string4);
        }
        this.writeCategorized(sToken, string, sOIF, rDMTransaction);
    }

    protected void loadTaxonomy(String string) throws Exception {
        Date date = new Date(new File(string).lastModified());
        if (theTax_lmt == date) {
            return;
        }
        SOIFInputStream sOIFInputStream = null;
        try {
            sOIFInputStream = new SOIFInputStream(string);
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "Cannot read " + string);
            throw exception;
        }
        try {
            this.theTax = new RDMTaxonomy(sOIFInputStream);
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "Cannot parse Taxonomy: " + string);
            throw new Exception("Failed to parse taxonomy " + string);
        }
        SOIF sOIF = this.readCategorized(new SToken(null, false, false), SearchConfig.getValue("database-name"), null);
        this.theTax.apply(2, new AddCatContent(sOIF));
        this.theTax.apply(0, new UpdateClassSOIF());
        theTax_lmt = date;
        theTax_refresh = new Date(new Date().getTime() + (long)(theTax_refresh_rate * 1000));
    }

    class UpdateClassSOIF
    implements RDMCallback {
        UpdateClassSOIF() {
        }

        public void callback(Object object) throws Exception {
            RDMClassification rDMClassification = (RDMClassification)object;
            int n = 0;
            if (rDMClassification.getDepth() == 0) {
                return;
            }
            rDMClassification.getSOIF().replace("subclassification-count", "" + rDMClassification.getNumDescendant());
            rDMClassification.getSOIF().replace("categorized-count", "" + rDMClassification.getNumDocs());
            rDMClassification.getSOIF().replace("subcategorized-count", "" + rDMClassification.getNumDescDocs());
            if (rDMClassification.getChildren() != null) {
                for (n = 0; n < rDMClassification.nChildren(); ++n) {
                    String string = rDMClassification.nthChild(n).getId();
                    String string2 = string.substring(string.lastIndexOf(58) + 1);
                    rDMClassification.getSOIF().replace("child", string2, n);
                }
            }
        }
    }

    class AddCatContent
    implements RDMCallback {
        SOIF stats_soif;

        AddCatContent(SOIF sOIF) {
            this.stats_soif = sOIF;
        }

        public void callback(Object object) throws Exception {
            RDMClassification rDMClassification = (RDMClassification)object;
            if (rDMClassification.getDepth() == 0) {
                return;
            }
            if (this.stats_soif == null) {
                return;
            }
            rDMClassification.setNumDescDocs(rDMClassification.getNumDescDocs() + rDMClassification.getNumDocs());
            RDMClassification rDMClassification2 = rDMClassification.getParent();
            if (rDMClassification2 != null) {
                rDMClassification2.setNumDescDocs(rDMClassification2.getNumDescDocs() + rDMClassification.getNumDescDocs());
            }
        }
    }

    class QLTaxTraverse
    implements RDMCallback {
        RDMTaxonomy t;
        QLTaxQuery qry;
        SOIFOutputStream ss;
        int depth_max;
        int depth_start;
        int results;
        int hits;
        int total;
        int min;
        int max;
        boolean seen_first_node = false;

        QLTaxTraverse() {
        }

        public void callback(Object object) throws Exception {
            RDMClassification rDMClassification = (RDMClassification)object;
            int n = 0;
            ++this.total;
            if (!this.seen_first_node) {
                this.seen_first_node = true;
                if (this.qry.exclude_first_node) {
                    return;
                }
            }
            if (this.depth_max != -1 && (n = this.t.depth(rDMClassification)) > this.depth_max) {
                return;
            }
            ++this.hits;
            String string = rDMClassification.getId();
            if (!(this.qry.retrieve_rd || this.hits < this.min || this.max != 0 && this.hits > this.max)) {
                this.ss.write(rDMClassification.getSOIF());
                ++this.results;
            }
        }
    }

    class QLSearchQuery {
        String scope;

        QLSearchQuery() {
        }
    }

    class QLTaxQuery {
        String class_id;
        int depth;
        boolean retrieve_rd;
        boolean advise_doc_count;
        boolean exclude_first_node;
        int doc_count;

        QLTaxQuery() {
        }
    }
}

