/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.iplanet.log.LogException;
import com.iplanet.log.LogManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.ApplicationLogin;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.LogCreateThread;
import com.sun.portal.util.RemoteWriteLogThread;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.util.SystemProperties;
import java.util.Hashtable;

public class GWLogManager {
    private static String logName = "srapGateway";
    public static LogManager lm = null;
    public static boolean loggingEnabled = false;
    public static SSOToken appSession = null;
    private static int logId = 0;
    public static Hashtable logIdMap = new Hashtable();
    static String actualLogName = null;
    static boolean logError = false;
    private static String platformLogName = null;
    private static LogCreateThread createThread = null;
    private static RemoteWriteLogThread remoteLogThread = null;
    static boolean logCreateInvoked;

    public static synchronized void createNewAppSession() {
        GWLogManager.createNewAppSession(false);
    }

    public static synchronized void createNewAppSession(boolean internal) {
        block6: {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("createNewAppSession ... ");
            }
            try {
                String sessid = ApplicationLogin.login("srapGateway");
                appSession = GWLogManager.createSession(sessid);
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("createNewAppSession : app session created : " + appSession);
                }
                if (!logCreateInvoked && loggingEnabled && !internal) {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("createNewAppSession : recreating log ... ");
                    }
                    GWLogManager.recreateLog();
                }
            }
            catch (Exception ex) {
                if (!GWDebug.debug.errorEnabled()) break block6;
                GWDebug.debug.error("Error while creating Application Session ", ex);
            }
        }
    }

    public static String getUserId(String sessionID) {
        block5: {
            if (sessionID == null) {
                return "";
            }
            try {
                SSOToken ssoToken = SSOUtil.getSSOTokenThrowExceptionToClient(sessionID);
                String userDN = ssoToken.getPrincipal().getName();
                return userDN.substring(userDN.indexOf("=") + 1, userDN.indexOf(","));
            }
            catch (SSOException ssoexp) {
                if (ssoexp.toString().indexOf("Session state is invalid") != -1 && GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("GWLogManager: Unable to get user ID, did you not login!!");
                }
            }
            catch (Exception ex) {
                if (!GWDebug.debug.errorEnabled()) break block5;
                GWDebug.debug.error("GWLogManager: Unable to get user ID -> " + ex);
            }
        }
        return "";
    }

    public static synchronized int getLogId() {
        return ++logId;
    }

    public static void createDefault() {
        GWLogManager.createDefault(logName);
    }

    private static SSOToken createSession(String sessid) {
        SSOToken token = null;
        try {
            token = SSOUtil.getSSOTokenNoDecode(sessid);
        }
        catch (SSOException ex) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Unable to create application session", ex);
            }
            token = null;
        }
        catch (Exception ex) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Unable to create application session", ex);
            }
            token = null;
        }
        return token;
    }

    public static void initialise() {
        loggingEnabled = GatewayProfile.getBoolean("LoggingEnabled", false);
    }

    public static void createDefault(String name) {
        block6: {
            if (appSession == null) {
                GWLogManager.createNewAppSession(true);
            }
            if (loggingEnabled) {
                lm = new LogManager(appSession);
                if (name != null && name.length() > 0) {
                    logName = name;
                }
                if (platformLogName != null) {
                    logName = platformLogName;
                }
                try {
                    lm.create(logName);
                    actualLogName = logName;
                }
                catch (LogException e) {
                    actualLogName = null;
                    if (!GWDebug.debug.errorEnabled()) break block6;
                    GWDebug.debug.error("GWLogManager: Unable to create log");
                    GWDebug.debug.error("GWLogManager: " + e.toString());
                }
            }
        }
    }

    public static void write(String type, String msg) {
        if (lm == null) {
            return;
        }
        if (logError) {
            return;
        }
        if (!loggingEnabled) {
            return;
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Validating session ... " + appSession);
        }
        if (!GWLogManager.isAppSessionValid(appSession)) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Invalid Application session ... " + appSession);
                GWDebug.debug.error("Attempting to recreate logs ... ");
            }
            GWLogManager.recreateLog();
            return;
        }
        try {
            remoteLogThread.addEntryForLogging("ACCESS", msg);
        }
        catch (Exception e) {
            logError = true;
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("GWLogManager: Unable to create log record", e);
                String reason = e.toString();
                GWDebug.debug.error("GWLogManager: " + reason);
            }
            GWLogManager.recreateLog();
        }
    }

    private static synchronized void recreateLog() {
        if (logCreateInvoked) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("logCreateInvoked : true");
            }
            return;
        }
        logError = true;
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Recreate log !!");
        }
        if (!GWLogManager.isAppSessionValid(appSession)) {
            appSession = null;
            GWLogManager.createNewAppSession(true);
        }
        logCreateInvoked = true;
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Notifying ... ");
        }
        createThread.createLogsInThread(actualLogName);
    }

    static boolean isAppSessionValid(SSOToken token) {
        boolean isvalid;
        block5: {
            isvalid = false;
            if (token == null) {
                return false;
            }
            try {
                SSOTokenManager manager = SSOTokenManager.getInstance();
                SSOToken tok = token;
                isvalid = manager.isValidToken(tok);
            }
            catch (SSOException ssoex) {
                isvalid = false;
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Invalid Application session ", ssoex);
                }
            }
            catch (Exception ex) {
                isvalid = false;
                if (!GWDebug.debug.messageEnabled()) break block5;
                GWDebug.debug.message("Invalid Application session ", ex);
            }
        }
        return isvalid;
    }

    public static synchronized void createAppSessionIfInvalid() {
        block7: {
            try {
                boolean survivedRefresh = false;
                try {
                    SSOTokenManager manager = SSOTokenManager.getInstance();
                    manager.refreshSession(appSession);
                    survivedRefresh = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!survivedRefresh || !GWLogManager.isAppSessionValid(appSession)) {
                    System.out.println("\n\n\nAppsession was invalid creating a new appSession...\n\n\n");
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Appsession was invalid creating a new appSession...");
                    }
                    GWLogManager.createNewAppSession();
                    System.out.println("\n\n\nAppsession created sucessfully...\n\n\n");
                    System.out.flush();
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Appsession created sucessfully....");
                    }
                }
            }
            catch (Exception ex) {
                if (!GWDebug.debug.messageEnabled()) break block7;
                GWDebug.debug.message("Invalid Application session ", ex);
            }
        }
    }

    public static LogManager getLogManager() {
        return lm;
    }

    public static String getLogName() {
        return logName;
    }

    static {
        platformLogName = SystemProperties.get("gateway.logname");
        if (platformLogName != null && (platformLogName = platformLogName.trim().replace('-', '_')).length() == 0) {
            platformLogName = null;
        }
        GWLogManager.createNewAppSession(true);
        createThread = new LogCreateThread();
        Thread thr = new Thread(createThread);
        thr.start();
        remoteLogThread = new RemoteWriteLogThread();
        new Thread(remoteLogThread).start();
        logCreateInvoked = false;
    }
}

