/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.eproxy.GW;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.SRAPSocket;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.mozilla.jss.ssl.SSLServerSocket;

public abstract class ProxyConnection {
    private static String dummyLockString = "DummyLockString";
    private String threadName = null;
    private ServerSocket serverSocket = null;
    private String connectionInfoKey = null;

    public ProxyConnection(String threadName, String connectionInfoKey) {
        this.threadName = threadName;
        this.connectionInfoKey = connectionInfoKey;
    }

    public void start() throws SocketException {
        Thread.currentThread().setName(this.threadName);
        this.serverSocket = this.makeServerSocket();
        Integer logid = new Integer(0);
        GW.run_GW();
        while (this.serverSocket != null) {
            Socket inconnection = null;
            try {
                try {
                    inconnection = this.serverSocket.accept();
                    inconnection.setTcpNoDelay(true);
                    this.incrementSocketCount();
                }
                catch (SocketException se) {
                    continue;
                }
                catch (IOException e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error(this.threadName + " cannot accept new connection on " + this.serverSocket, e);
                    }
                    this.closeServerSocket();
                    this.resetServerSocket();
                    continue;
                }
                if (GWLogManager.loggingEnabled) {
                    logid = new Integer(GWLogManager.getLogId());
                    try {
                        GWLogManager.write(this.threadName, GWLocale.getPFString(this.connectionInfoKey, new Object[]{logid, inconnection.getInetAddress().toString(), new Integer(inconnection.getPort())}));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                try {
                    inconnection.setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error(this.threadName + " cannot set TcpNoDelay on " + inconnection, e);
                    }
                    this.closeSocket(inconnection);
                    inconnection = null;
                    continue;
                }
                this.process(new SRAPSocket(inconnection), logid);
            }
            catch (Throwable t) {
                if (!GWDebug.debug.errorEnabled()) continue;
                GWDebug.debug.error(this.threadName + ": Uncaught exception:", t);
            }
        }
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetServerSocket() throws SocketException {
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String string = dummyLockString;
        synchronized (string) {
            GW.unrun_GW();
            GW.setNumberOfInstances(1);
            this.serverSocket = this.makeServerSocket();
            GW.run_GW();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSocket(Socket socket) {
        try {
            socket.close();
            boolean isHTTPS = this.serverSocket instanceof SSLServerSocket;
            if (PerfContextObject.ENABLE_PERF) {
                if (isHTTPS) {
                    SocketCount.decrementSSLSockets();
                } else {
                    SocketCount.decrementPlainSockets();
                }
            }
        }
        catch (IOException ee) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error(this.threadName + ": IO Exception while closing server socket:", ee);
            }
        }
        finally {
            socket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeServerSocket() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.decrementServerSockets();
                }
            }
            catch (IOException ee) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error(this.threadName + " cannot close server socket", ee);
                }
            }
            finally {
                this.serverSocket = null;
            }
        }
    }

    private void incrementSocketCount() {
        boolean isHTTPS = this.serverSocket instanceof SSLServerSocket;
        if (PerfContextObject.ENABLE_PERF) {
            if (isHTTPS) {
                SocketCount.incrementSSLSockets();
            } else {
                SocketCount.incrementPlainSockets();
            }
        }
    }

    private void stop() {
        if (GWDebug.debug.errorEnabled()) {
            GWDebug.debug.error("FATAL ERROR: " + this.threadName + " exited");
        }
    }

    protected abstract ServerSocket makeServerSocket() throws SocketException;

    protected abstract void process(Socket var1, Integer var2);
}

