/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.calendar;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.calendar.CalendarApplicationHelper;
import com.sun.portal.providers.calendar.CalendarProvider;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import com.sun.ssoadapter.SSOAdapterException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UWCCalendarHelper
implements CalendarApplicationHelper {
    public CalendarProvider provider = null;
    public SSOAdapter ssoAdapter = null;
    public Properties adapterProperties = null;
    public ProviderContext pc = null;
    protected String appName = "";
    protected String containerName = "";
    protected String clientAppURL = "";
    public String charset = null;

    public void init(CalendarProvider provider, SSOAdapter ssoAdapter) throws Exception {
        this.provider = provider;
        this.ssoAdapter = ssoAdapter;
        this.pc = provider.getProviderContext();
        if (ssoAdapter != null) {
            this.adapterProperties = ssoAdapter.getProperties();
        }
        SSOToken token = ssoAdapter.getSSOToken();
        this.charset = token.getProperty("CharSet");
        SSOAdapterDebug.logMessage((String)("UWCCalendarHelper.init(): charset=" + this.charset));
    }

    public StringBuffer getAppPrefsEdit(CalendarProvider cprov, HttpServletRequest req, HttpServletResponse res) {
        StringBuffer content = new StringBuffer();
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        Map dpEditMap = null;
        String fontTag = "";
        try {
            List pflist = this.pc.getClientAndLocalePropertiesFilters();
            dpEditMap = this.pc.getCollectionProperty(cprov.getName(), "dpEditAttributes", pflist);
            fontTag = this.pc.getStringProperty(cprov.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            tagTable.put("isAppHandler", this.getName());
        }
        catch (ProviderContextException pce) {
            this.pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            try {
                ProviderEditUtility.setDefaultPresentation((String)this.provider.getName(), (ProviderContext)this.provider.getProviderContext(), tagTable);
                content.append(this.pc.getTemplate(this.provider.getName(), "edit-start.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
            }
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                while (tok.hasMoreElements()) {
                    String type = tok.nextToken();
                    String header = tok.nextToken();
                    content.append(ProviderEditUtility.createEditContent((String)type, (String)header, (String)key, (String)cprov.getName(), (ProviderContext)this.pc, (boolean)true));
                }
            }
            try {
                ProviderEditUtility.setDefaultPresentation((String)this.provider.getName(), (ProviderContext)this.provider.getProviderContext(), tagTable);
                content.append(this.pc.getTemplate(this.provider.getName(), "edit-end.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
            }
        }
        return content;
    }

    public URL processAppPrefsEdit(CalendarProvider cprov, HttpServletRequest request, HttpServletResponse res) throws ProviderException {
        URL url = null;
        Object props = null;
        Map dpEditMap = null;
        StringBuffer returnURL = new StringBuffer();
        List pflist = null;
        try {
            url = this.getAppHelperProcessURL(request, cprov);
            pflist = this.pc.getClientAndLocalePropertiesFilters();
            dpEditMap = this.pc.getCollectionProperty(cprov.getName(), "dpEditAttributes", pflist);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("UWCCalendarHelper.processAppPrefsEdit():\n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                String type = tok.nextToken();
                try {
                    this.pc.debugMessage((Object)("UWCCalendarHelper.processAppPrefsEdit(): key=" + key));
                    if (type.equals("string") || type.equals("select") || type.equals("password")) {
                        String reqString = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                        if (reqString.equals("")) continue;
                        if (this.pc.existsStringProperty(cprov.getName(), key, pflist)) {
                            this.pc.setStringProperty(cprov.getName(), key, reqString, pflist);
                            this.pc.debugMessage((Object)("UWCCalendarHelper.processAppPrefsEdit(): reqString(filtered)=" + reqString));
                            continue;
                        }
                        if (this.pc.existsStringProperty(cprov.getName(), key)) {
                            this.pc.setStringProperty(cprov.getName(), key, reqString);
                            this.pc.debugMessage((Object)("UWCCalendarHelper.processAppPrefsEdit(): reqString=" + reqString));
                            continue;
                        }
                        this.pc.debugWarning((Object)("UWCCalendarHelper.processAppPrefsEdit(): Unable to save key=" + key));
                        continue;
                    }
                    if (type.equals("int")) {
                        String reqNumber = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                        if (reqNumber.equals("")) continue;
                        if (this.pc.existsIntegerProperty(cprov.getName(), key, pflist)) {
                            this.pc.setIntegerProperty(cprov.getName(), key, Integer.parseInt(reqNumber), pflist);
                            continue;
                        }
                        if (this.pc.existsIntegerProperty(cprov.getName(), key)) {
                            this.pc.setIntegerProperty(cprov.getName(), key, Integer.parseInt(reqNumber));
                            continue;
                        }
                        this.pc.debugWarning((Object)("UWCCalendarHelper.processAppPrefsEdit(): Unable to save key=" + key));
                        continue;
                    }
                    if (!type.equals("check")) continue;
                    String reqBool = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                    Boolean bool = null;
                    bool = reqBool.equals("") ? new Boolean("false") : new Boolean("true");
                    if (this.pc.existsBooleanProperty(cprov.getName(), key, pflist)) {
                        this.pc.setBooleanProperty(cprov.getName(), key, bool.booleanValue(), pflist);
                        continue;
                    }
                    if (this.pc.existsBooleanProperty(cprov.getName(), key)) {
                        this.pc.setBooleanProperty(cprov.getName(), key, bool.booleanValue());
                        continue;
                    }
                    this.pc.debugWarning((Object)("UWCCalendarHelper.processAppPrefsEdit(): Unable to save key=" + key));
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("UWCCalendarHelper.processAppPrefsEdit():\n", (Throwable)pce);
                }
            }
        }
        this.pc.debugMessage((Object)("UWCCalendarHelper::processAppPrefsEdit:  Return url = " + url.toString()));
        return url;
    }

    public String getStartURL(CalendarProvider prov, HttpServletRequest request) {
        return this.getCommsExpressBaseURI().toString();
    }

    public String getEventURL(CalendarProvider provider, HttpServletRequest request, VEvent event) throws Exception {
        StringBuffer baseURL = this.getCommsExpressBaseURI();
        StringBuffer eventURL = new StringBuffer();
        String calid = this.getCalendarToView(provider);
        String eventid = event.getID();
        DateTime recurrenceDateTime = event.getRecurrenceID();
        baseURL.append("/?gotoUri=/calclient/ViewEvent?");
        eventURL.append("eventid=" + eventid);
        eventURL.append("&calid=" + calid);
        if (event.isRecurring() && recurrenceDateTime != null) {
            eventURL.append("&rid=" + recurrenceDateTime.toISO8601());
        }
        baseURL.append(this.encode(eventURL.toString()));
        return baseURL.toString();
    }

    public String getTaskURL(CalendarProvider provider, HttpServletRequest request, VTodo task) throws Exception {
        StringBuffer baseURL = this.getCommsExpressBaseURI();
        StringBuffer taskURL = new StringBuffer();
        String calid = this.getCalendarToView(provider);
        String taskid = task.getID();
        DateTime recurrenceDateTime = task.getRecurrenceID();
        baseURL.append("/?gotoUri=/calclient/ViewTask?");
        taskURL.append("todoUid=" + taskid);
        taskURL.append("&calid=" + calid);
        if (task.isRecurring() && recurrenceDateTime != null) {
            taskURL.append("&rid=" + recurrenceDateTime.toISO8601());
        }
        baseURL.append(this.encode(taskURL.toString()));
        return baseURL.toString();
    }

    public String getAppHelperEditLink(HttpServletRequest req, ProviderContext pc) {
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer link = new StringBuffer();
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return "";
        }
        link.append("?action=edit&provider=");
        link.append(ProviderEditUtility.getRequestParameter((String)"provider", (HttpServletRequest)req));
        link.append("&targetprovider=" + this.provider.getName());
        link.append("&containerName=");
        link.append(ProviderEditUtility.getRequestParameter((String)"containerName", (HttpServletRequest)req));
        link.append("&appPref=" + this.getName());
        tagTable.put("editLink", link.toString());
        String content = null;
        try {
            String fontTag = pc.getStringProperty(this.provider.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            content = pc.getTemplate(this.provider.getName(), "edit-link.template", tagTable).toString();
            pc.debugMessage((Object)("content = \n" + content.toString()));
        }
        catch (Exception e) {
            pc.debugError((Object)"unable to create hyperlink\n", (Throwable)e);
            content = "";
        }
        pc.debugMessage((Object)("UWCCalendarHelper: returned value is" + content.toString()));
        return content;
    }

    protected URL getAppHelperProcessURL(HttpServletRequest req, CalendarProvider prov) {
        ProviderContext pc = prov.getProviderContext();
        StringBuffer link = new StringBuffer();
        URL returnURL = null;
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return null;
        }
        String provider = prov.editContainer;
        String targetProvider = prov.targetProvider;
        String containerName = prov.containerName;
        pc.debugMessage((Object)("UWCCalendarHelper.getAppHelperProcessURL():     provider=" + provider + "\n                                                    targetProvider=" + targetProvider + "\n                                                    containerName=" + containerName));
        if (this.isEmpty(provider) || this.isEmpty(targetProvider) || this.isEmpty(containerName)) {
            pc.debugWarning((Object)"getAppHelperProcessURL():  Missing returnURL parameter and attempting to generate default desktop URL\n");
            try {
                returnURL = new URL(link.toString());
            }
            catch (Exception e) {
                pc.debugWarning((Object)"getAppHelperProcessURL():  Unable to generate default desktop URL\n", (Throwable)e);
                return null;
            }
        }
        link.append("?action=edit&provider=" + provider);
        link.append("&targetprovider=" + targetProvider);
        link.append("&containerName=" + containerName);
        try {
            returnURL = new URL(link.toString());
            pc.debugMessage((Object)("UWCCalendarHelper:getAppHelperProcessURL():  returnURL =" + returnURL));
        }
        catch (Exception e) {
            pc.debugError((Object)"Unable to create returnURL", (Throwable)e);
            return null;
        }
        return returnURL;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public String getName() {
        return this.appName;
    }

    protected boolean isEmpty(String line) {
        return line == null || line.length() > 0;
    }

    public StringBuffer getCommsExpressBaseURI() {
        StringBuffer baseURL = new StringBuffer();
        String host = this.adapterProperties.getProperty("host");
        String clientHost = this.adapterProperties.getProperty("clientHost", host);
        String port = this.adapterProperties.getProperty("clientPort", "80");
        String uwcContext = this.adapterProperties.getProperty("uwcContext");
        String protocol = this.adapterProperties.getProperty("clientProtocol");
        baseURL.append(protocol + "://" + clientHost + ":" + port);
        if (uwcContext != null) {
            if (uwcContext.substring(0).equals("/")) {
                baseURL.append(uwcContext);
            } else {
                baseURL.append("/" + uwcContext);
            }
        }
        return baseURL;
    }

    public String getCalendarToView(CalendarProvider provider) {
        String calendarToDisplay = "";
        String calid = "";
        String domain = "";
        try {
            calendarToDisplay = this.pc.getStringProperty(provider.getName(), "calendar", this.pc.getClientAndLocalePropertiesFilters());
        }
        catch (ProviderContextException pce) {
            calendarToDisplay = null;
        }
        if (calendarToDisplay != null && calendarToDisplay.length() > 0) {
            calid = calendarToDisplay;
        } else {
            calid = this.adapterProperties.getProperty("uid");
            domain = this.adapterProperties.getProperty("domain");
            if (calid == null || calid.length() < 1) {
                String usrAttr = this.adapterProperties.getProperty("userAttribute", "uid");
                try {
                    SSOToken tok = this.ssoAdapter.getSSOToken();
                    AMStoreConnection amsc = new AMStoreConnection(tok);
                    AMUser auser = amsc.getUser(tok.getPrincipal().getName());
                    calid = auser.getStringAttribute(usrAttr);
                }
                catch (SSOAdapterException ssae) {
                    SSOAdapterDebug.logError((String)"UWCCalendarHelper.getCalendarToView(): proxy uid retrieval failed ", (Throwable)ssae);
                }
                catch (SSOException ssoe) {
                    SSOAdapterDebug.logError((String)"UWCCalendarHelper.getCalendarToView(): proxy uid retrieval failed ", (Throwable)ssoe);
                }
                catch (AMException ame) {
                    SSOAdapterDebug.logError((String)"UWCCalendarHelper.getCalendarToView(): proxy uid retrieval failed ", (Throwable)ame);
                }
            }
            if (domain != null && domain.length() > 0) {
                calid = calid + "@" + domain;
            }
        }
        return calid;
    }

    public String encode(String enc) {
        String result = "";
        try {
            result = URLEncoder.encode(enc, this.charset);
        }
        catch (UnsupportedEncodingException uee) {
            SSOAdapterDebug.logWarning((String)"UWCCalendarHelper.encode():  Exception thrown encoding string. Returning unencoded string.", (Throwable)uee);
            return enc;
        }
        return result;
    }
}

