/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.client;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.client.AttributeExtractor;
import com.sun.portal.rproxy.configservlet.client.GetResponseException;
import com.sun.portal.rproxy.configservlet.client.SendRequestException;
import com.sun.portal.rproxy.configservlet.client.UserProfileGatewayCache;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.SSOUtil;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserProfile {
    private static final String GET_REQUEST = "GET_USERS";
    private Map result;
    private String sId;
    private static final String SET_USER_ATTRIBUTES = "SET_USER_ATTRIBUTES";

    public String toString() {
        return this.result.toString();
    }

    public UserProfile(String sessionId) throws SendRequestException, GetResponseException {
        block5: {
            try {
                this.sId = null;
                SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
                SSOToken s = null;
                try {
                    s = SSOUtil.getSSOTokenThrowExceptionToClient((String)sessionId);
                }
                catch (SSOException ssoEx) {
                    this.result = null;
                }
                catch (Exception e) {
                    this.result = null;
                }
                String cookieEncode = SystemProperties.get((String)"com.iplanet.am.cookie.encode");
                this.sId = cookieEncode.equals("false") ? sessionId : URLDecoder.decode(sessionId);
                this.result = s == null || !ssoTokenManager.isValidToken(s) ? null : UserProfileGatewayCache.getResponse(this.sId);
            }
            catch (Exception ex) {
                this.result = null;
                if (!GWDebug.debug.errorEnabled()) break block5;
                GWDebug.debug.error("Exception getting user profile", (Throwable)ex);
            }
        }
    }

    public String getSessionID() {
        return this.sId;
    }

    public String getString(String name, String defaultValue) {
        if (this.result != null) {
            return AttributeExtractor.getString(this.result, name, defaultValue);
        }
        return defaultValue;
    }

    public int getInt(String name, int defaultValue) {
        if (this.result != null) {
            return AttributeExtractor.getInt(this.result, name, defaultValue);
        }
        return defaultValue;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        if (this.result != null) {
            return AttributeExtractor.getBoolean(this.result, name, defaultValue);
        }
        return defaultValue;
    }

    public List getStringList(String name) {
        if (this.result != null) {
            return AttributeExtractor.getStringList(this.result, name);
        }
        return new ArrayList();
    }

    public static void setAttributes(String sessionId, String attribute, Set value) throws SendRequestException, GetResponseException {
        UserProfileGatewayCache.setAttribute(sessionId, attribute, value);
    }
}

