/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.client;

import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.client.CDCacheEntry;
import com.sun.portal.rproxy.configservlet.client.SrapClient;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.SystemProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ClientDetector
implements Runnable {
    private static ClientDetector cd = new ClientDetector();
    private HashMap table = new HashMap();
    private static final String CDM_GET_CLIENT_PROPERTY = "CDM_GET_CLIENT_PROPERTY";
    private static int CACHE_SLEEP_TIME;
    private static int CLEANUP_TIME;

    private ClientDetector() {
    }

    public static String isCookieSupported(HttpServletRequest req) {
        String userAgent = req.getHeader("User-Agent");
        if (userAgent == null) {
            return "autodetect";
        }
        userAgent = userAgent.substring(userAgent.indexOf(":") + 1).trim();
        return cd.isCookieSupportedImpl(userAgent);
    }

    private String isCookieSupportedImpl(String userAgent) {
        CDCacheEntry result = this.retrieveValue(userAgent);
        if (result == null) {
            result = this.fetchCookieSupport(userAgent);
        }
        return result.toString();
    }

    private CDCacheEntry fetchCookieSupport(String userAgent) {
        String result;
        Response response;
        CDCacheEntry retval = null;
        Request request = new Request(null, null, CDM_GET_CLIENT_PROPERTY, userAgent);
        try {
            response = SrapClient.execute(request);
        }
        catch (Exception ex) {
            response = null;
        }
        if (response != null && (result = response.getReturnedObject().toString()) != null) {
            retval = new CDCacheEntry(result);
            this.storeValue(userAgent, retval);
        }
        return retval;
    }

    private synchronized void storeValue(Object key, Object value) {
        this.table.put(key, value);
    }

    private synchronized CDCacheEntry retrieveValue(Object key) {
        return (CDCacheEntry)this.table.get(key);
    }

    public void run() {
        boolean done = false;
        while (!done) {
            try {
                block5: {
                    try {
                        Thread.currentThread();
                        Thread.sleep(CACHE_SLEEP_TIME);
                    }
                    catch (InterruptedException iEx) {
                        if (!GWDebug.debug.messageEnabled()) break block5;
                        GWDebug.debug.message("Exception in ClientDetector cache cleaner thread ", (Throwable)iEx);
                    }
                }
                this.cleanupCache();
            }
            catch (Throwable th) {
                if (!GWDebug.debug.messageEnabled()) continue;
                GWDebug.debug.message("Throwable thrown in ClientDetector cache cleaner thread ", th);
            }
        }
    }

    private synchronized void cleanupCache() {
        Set set = this.table.keySet();
        Iterator iter = set.iterator();
        long currtime = System.currentTimeMillis();
        while (iter.hasNext()) {
            Object key = iter.next();
            CDCacheEntry entry = (CDCacheEntry)this.table.get(key);
            if (currtime - entry.getTimestamp() <= (long)CLEANUP_TIME) continue;
            iter.remove();
        }
    }

    static {
        new Thread(cd).start();
        try {
            CACHE_SLEEP_TIME = Integer.parseInt(SystemProperties.get((String)"gateway.cdm.cacheSleepTime", (String)"60000"));
        }
        catch (Exception ex) {
            CACHE_SLEEP_TIME = 60000;
        }
        try {
            CLEANUP_TIME = Integer.parseInt(SystemProperties.get((String)"gateway.cdm.cacheCleanupTime", (String)"300000"));
        }
        catch (Exception ex) {
            CLEANUP_TIME = 300000;
        }
    }
}

