/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.common;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.portal.netlet.client.common.BrowserType;
import com.sun.portal.netlet.client.common.ClientConfig;
import com.sun.portal.netlet.client.common.Connection;
import com.sun.portal.netlet.client.common.ProxyAuthFailedException;
import com.sun.portal.netlet.client.common.ProxyAuthNeededException;
import com.sun.portal.netlet.client.common.ProxySConn;
import com.sun.portal.netlet.econnection.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.PropertyResourceBundle;

public class ClientUtil {
    public static InputStream netletConfig(String func) {
        InputStream is = null;
        try {
            String jsDocumentDomain = ClientConfig.getParam("jsDocumentDomain");
            URL url = null;
            url = jsDocumentDomain != null ? new URL(ClientConfig.getTargetURL() + "?func=" + func + "&document.domain=" + jsDocumentDomain) : new URL(ClientConfig.getTargetURL() + "?func=" + func);
            System.out.println("Netlet config: " + url.toString());
            URLConnection uconn = url.openConnection();
            uconn.setRequestProperty("Cookie", ClientConfig.getCookieName() + "=" + URLEncoder.encode(ClientConfig.getSessionID()));
            uconn.setRequestProperty("PS-Netlet", "enabled=true");
            uconn.setDoInput(true);
            uconn.setUseCaches(false);
            uconn.setAllowUserInteraction(false);
            is = uconn.getInputStream();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.err.println("MalformedURLException " + e);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("IOException " + e);
        }
        return is;
    }

    public static InputStream sendByPost(String func, String postBody) {
        InputStream is = null;
        try {
            String jsDocumentDomain = ClientConfig.getParam("jsDocumentDomain");
            URL url = null;
            url = jsDocumentDomain != null ? new URL(ClientConfig.getTargetURL() + "?func=" + func + "&document.domain=" + jsDocumentDomain) : new URL(ClientConfig.getTargetURL() + "?func=" + func);
            System.out.println("Post URL -> " + url.toString());
            URLConnection uconn = url.openConnection();
            uconn.setRequestProperty("Cookie", ClientConfig.getCookieName() + "=" + URLEncoder.encode(ClientConfig.getSessionID()));
            uconn.setRequestProperty("PS-Netlet", "enabled=true");
            uconn.setDoOutput(true);
            uconn.setDoInput(true);
            uconn.setUseCaches(false);
            uconn.setAllowUserInteraction(false);
            DataOutputStream out = new DataOutputStream(uconn.getOutputStream());
            out.writeBytes(postBody);
            out.flush();
            out.close();
            out = null;
            is = uconn.getInputStream();
        }
        catch (IOException e) {
            System.out.println("sendByPost: Unable to connect to server -> " + e);
        }
        return is;
    }

    public static String rfc1522(String in) {
        boolean hi = false;
        for (int c = 0; c < in.length(); ++c) {
            char tc = in.charAt(c);
            if (tc <= '\u007f') continue;
            hi = true;
            break;
        }
        if (!hi) {
            return in;
        }
        return "=?UTF-8?B?" + Base64.encode(in) + "?=";
    }

    public static String parsePACFile(String autoConfigURL) {
        String result = "FAILED";
        String pacFileBody = "No";
        boolean redirect = false;
        InputStream autoConfigURLInputStream = null;
        String contentType = new String();
        int contentSize = 0;
        try {
            do {
                redirect = false;
                if (autoConfigURL.trim().startsWith("http")) {
                    URL configURL = new URL(autoConfigURL);
                    URLConnection configURLConn = configURL.openConnection();
                    configURLConn.setUseCaches(false);
                    configURLConn.setDoInput(true);
                    configURLConn.setAllowUserInteraction(false);
                    contentType = configURLConn.getContentType();
                    autoConfigURLInputStream = configURLConn.getInputStream();
                    contentSize = configURLConn.getContentLength();
                } else {
                    if (autoConfigURL.charAt(7) != '/') {
                        autoConfigURL = "file:///" + autoConfigURL.substring(7);
                    }
                    URL url = new URL(autoConfigURL);
                    URLConnection conn = url.openConnection();
                    autoConfigURLInputStream = conn.getInputStream();
                    contentSize = conn.getContentLength();
                    contentType = "file";
                }
                if (!contentType.equalsIgnoreCase("application/x-internet-signup") && !autoConfigURL.trim().toUpperCase().endsWith(".INS")) continue;
                PropertyResourceBundle insRes = null;
                String autoConfigJS = null;
                try {
                    DataInputStream in = new DataInputStream(autoConfigURLInputStream);
                    insRes = new PropertyResourceBundle(in);
                    autoConfigJS = insRes.getString("AutoConfigJSURL");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (autoConfigJS != null && !autoConfigJS.trim().equals("")) {
                    autoConfigURL = autoConfigJS;
                    redirect = true;
                    continue;
                }
                String redirectAutoConfigURL = null;
                try {
                    redirectAutoConfigURL = insRes.getString("AutoConfigURL");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (redirectAutoConfigURL != null && !redirectAutoConfigURL.trim().equals("")) {
                    if (!redirectAutoConfigURL.trim().equalsIgnoreCase(autoConfigURL.trim())) {
                        autoConfigURL = redirectAutoConfigURL;
                        redirect = true;
                        continue;
                    }
                    System.out.println("AutoConfigJSURL is not defined in the Ins file");
                    return "DIRECT";
                }
                System.out.println("AutoConfigURL is not defined in the Ins file");
                return "DIRECT";
            } while (redirect);
            DataInputStream in = new DataInputStream(autoConfigURLInputStream);
            byte[] data = null;
            byte[] buf = new byte[128];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            int numberOfBytes = 1;
            while (numberOfBytes > 0) {
                try {
                    numberOfBytes = in.read(buf);
                    if (numberOfBytes <= 0) continue;
                    dos.write(buf, 0, numberOfBytes);
                }
                catch (IOException ioe) {
                    numberOfBytes = 0;
                }
            }
            try {
                dos.flush();
                data = baos.toByteArray();
                in.close();
                dos.close();
                System.out.println("PAC file content length -> " + data.length);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            pacFileBody = new String(data);
            pacFileBody = URLEncoder.encode(pacFileBody);
        }
        catch (Exception ex) {
            if (contentSize <= 0) {
                System.out.println("Invalid PAC file location.Setting Proxy setting to DIRECT!");
                return "DIRECT";
            }
            ex.printStackTrace();
        }
        String qString = "parsePacFile&PacFileUrl=" + autoConfigURL;
        qString = qString + "&ServerURL=" + ClientConfig.getTargetURL();
        String myIPAddr = "255.255.255.255";
        try {
            myIPAddr = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        qString = qString + "&ClientIPAddr=" + myIPAddr;
        String qSt = "&PacFileBody=" + pacFileBody;
        pacFileBody = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(ClientUtil.sendByPost(qString, qSt)));
            result = result == null || result.equals("null") ? "FAILED" : in.readLine();
            System.out.println(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static boolean isProxySettingsValid(String proxySSL, int proxySSLPort) {
        Connection sconn = null;
        try {
            sconn = new ProxySConn(proxySSLPort, proxySSL, ClientConfig.getDestPort(), ClientConfig.getDestHost(), null);
        }
        catch (ProxyAuthNeededException e) {
            try {
                sconn = new ProxySConn(proxySSLPort, proxySSL, ClientConfig.getDestPort(), ClientConfig.getDestHost(), true, null);
            }
            catch (ProxyAuthNeededException ee) {
                System.out.println("Invalid proxy information");
            }
            catch (ProxyAuthFailedException ee) {
                System.out.println("Invalid proxy information");
            }
        }
        catch (ProxyAuthFailedException e) {
            System.out.println("Invalid proxy information");
        }
        Socket out_s = sconn.getconn();
        return out_s != null;
    }

    public static boolean isClientBindIPValid(String clientBindIP) {
        ServerSocket echoSock = null;
        boolean valid = false;
        boolean go = true;
        int retries = 5;
        while (go) {
            try {
                InetAddress bindAddr = null;
                bindAddr = InetAddress.getByName(clientBindIP);
                BrowserType browser = BrowserType.getInstance();
                if (browser.getIEBrowser() && browser.getJavaVMVersion() == 1) {
                    try {
                        if (Class.forName("com.ms.security.PolicyEngine") != null) {
                            PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                        }
                    }
                    catch (Exception cnfe) {
                        // empty catch block
                    }
                }
                echoSock = new ServerSocket(0, 10, bindAddr);
                valid = true;
                if (echoSock != null) {
                    echoSock.close();
                    echoSock = null;
                }
                go = false;
            }
            catch (UnknownHostException uhe) {
                System.out.println("Unable to make server socket to host " + clientBindIP + " " + uhe);
                echoSock = null;
                go = false;
            }
            catch (IOException ioe) {
                System.out.println("Unable to make server socket to host " + clientBindIP + " " + ioe);
                echoSock = null;
                go = retries > 0;
                --retries;
            }
        }
        return valid;
    }

    public static boolean wildcardMatch(String str1, String str2) {
        int beginIndex1 = 0;
        int endIndex1 = 0;
        int beginIndex2 = 0;
        int endIndex2 = 0;
        int strlen1 = str1.length();
        int strlen2 = str2.length();
        String substr = null;
        if (str1 == null || str2 == null) {
            return false;
        }
        endIndex2 = str2.indexOf(42, beginIndex2);
        if (endIndex2 != -1) {
            substr = str2.substring(beginIndex2, endIndex2);
            if (endIndex2 > beginIndex2) {
                if ((beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                    return false;
                }
                if (beginIndex1 != beginIndex2) {
                    return false;
                }
            }
            beginIndex1 += endIndex2 - beginIndex2;
            if (endIndex2 >= strlen2 - 1) {
                return true;
            }
            beginIndex2 = endIndex2 + 1;
        } else {
            beginIndex1 = str1.indexOf(str2);
            if (beginIndex1 == -1) {
                return false;
            }
            return strlen1 == strlen2;
        }
        while ((endIndex2 = str2.indexOf(42, beginIndex2)) != -1) {
            substr = str2.substring(beginIndex2, endIndex2);
            if (endIndex2 > beginIndex2 && (beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                return false;
            }
            beginIndex1 += endIndex2 - beginIndex2;
            if (endIndex2 >= strlen2 - 1) {
                return true;
            }
            beginIndex2 = endIndex2 + 1;
        }
        substr = str2.substring(beginIndex2, strlen2);
        endIndex1 = str1.lastIndexOf(substr, strlen1 - 1);
        if (endIndex1 == -1) {
            return false;
        }
        if (beginIndex1 > endIndex1) {
            return false;
        }
        beginIndex1 = endIndex1;
        return strlen1 - beginIndex1 == strlen2 - beginIndex2;
    }
}

