/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.tools.MultipartHttpServletRequest;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class XSLServlet
extends HttpServlet {
    protected String _config_filename = "xsl.properties";
    public static final String CONFIG_LOGFILE = "log.file";
    public static final String CONFIG_LOGLEVEL = "log.level";
    public static final String CONFIG_LOGCOMPONENTS = "log.components";
    public static final String CONFIG_MAXPOSTCONTENTLENGTH = "maxpostcontentlength";
    public static final String CONFIG_CONFIGPATH_SUFFIX = ".configpath";
    private int _maxPostContentLength = -1;
    private PropertyReader _propertyReader;
    private static final String TRANSLETS_LIBPATH_PROPERTY = "com.sun.iabs.translets.libPath";

    public void init(ServletConfig config) throws ServletException {
        ServletContext ctx;
        String libPath = null;
        super.init(config);
        String configPathRoot = config.getInitParameter("configPath");
        if (configPathRoot == null && (configPathRoot = (ctx = config.getServletContext()).getRealPath("/")) == null) {
            configPathRoot = "./";
        }
        Properties props = System.getProperties();
        libPath = configPathRoot + File.separator + "WEB-INF" + File.separator + "lib";
        try {
            libPath = new File(libPath).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServletException("XSLServlet.init(): Trouble getting the canonical path of : " + libPath);
        }
        props.setProperty(TRANSLETS_LIBPATH_PROPERTY, libPath);
        File configPath = new File(new File(configPathRoot, "local-conf"), "config");
        if (!configPath.isDirectory() && !(configPath = new File(configPathRoot, "WEB-INF/config")).isDirectory()) {
            throw new ServletException("XSLServlet: can't open configuration dir " + configPath.toString());
        }
        try {
            this._propertyReader = new PropertyReader(configPath, this._config_filename);
        }
        catch (Exception ex) {
            throw new ServletException("XSLServlet: can't open configuration file " + this._config_filename + " in " + configPath.toString() + " : " + ex.getMessage());
        }
        String sFile = this._propertyReader.getStringProperty(CONFIG_LOGFILE, "");
        int logLevel = this._propertyReader.getIntProperty(CONFIG_LOGLEVEL, 2);
        int logComponents = this._propertyReader.getIntProperty(CONFIG_LOGCOMPONENTS, 2);
        Logging logHandler = null;
        if (sFile.length() > 0) {
            File logFile = new File(sFile);
            logHandler = new Logging(logFile);
        } else {
            logHandler = new Logging(this.getServletContext());
        }
        Logging.setState(logLevel);
        Logging.setPackage(logComponents);
        this._maxPostContentLength = this._propertyReader.getIntProperty(CONFIG_MAXPOSTCONTENTLENGTH, -1);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contentType = request.getContentType();
        if (contentType != null && contentType.toLowerCase().startsWith("multipart/form-data")) {
            if (this._maxPostContentLength != -1) {
                int size = request.getContentLength();
                if (size < this._maxPostContentLength && size >= 0) {
                    MultipartHttpServletRequest multiRequest = new MultipartHttpServletRequest(request);
                    this.doGet((HttpServletRequest)multiRequest, response);
                } else {
                    response.sendError(413, "Sorry, the file submitted is too large.");
                }
            }
        } else {
            this.doGet(request, response);
        }
    }

    public String getServletInfo() {
        return "XSL Servlet: " + ((Object)((Object)this)).getClass().getName();
    }

    public PropertyReader getPropertyReader() {
        return this._propertyReader;
    }
}

