/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.ui.SessionObjectFactory;
import com.iplanet.xslui.ui.XSLServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuthSDKServlet
extends XSLServlet {
    public static final String CONFIG_FILENAME = "xslui.properties";
    public static final String CONFIG_LOGINPAGETEMPLATE = "loginpagetemplate.";
    public static final String CONFIG_SESSIONOBJ_PREFIX = "sessionobjfactory.";
    public static final String CONFIG_SESSIONID_SUFFIX = ".sessionid";
    public static final String CONFIG_DEPLOYED_PATH = "deployedpath";
    private Hashtable _sessionObjTable = null;
    private String deployedPath = null;

    public void init(ServletConfig config) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(config);
        PropertyReader propertyReader = super.getPropertyReader();
        if (propertyReader == null) {
            throw new ServletException("Couldn't get config from xslui.properties");
        }
        this.deployedPath = propertyReader.getStringProperty(CONFIG_DEPLOYED_PATH, "/abs");
        this._sessionObjTable = new Hashtable();
        Enumeration enumeration = propertyReader.getKeyProperty(CONFIG_SESSIONOBJ_PREFIX, ".class");
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String key = CONFIG_SESSIONOBJ_PREFIX + (String)enumeration.nextElement();
                String sessionID = propertyReader.getStringProperty(key + CONFIG_SESSIONID_SUFFIX, null);
                Object factory = null;
                try {
                    factory = propertyReader.getObjectProperty(key, true);
                }
                catch (Exception ex) {
                    Logging.error(64, "Exception thrown while creating Factory for: " + key);
                    Logging.errorPrintStackTrace(ex);
                    throw new ServletException("Exception thrown while creating Factory for: " + key);
                }
                if (sessionID != null && sessionID.length() > 0) {
                    if (factory != null) {
                        this._sessionObjTable.put(sessionID, factory);
                        continue;
                    }
                    Logging.error(64, "Couldn't create Factory for: " + key);
                    throw new ServletException("error while creating Factory for: " + key);
                }
                Logging.error(64, "No sessionid for: " + key);
            }
        } else {
            Logging.error(64, "No sessionObject defined");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = null;
        session = request.getSession(true);
        UserSession userSession = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
        String validClientIP = (String)request.getAttribute("validClientIP");
        if (userSession == null) {
            Logging.error(64, "No usersession");
            return;
        }
        if (validClientIP != null && validClientIP.equals("false")) {
            Logging.error(64, "Client IP Conflict");
            return;
        }
        Enumeration enumeration = this._sessionObjTable.keys();
        while (enumeration.hasMoreElements()) {
            String sessionID = (String)enumeration.nextElement();
            Object sessionObj = session.getAttribute(sessionID);
            if (sessionObj != null) continue;
            SessionObjectFactory sessionObjFactory = (SessionObjectFactory)this._sessionObjTable.get(sessionID);
            sessionObj = sessionObjFactory.newSessionObject(userSession, userSession.getDomain());
            if (sessionObj != null) {
                session.setAttribute(sessionID, sessionObj);
                continue;
            }
            Logging.error(64, "Can't create SessionObject: " + sessionID + " for user " + userSession.getUserId());
        }
        String queryString = request.getQueryString();
        if (queryString == null || queryString.indexOf("logout") == -1) {
            PrintWriter out = null;
            String locationString = null;
            response.setContentType("text/plain");
            String encodedURL = response.encodeURL("/").substring(1);
            if (encodedURL == null || encodedURL.equals("")) {
                encodedURL = ";jsessionid=" + request.getSession(false).getId();
            }
            locationString = request.getScheme() + "://" + request.getServerName() + ":";
            locationString = locationString + new Integer(request.getServerPort()).toString() + this.deployedPath + "/search.xml";
            locationString = locationString + encodedURL;
            out = response.getWriter();
            response.setHeader("Location", locationString);
            out.close();
        } else if (queryString.indexOf("logout") != -1) {
            request.getSession(false).invalidate();
        }
    }
}

