/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.ABUserSessionFactory;
import com.iplanet.xslui.auth.Domain;
import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.ui.SessionObjectFactory;
import com.iplanet.xslui.ui.XSLUIEngineServlet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;

public class ABUserSession
implements UserSession {
    public static final String UID = "uid";
    public static final String USERDN = "userdn";
    public static final String USER_LANG = "userlang";
    public static final String DEFAULTLANGUAGE = "en";
    public static final String PSROOT_ATTR_NAME = "psRoot";
    private HttpSession _session = null;
    private Domain _domain = null;
    private String _password = null;
    private static SessionObjectFactory _sessionFactory = null;

    public ABUserSession(HttpSession session) {
        this._session = session;
    }

    public String getUserId() {
        return this.getUserAttrib(UID);
    }

    public String getUserDN() {
        return this.getUserAttrib(USERDN);
    }

    public String getDomain() {
        return (String)this._session.getAttribute("domainname");
    }

    public String getPreferredLanguage() {
        String lang = this.getUserAttrib(USER_LANG);
        if (lang == null) {
            lang = DEFAULTLANGUAGE;
        }
        return lang;
    }

    public String getDN() {
        return (String)this._session.getAttribute("domaindn");
    }

    public String getUserAttrib(String attribName) {
        if (attribName == null) {
            return null;
        }
        return (String)this._session.getAttribute(attribName);
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getPassword() {
        return this._password;
    }

    private SessionObjectFactory getSessionObjFactory() {
        if (_sessionFactory != null) {
            return _sessionFactory;
        }
        Hashtable sessionObjTable = XSLUIEngineServlet.getSessionObjectTable();
        if (sessionObjTable != null) {
            Enumeration enumeration = sessionObjTable.keys();
            while (enumeration.hasMoreElements()) {
                String sessionID = (String)enumeration.nextElement();
                _sessionFactory = (SessionObjectFactory)sessionObjTable.get(sessionID);
            }
        }
        return _sessionFactory;
    }

    public static ABUserSession createUserSession(HttpSession session) {
        ABUserSessionFactory userFactory = new ABUserSessionFactory();
        ABUserSession userSession = null;
        String domain = (String)session.getAttribute("domainname");
        if (userFactory != null) {
            userSession = (ABUserSession)userFactory.newUserSession(session);
        }
        Logging.trace(32, "Got UserSession");
        return userSession;
    }
}

