/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletappengine.impl;

import com.sun.portal.common.logging.Level;
import com.sun.portal.common.logging.Logger;
import com.sun.portal.portlet.impl.ActionRequestPool;
import com.sun.portal.portlet.impl.ActionResponsePool;
import com.sun.portal.portlet.impl.RenderRequestPool;
import com.sun.portal.portlet.impl.RenderResponsePool;
import com.sun.portal.portletappengine.RequestResponseFactory;
import com.sun.portal.portletcontainercommon.PortletContainerActionRequest;
import com.sun.portal.portletcontainercommon.PortletContainerActionResponse;
import com.sun.portal.portletcontainercommon.PortletContainerRenderRequest;
import com.sun.portal.portletcontainercommon.PortletContainerRenderResponse;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestResponseFactoryImpl
implements RequestResponseFactory {
    public static final String MIN_SIZE = "minSizeParam";
    public static final String MAX_SIZE = "maxSizeParam";
    public static final String PARTITION = "partitionParam";
    private static ActionRequestPool _actionRequestPool;
    private static RenderRequestPool _renderRequestPool;
    private static ActionResponsePool _actionResponsePool;
    private static RenderResponsePool _renderResponsePool;
    private static Logger _logger;
    private static final int DEFAULT_MIN_SIZE = 0;
    private static final int DEFAULT_MAX_SIZE = 200;
    private static final int DEFAULT_PARTITION_SIZE = 10;
    private static final int ACTION_REQUEST = 1;
    private static final int RENDER_REQUEST = 2;
    private static final int ACTION_RESPONSE = 3;
    private static final int RENDER_RESPONSE = 4;

    public void init(ServletContext context) {
        _logger = (Logger)context.getAttribute("logger");
        String min = context.getInitParameter("request_response_factory.minSizeParam").trim();
        String max = context.getInitParameter("request_response_factory.maxSizeParam").trim();
        String partition = context.getInitParameter("request_response_factory.partitionParam").trim();
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, "RequestResponseFactoryImpl.init(), minSize: " + min);
            _logger.log(Level.INFO, "RequestResponseFactoryImpl.init(), maxSize: " + max);
            _logger.log(Level.INFO, "RequestResponseFactoryImpl.init(), partition: " + partition);
        }
        this.initRequestResponsePool(context, Integer.parseInt(min), Integer.parseInt(max), Integer.parseInt(partition), 1);
        this.initRequestResponsePool(context, Integer.parseInt(min), Integer.parseInt(max), Integer.parseInt(partition), 2);
        this.initRequestResponsePool(context, Integer.parseInt(min), Integer.parseInt(max), Integer.parseInt(partition), 3);
        this.initRequestResponsePool(context, Integer.parseInt(min), Integer.parseInt(max), Integer.parseInt(partition), 4);
    }

    public ActionRequest getActionRequest(HttpServletRequest req, HttpServletResponse res, PortletContainerActionRequest pContReq, PortletContainerActionResponse pContRes, PortletContext context, PortalContext portalContext, PortletDescriptor pDescriptor, StringWriter writer) {
        return _actionRequestPool.obtainObject(req, res, pContReq, pContRes, context, portalContext, pDescriptor, writer);
    }

    public RenderRequest getRenderRequest(HttpServletRequest req, HttpServletResponse res, PortletContainerRenderRequest pContReq, PortletContainerRenderResponse pContRes, PortletContext context, PortalContext portalContext, PortletDescriptor pDescriptor) {
        return _renderRequestPool.obtainObject(req, res, pContReq, pContRes, context, portalContext, pDescriptor);
    }

    public ActionResponse getActionResponse(HttpServletRequest req, HttpServletResponse res, ActionRequest aReq, PortletContainerActionRequest pContReq, PortletContainerActionResponse pContRes) {
        return _actionResponsePool.obtainObject(req, res, aReq, pContReq, pContRes);
    }

    public RenderResponse getRenderResponse(HttpServletRequest req, HttpServletResponse res, RenderRequest rReq, PortletContainerRenderRequest pContReq, PortletContainerRenderResponse pContRes, StringWriter writer, ByteArrayOutputStream output, PortletDescriptor pDescriptor) {
        return _renderResponsePool.obtainObject(req, res, rReq, pContReq, pContRes, writer, output, pDescriptor);
    }

    public void releaseActionRequest(ActionRequest actionReq) {
        _actionRequestPool.releaseObject(actionReq);
    }

    public void releaseRenderRequest(RenderRequest renderReq) {
        _renderRequestPool.releaseObject(renderReq);
    }

    public void releaseActionResponse(ActionResponse actionRes) {
        _actionResponsePool.releaseObject(actionRes);
    }

    public void releaseRenderResponse(RenderResponse portletRes) {
        _renderResponsePool.releaseObject(portletRes);
    }

    private void initRequestResponsePool(ServletContext context, int minSize, int maxSize, int partition, int type) {
        if (minSize < 0) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "RequestResponseFactoryImpl.initPortletRequestPool: invalid min size , use default: 0");
            }
            minSize = 0;
        }
        if (maxSize < 0) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "RequestResponseFactoryImpl.initPortletRequestPool: invalid max size , use default: 200");
            }
            maxSize = 200;
        }
        if (partition < 0) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "RequestResponseFactoryImpl.initPortletRequestPool: invalid partition size , use default: 10");
            }
            partition = 10;
        }
        if (minSize > maxSize) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "RequestResponseFactoryImpl.initPortletRequestPool: invalid min size , use max : 200");
            }
            minSize = 200;
        }
        if (partition > maxSize) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "RequestResponseFactoryImpl.initPortletRequestPool: invalid partition size , use max : 200");
            }
            partition = 200;
        }
        switch (type) {
            case 1: {
                _actionRequestPool = new ActionRequestPool(context, minSize, maxSize, true, partition, _logger);
                break;
            }
            case 2: {
                _renderRequestPool = new RenderRequestPool(context, minSize, maxSize, true, partition, _logger);
                break;
            }
            case 3: {
                _actionResponsePool = new ActionResponsePool(minSize, maxSize, true, partition, _logger);
                break;
            }
            case 4: {
                _renderResponsePool = new RenderResponsePool(minSize, maxSize, true, partition, _logger);
            }
        }
    }

    public void destroy() {
        _actionRequestPool = null;
        _renderRequestPool = null;
        _actionResponsePool = null;
        _renderResponsePool = null;
    }
}

