/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.rdmserver;

import com.sun.portal.search.rdm.RDMRequest;
import com.sun.portal.search.rdm.RDMResponse;
import com.sun.portal.search.rdm.RDMServerDescription;
import com.sun.portal.search.rdmserver.RDMService;
import com.sun.portal.search.rdmserver.RDMServiceDescriptor;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.util.CSLog;
import com.sun.portal.search.util.SearchConfig;

public class ServerDescriptionService
extends RDMService {
    RDMServerDescription sd;

    public ServerDescriptionService() {
        this.supportedServices.add(new RDMServiceDescriptor("server-description-request", null));
    }

    public void service(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        rDMResponse.getHeader().setType("server-description-response");
        if (this.sd == null) {
            this.loadServerDescription(rDMRequest, rDMResponse);
        }
        rDMResponse.sendHeader();
        rDMResponse.getOutputStream().write(this.sd.getSOIF());
        rDMRequest.logRDM("xfer=1");
    }

    synchronized void loadServerDescription(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        if (this.sd != null) {
            return;
        }
        String string = rDMRequest.getHeader().getCSID();
        String string2 = null;
        string2 = SearchConfig.getValue("server-description");
        if (string2 == null) {
            CSLog.error(1, 1, "Missing 'server-description.");
            throw new Exception("Missing server description");
        }
        SOIFInputStream sOIFInputStream = null;
        try {
            sOIFInputStream = new SOIFInputStream(string2);
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "Cannot read " + string2 + ".");
            throw exception;
        }
        try {
            this.sd = new RDMServerDescription(sOIFInputStream, null);
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "Cannot parse " + string2 + ".");
            throw exception;
        }
    }
}

