/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.calendar;

import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderAdapter;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.calendar.CalendarApplicationHelper;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.SSOAdapterFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CalendarProvider
extends ProfileProviderAdapter {
    private static final int DAYS_OF_PREFETCHED_EVENTS = 7;
    private TimeZone userTimeZone = null;
    private Locale userLocale = null;
    private ResourceBundle bundle = null;
    private ProviderContext providerContext = null;
    protected SSOAdapterFactory adapterFactory = null;
    protected HashMap appHandlers = null;
    private String fontFace = null;
    private String bundleAllDayEvent = null;
    private String bundleAtLocation = null;
    private String bundleAtNoLocation = null;
    private String bundleConflict = null;
    private String bundleDescriptionSeperator = null;
    private String bundleDueEvents = null;
    private String bundleDueTasks = null;
    private String bundleFetchError = null;
    private String bundleNoSummary = null;
    private String bundleOpenError = null;
    private String bundleOtherTasks = null;
    private String bundleOverdueTasks = null;
    private String bundleProcessingError = null;
    private String bundleTaskCompleteStart = null;
    private String bundleTaskCompleteEnd = null;
    protected boolean isSSOConfigFound = true;
    protected Boolean isPresentable = null;
    protected String editContainer = "";
    protected String targetProvider = "";
    protected String containerName = "";
    protected List pflist = null;

    public void init(String name, HttpServletRequest request) throws ProviderException {
        super.init(name, request);
        try {
            this.pflist = this.getProviderContext().getClientAndLocalePropertiesFilters();
        }
        catch (ProviderContextException pce) {
            this.debugWarning("CalendarProvider.init(): Unable to fetch DP filters.");
        }
        this.bundle = this.getResourceBundle();
        this.providerContext = this.getProviderContext();
        this.fontFace = this.getBestStringProperty("fontFace1", "Sans-serif", this.pflist);
        this.appHandlers = new HashMap();
        this.adapterFactory = SSOAdapterFactory.getInstance();
        try {
            this.bundleAllDayEvent = this.bundle.getString("CalendarProvider-allDayEvent");
            this.bundleAtLocation = this.bundle.getString("atLocation");
            this.bundleAtNoLocation = this.bundle.getString("atNoLocation");
            this.bundleConflict = this.bundle.getString("conflict");
            this.bundleDescriptionSeperator = this.bundle.getString("seperatorDescription");
            this.bundleDueEvents = this.bundle.getString("dueEvents");
            this.bundleDueTasks = this.bundle.getString("dueTasks");
            this.bundleFetchError = this.bundle.getString("componentFetchError") + " ";
            this.bundleNoSummary = this.bundle.getString("CalendarProvider-noSummary");
            this.bundleOpenError = this.bundle.getString("calendarOpenError") + " ";
            this.bundleOtherTasks = this.bundle.getString("otherTasks");
            this.bundleOverdueTasks = this.bundle.getString("overdueTasks");
            this.bundleProcessingError = this.bundle.getString("componentProcessingError");
            this.bundleTaskCompleteStart = this.bundle.getString("taskCompleteStart");
            this.bundleTaskCompleteEnd = this.bundle.getString("taskCompleteEnd");
            SSOAdapter ssoAdapter = this.adapterFactory.getSSOAdapter(this.getBestStringProperty("ssoAdapter", this.pflist), request, this.getProviderContext().getLocale(), this.getProviderContext().getUserID(), this.getName());
        }
        catch (MissingResourceException mre) {
            this.debugError("Missing Resource ", mre);
            this.isPresentable = Boolean.FALSE;
        }
        catch (NullPointerException npe) {
            this.debugError("Unable to read property ", npe);
            this.isSSOConfigFound = false;
        }
        catch (SSOAdapterException ssoe) {
            this.isSSOConfigFound = false;
            this.debugWarning("Not presentable, ssoadapter not found. " + ssoe.getMessage());
        }
        if (!this.getProviderContext().isAuthless(request)) {
            this.isPresentable = this.isPresentable(request) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public boolean isPresentable(HttpServletRequest request) {
        boolean ip = false;
        try {
            this.getTemplate("display.template");
        }
        catch (ProviderException pe) {
            this.debugError("Not presentable 'display.template' not found.");
            return false;
        }
        if (this.isPresentable != null) {
            ip = this.isPresentable;
            return ip && this.isSSOConfigFound;
        }
        return this.isSSOConfigFound;
    }

    public StringBuffer getContent(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        StringBuffer content = new StringBuffer();
        StringBuffer escapedContent = new StringBuffer();
        Hashtable<String, CharSequence> contentTags = new Hashtable<String, CharSequence>();
        DateTime startToday = null;
        CalendarStore calStore = null;
        String tmpConf = null;
        int index = 0;
        SSOAdapter ssoAdapter = null;
        Properties configProps = null;
        try {
            ssoAdapter = this.adapterFactory.getSSOAdapter(this.getBestStringProperty("ssoAdapter", this.pflist), request, this.getProviderContext().getLocale(), this.getProviderContext().getUserID(), this.getName());
            calStore = (CalendarStore)ssoAdapter.getConnection();
            ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), contentTags);
        }
        catch (SSOAdapterException ssoe) {
            this.debugMessage("CalendarProvider.getContent():", ssoe);
            String ssoError = this.bundle.getString("ssoadapterError");
            contentTags.put("ErrorMessage", ssoError);
            String strContent = this.getTemplate("display.template", contentTags).toString();
            content.append(strContent);
            return content;
        }
        catch (Exception genexcp) {
            String errorMessage = this.bundle.getString("loginError");
            contentTags.put("ErrorMessage", errorMessage);
            String strContent = this.getTemplate("display.template", contentTags).toString();
            content.append(strContent);
            contentTags.clear();
            return content;
        }
        if (ssoAdapter != null && calStore != null) {
            String tz = this.getStringAttribute("preferredtimezone");
            if (tz == null || tz.length() == 0) {
                tz = TimeZone.getDefault().getID();
            }
            this.userTimeZone = TimeZone.getTimeZone(tz);
            calStore.getSession().setTimeZone(this.userTimeZone);
            configProps = ssoAdapter.getProperties();
            tmpConf = ssoAdapter.getName();
            contentTags.put("iwtDesktop-fontFace1", this.fontFace);
            this.userLocale = this.providerContext.getLocale();
            String applicationStartURL = "";
            CalendarApplicationHelper appHelper = null;
            String appHelperClass = this.getBestStringProperty("applicationHelperURL", this.pflist);
            if (appHelperClass != null && (applicationStartURL = (appHelper = this.getCalAppHelper(ssoAdapter, appHelperClass, true)) != null ? this.getApplicationStartURL(appHelper, request) : null) != null) {
                contentTags.put("calendar-display-client-uri", applicationStartURL);
            }
            if (appHelper == null) {
                this.debugError("appHelper is null");
            }
            contentTags.put("config-index", String.valueOf(index));
            try {
                startToday = new DateTime(this.userTimeZone);
            }
            catch (NullPointerException ne) {
                this.debugMessage("CalendarProvider.getContent(): userTimeZone NULL", ne);
                this.debugMessage("CalendarProvider.getContent(): Using default TimeZone");
                startToday = new DateTime();
            }
            startToday.setTime(0, 0, 0);
            CalendarComponent[] components = null;
            CalendarComponent[] wkComponents = null;
            VEvent[] events = null;
            VEvent[] wkEvents = null;
            VTodo[] tasks = null;
            VTodo[] wkTasks = null;
            VEvent currentEvent = null;
            VTodo currentTask = null;
            Vector<VEvent> evtToday = new Vector<VEvent>();
            Vector<VTodo> taskToday = new Vector<VTodo>();
            Vector<VEvent> evtWk = new Vector<VEvent>();
            Vector<VTodo> taskWk = new Vector<VTodo>();
            StringBuffer dayView = null;
            StringBuffer weekView = null;
            int todaysEvts = 0;
            int todaysTsks = 0;
            String view = this.getBestStringProperty("view", "dayWeekView", this.pflist);
            DateTime currentDT = (DateTime)startToday.clone();
            ICalendar calendar = null;
            String calendarToLoad = null;
            try {
                calendarToLoad = this.getBestStringProperty("calendar", "", this.pflist);
                calendar = calendarToLoad.length() > 0 ? calStore.openCalendar(calendarToLoad) : calStore.openCalendar();
            }
            catch (CalendarStoreException cesx) {
                this.debugError("CalendarProvider.getContent(): ", cesx);
                return this.getErrorContent(this.bundleOpenError + cesx.getMessage());
            }
            if (view.equals("dayWeekView")) {
                DateTime endDate = (DateTime)startToday.clone();
                endDate.add(5, 7);
                try {
                    wkComponents = calendar.fetchComponents(startToday, endDate, 3);
                }
                catch (CalendarException cx) {
                    this.debugError("CalendarProvider.getContent(): ", cx);
                    return this.getErrorContent(this.bundleFetchError + cx.getMessage());
                }
                try {
                    for (int i = 0; i < wkComponents.length; ++i) {
                        if (wkComponents[i] instanceof VEvent) {
                            currentEvent = (VEvent)wkComponents[i];
                            evtWk.add(currentEvent);
                            if (!this.matchDayMonthYear(currentEvent.getStartTime(), startToday)) continue;
                            evtToday.add(currentEvent);
                            ++todaysEvts;
                            continue;
                        }
                        if (!(wkComponents[i] instanceof VTodo)) continue;
                        currentTask = (VTodo)wkComponents[i];
                        if (this.isTodayTask(currentTask, currentDT)) {
                            taskToday.add(currentTask);
                            taskWk.add(currentTask);
                            ++todaysTsks;
                            continue;
                        }
                        if (this.isTaskOverDue(currentDT, currentTask)) {
                            taskToday.add(currentTask);
                            continue;
                        }
                        taskWk.add(currentTask);
                    }
                    events = evtToday.toArray(new VEvent[0]);
                    tasks = taskToday.toArray(new VTodo[0]);
                    dayView = this.getDayViewContent(startToday, tmpConf, request, events, tasks, calStore, appHelper, applicationStartURL);
                    contentTags.put("calendar-display-dayView", dayView);
                    wkEvents = evtWk.toArray(new VEvent[0]);
                    wkTasks = taskWk.toArray(new VTodo[0]);
                    weekView = this.getWeekViewContent(startToday, currentDT, tmpConf, request, wkEvents, wkTasks, calStore, appHelper, applicationStartURL, "calendar-display-weekView", "display-weekView", null, false);
                    contentTags.put("calendar-display-weekView", weekView);
                }
                catch (Exception csx) {
                    this.debugError("CalendarProvider.getContent(): ", csx);
                    return this.getErrorContent(this.bundleProcessingError);
                }
            }
            if (view.equals("dayView")) {
                try {
                    components = calendar.fetchComponents(3);
                }
                catch (CalendarException cx1) {
                    this.debugError("CalendarProvider.getContent(): ", cx1);
                    return this.getErrorContent(this.bundleFetchError + cx1.getMessage());
                }
                try {
                    for (int j = 0; j < components.length; ++j) {
                        if (components[j] instanceof VEvent) {
                            currentEvent = (VEvent)components[j];
                            if (!this.matchDayMonthYear(currentEvent.getStartTime(), startToday)) continue;
                            evtToday.add(currentEvent);
                            ++todaysEvts;
                            continue;
                        }
                        if (!(components[j] instanceof VTodo)) continue;
                        currentTask = (VTodo)components[j];
                        if (this.isTodayTask(currentTask, currentDT)) {
                            taskToday.add(currentTask);
                            ++todaysTsks;
                            continue;
                        }
                        if (!this.isTaskOverDue(currentDT, currentTask)) continue;
                        taskToday.add(currentTask);
                    }
                    events = evtToday.toArray(new VEvent[0]);
                    tasks = taskToday.toArray(new VTodo[0]);
                    dayView = this.getDayViewContent(startToday, tmpConf, request, events, tasks, calStore, appHelper, applicationStartURL);
                    contentTags.put("calendar-display-dayView", dayView);
                }
                catch (Exception csx) {
                    this.debugError("CalendarProvider.getContent(): ", csx);
                    return this.getErrorContent(this.bundleProcessingError);
                }
            }
            if (view.equals("weekView")) {
                DateTime endDate = (DateTime)startToday.clone();
                endDate.add(5, 7);
                try {
                    wkComponents = calendar.fetchComponents(startToday, endDate, 3);
                }
                catch (CalendarException cx) {
                    this.debugError("CalendarProvider.getContent(): ", cx);
                    return this.getErrorContent(this.bundleFetchError + cx.getMessage());
                }
                try {
                    for (int i = 0; i < wkComponents.length; ++i) {
                        if (wkComponents[i] instanceof VEvent) {
                            currentEvent = (VEvent)wkComponents[i];
                            if (this.matchDayMonthYear(currentEvent.getStartTime(), startToday)) {
                                ++todaysEvts;
                            }
                            evtWk.add(currentEvent);
                            continue;
                        }
                        if (!(wkComponents[i] instanceof VTodo)) continue;
                        currentTask = (VTodo)wkComponents[i];
                        if (this.isTodayTask(currentTask, currentDT)) {
                            ++todaysTsks;
                            taskWk.add(currentTask);
                            continue;
                        }
                        if (this.isTaskOverDue(currentDT, currentTask)) continue;
                        taskWk.add(currentTask);
                    }
                    wkEvents = evtWk.toArray(new VEvent[0]);
                    wkTasks = taskWk.toArray(new VTodo[0]);
                    weekView = this.getWeekViewContent(startToday, currentDT, tmpConf, request, wkEvents, wkTasks, calStore, appHelper, applicationStartURL, "calendar-display-weekView", "display-weekView", null, true);
                    contentTags.put("calendar-display-dayView", " ");
                    contentTags.put("calendar-display-weekView", weekView);
                }
                catch (Exception csx) {
                    this.debugError("CalendarProvider.getContent(): ", csx);
                    return this.getErrorContent(this.bundleProcessingError);
                }
            }
            if (view.equals("monthView")) {
                StringBuffer monthView = new StringBuffer();
                DateTime monthStart = this.getMonthStart(startToday);
                DateTime monthEnd = this.getMonthEnd(startToday);
                CalendarComponent[] monthComponents = null;
                VEvent[] monthEvents = null;
                VTodo[] monthTasks = null;
                currentEvent = null;
                Vector<VEvent> eventMonth = new Vector<VEvent>();
                Vector<VTodo> taskMonth = new Vector<VTodo>();
                Hashtable<String, CharSequence> monthTags = new Hashtable<String, CharSequence>();
                String tagPrefix = "calendar-display-monthView";
                try {
                    monthComponents = calendar.fetchComponents(monthStart, monthEnd, 3);
                }
                catch (CalendarException cx) {
                    this.debugError("CalendarProvider.getContent(): ", cx);
                    return this.getErrorContent(this.bundleFetchError + cx.getMessage());
                }
                DateTime iteratorDate = (DateTime)monthStart.clone();
                DateTime iteratorDate2 = (DateTime)monthStart.clone();
                iteratorDate2.add(5, -1);
                this.populateHeaderTags(monthTags, tagPrefix, startToday);
                this.populateDayOfWeekTags(monthTags, tagPrefix, iteratorDate2);
                monthTags.put("iwtDesktop-fontFace1", this.fontFace);
                try {
                    for (int i = 0; i < monthComponents.length; ++i) {
                        if (monthComponents[i] instanceof VEvent) {
                            currentEvent = (VEvent)monthComponents[i];
                            if (this.matchDayMonthYear(currentEvent.getStartTime(), startToday)) {
                                ++todaysEvts;
                            }
                            eventMonth.add(currentEvent);
                            continue;
                        }
                        if (!(monthComponents[i] instanceof VTodo)) continue;
                        currentTask = (VTodo)monthComponents[i];
                        if (this.isTodayTask(currentTask, currentDT)) {
                            ++todaysTsks;
                            taskMonth.add(currentTask);
                            continue;
                        }
                        if (this.isTaskOverDue(currentDT, currentTask)) continue;
                        taskMonth.add(currentTask);
                    }
                    monthEvents = eventMonth.toArray(new VEvent[0]);
                    monthTasks = taskMonth.toArray(new VTodo[0]);
                    monthView = this.getTemplate("display-monthView-dayOfWeek.template", monthTags);
                    monthTags.put(tagPrefix + "-dayOfWeek", monthView);
                    for (int k = 0; k < 5; ++k) {
                        monthView = this.getWeekViewContent(iteratorDate, currentDT, tmpConf, request, monthEvents, monthTasks, calStore, appHelper, applicationStartURL, "calendar-display-monthView", "display-monthView", "display-monthView-weekView.template", false);
                        monthTags.put("calendar-display-monthView-weekView" + k, monthView);
                        iteratorDate.add(5, 7);
                    }
                    monthView = this.getTemplate("display-monthView.template", monthTags);
                    contentTags.put("calendar-display-monthView", monthView);
                }
                catch (Exception csx) {
                    this.debugError("CalendarProvider.getContent(): ", csx);
                    return this.getErrorContent(this.bundleProcessingError);
                }
            }
            try {
                components = calendar.fetchComponents(3);
            }
            catch (CalendarException cxn) {
                this.debugError("CalendarProvider.getContent(): ", cxn);
                return this.getErrorContent(this.bundleFetchError + cxn.getMessage());
            }
            try {
                for (int k = 0; k < components.length; ++k) {
                    if (components[k] instanceof VEvent) {
                        if (!this.matchDayMonthYear(((VEvent)components[k]).getStartTime(), startToday)) continue;
                        ++todaysEvts;
                        continue;
                    }
                    if (!(components[k] instanceof VTodo) || !this.isTodayTask(currentTask = (VTodo)components[k], currentDT)) continue;
                    ++todaysTsks;
                }
                contentTags.put("calendar-display-dayView", " ");
                contentTags.put("calendar-display-weekView", " ");
            }
            catch (Exception csx) {
                this.debugError("CalendarProvider.getContent(): ", csx);
                throw new ProviderException(csx.getMessage());
            }
            StringBuffer summ = this.getSummaryContent(todaysEvts, todaysTsks);
            contentTags.put("calendar-display-dayView-summary", summ);
            try {
                contentTags.put("CalUserId", configProps.getProperty("uid", ""));
                this.debugMessage("CalendarProvider.getContent(): UID =" + configProps.getProperty("uid"));
                contentTags.put("CalPassword", configProps.getProperty("password", ""));
                contentTags.put("calendar-display-client-calStore", (CharSequence)calStore);
                if (applicationStartURL != null && !applicationStartURL.equals("")) {
                    contentTags.put("calendar-display-clientURL", this.getTemplate("display-clientURL.template"));
                }
                String strContent = this.getTemplate("display.template", contentTags).toString();
                content.append(strContent);
                contentTags.clear();
            }
            catch (Exception nex) {
                this.debugError("CalendarProvider.getContent(): ", nex);
            }
            ++index;
            String eprc = configProps.getProperty("enablePerRequestConnection", "false");
            if (eprc != null && eprc.equals("true")) {
                ssoAdapter.closeConnection();
            }
        } else {
            if (ssoAdapter != null && ssoAdapter.getName().endsWith("_" + this.getName())) {
                return this.getErrorContent(this.bundle.getString("loginError"));
            }
            return this.getErrorContent(this.bundle.getString("noConfigError"));
        }
        return content;
    }

    protected URL getURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException mu) {
            return null;
        }
    }

    public StringBuffer getEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        StringBuffer content = new StringBuffer();
        SSOAdapter ssoAdapter = null;
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        this.editContainer = request.getParameter("provider");
        this.targetProvider = request.getParameter("targetprovider");
        this.containerName = request.getParameter("containerName");
        this.getProviderContext().debugMessage((Object)("Calendar.getEdit():     editContainer=" + this.editContainer + "\n                        targetProvider=" + this.targetProvider + "\n                        containerName=" + this.containerName));
        try {
            ssoAdapter = this.adapterFactory.getSSOAdapter(this.getBestStringProperty("ssoAdapter", this.pflist), request, this.getProviderContext().getLocale(), this.getProviderContext().getUserID(), this.getName());
            ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), tagTable);
        }
        catch (Exception e) {
            this.debugMessage("getEdit(): ssoAdapter not found.", e);
        }
        String appPref = ProviderEditUtility.getRequestParameter((String)"appPref", (HttpServletRequest)request);
        if (!appPref.equals("")) {
            if (this.existsBooleanProperty("loadSubscribedCalendars") && this.getBestBooleanProperty("loadSubscribedCalendars", false, this.pflist)) {
                this.setCalendarSelectOptions(ssoAdapter);
            }
            CalendarApplicationHelper cah = this.getCalAppHelper(ssoAdapter, appPref, false);
            content = cah.getAppPrefsEdit(this, request, response);
        } else {
            tagTable.put("iwtDesktop-fontFace1", this.fontFace);
            content.append(this.getTemplate("edit-start.template", tagTable));
            try {
                content.append(ProviderEditUtility.getSSOAdapterPrefs((ProviderAdapter)this, (SSOAdapter)ssoAdapter));
            }
            catch (Exception e) {
                this.debugWarning("CalendarProvider.processEdit(): Failed to get ssoAdapter attributes. ", e);
            }
            content.append(this.getTemplate("edit-end.template", tagTable));
            CalendarApplicationHelper cah = null;
            Map appHelperClasses = this.getAppHandlerMap();
            if (appHelperClasses == null) {
                this.debugError("Application Helper map is null");
            } else {
                Iterator iter = appHelperClasses.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry appClass = iter.next();
                    String appHelperClass = (String)appClass.getValue();
                    cah = this.getCalAppHelper(ssoAdapter, appHelperClass, true);
                    String link = "";
                    if (cah == null) {
                        this.debugError("CalendarApplicationHelper is null");
                    } else {
                        link = cah.getAppHelperEditLink(request, this.getProviderContext());
                    }
                    if (link != null || !link.equals("")) {
                        content.append(link);
                        continue;
                    }
                    this.debugWarning("CalendarApplicationHelper.getAppHelperEditLink():  returned a null or empty string");
                }
            }
        }
        return content;
    }

    protected Map getAppHandlerMap() {
        Map appHelperClasses = null;
        appHelperClasses = this.getBestCollectionProperty("applicationHelperEdit", this.pflist);
        return appHelperClasses;
    }

    private CalendarApplicationHelper getCalAppHelper(SSOAdapter ssoAdapter, String applicationHelperName, boolean safe) {
        CalendarApplicationHelper abApplicationHelper = null;
        if (ssoAdapter == null) {
            this.debugError("ssoAdapter is null");
            return null;
        }
        if (applicationHelperName == null) {
            this.debugError("applicationHelperName is null");
            return null;
        }
        boolean validClass = safe;
        if (!safe) {
            Map validAppHelpers = this.getAppHandlerMap();
            if (validAppHelpers != null) {
                validClass = validAppHelpers.containsKey(applicationHelperName);
                this.debugMessage("validClass ==" + validClass);
            } else {
                validClass = false;
            }
        }
        if (ProviderEditUtility.isAppHandlerSet((HashMap)this.appHandlers, (String)applicationHelperName)) {
            this.debugMessage("App Handler " + applicationHelperName + " is being retrieved.");
            abApplicationHelper = (CalendarApplicationHelper)this.appHandlers.get(applicationHelperName);
            return abApplicationHelper;
        }
        if (validClass) {
            try {
                Class<?> applicationHelperClass = Class.forName(applicationHelperName);
                Class[] argConst = new Class[]{};
                Constructor<?> applicationHelperConst = applicationHelperClass.getConstructor(argConst);
                Object[] argConstObj = new Object[]{};
                abApplicationHelper = (CalendarApplicationHelper)applicationHelperConst.newInstance(argConstObj);
            }
            catch (ClassNotFoundException cnfe) {
                this.debugError("CalendarProvider.getCalendarAppHelper(): ", cnfe);
            }
            catch (NoSuchMethodException nsme) {
                this.debugError("CalendarProvider.getCalendarAppHelper(): ", nsme);
            }
            catch (InstantiationException ine) {
                this.debugError("CalendarProvider.getCalendarAppHelper(): ", ine);
            }
            catch (IllegalAccessException iae) {
                this.debugError("CalendarProvider.getCalendarAppHelper(): ", iae);
            }
            catch (InvocationTargetException ite) {
                this.debugError("CalendarProvider.getCalendarAppHelper(): ", ite);
            }
            try {
                abApplicationHelper.init(this, ssoAdapter);
            }
            catch (Exception e) {
                this.getProviderContext().debugWarning((Object)("CalendarProvider:getABAppHelper(): Unable to call init() for " + applicationHelperName), (Throwable)e);
                return null;
            }
            if (abApplicationHelper != null) {
                this.debugMessage("CalendarProvider.getCalendarAppHelper:  Saving app helper" + applicationHelperName + "to the internal map");
                this.appHandlers.put(applicationHelperName, abApplicationHelper);
                abApplicationHelper.setName(applicationHelperName);
                return abApplicationHelper;
            }
            return null;
        }
        return null;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        SSOAdapter ssoAdapter = null;
        URL returnURL = null;
        this.editContainer = req.getParameter("provider");
        this.targetProvider = req.getParameter("targetprovider");
        this.containerName = req.getParameter("containerName");
        try {
            ssoAdapter = this.adapterFactory.getSSOAdapter(this.getBestStringProperty("ssoAdapter", this.pflist), req, this.getProviderContext().getLocale(), this.getProviderContext().getUserID(), this.getName());
        }
        catch (SSOAdapterException ssoe) {
            this.debugMessage("CalendarProvider.processEdit(): ssoAdapter not found. ", ssoe);
        }
        String appPref = ProviderEditUtility.getRequestParameter((String)"appPref", (HttpServletRequest)req);
        this.getProviderContext().debugMessage((Object)("Calendar.processEdit(): editContainer=" + this.editContainer + "\n                        targetProvider=" + this.targetProvider + "\n                        containerName=" + this.containerName + "\n                        appPref=" + appPref));
        CalendarApplicationHelper cah = null;
        if (!appPref.equals("")) {
            cah = this.getCalAppHelper(ssoAdapter, appPref, false);
            if (cah == null) {
                this.debugWarning("CalendarApplicationHandler is null");
                returnURL = null;
            } else {
                returnURL = cah.processAppPrefsEdit(this, req, res);
                this.debugMessage("returnURL = " + returnURL);
            }
        } else {
            ProviderEditUtility.editContainer = this.editContainer;
            ProviderEditUtility.container = this.containerName;
            SSOAdapter newAdapter = null;
            try {
                newAdapter = ProviderEditUtility.setSSOAdapterPrefs((ProviderAdapter)this, (SSOAdapter)ssoAdapter, (SSOAdapterFactory)this.adapterFactory, (HttpServletRequest)req);
                returnURL = ProviderEditUtility.getErrorURL();
                if (returnURL == null && newAdapter != null) {
                    this.debugMessage("CalendarProvider.processEdit():  Resetting the app helpers ssoAdapter");
                    appPref = this.getBestStringProperty("applicationHelperURL", this.pflist);
                    cah = this.getCalAppHelper(ssoAdapter, appPref, false);
                    cah.init(this, newAdapter);
                }
            }
            catch (Exception e) {
                this.debugError("Unable to save the users ssoAdapter preferences");
            }
        }
        return returnURL;
    }

    protected StringBuffer getErrorContent(String msg) throws ProviderException {
        Hashtable<String, String> errorTags = new Hashtable<String, String>();
        errorTags.put("calendar-display-error", msg);
        return this.getTemplate("display-error.template", errorTags);
    }

    private boolean isTaskComplete(VTodo task) {
        try {
            return task.isCompleted();
        }
        catch (OperationNotSupportedException onse) {
            this.debugWarning("CalendarProvider.isTaskComplete()): ", onse);
        }
        catch (CalendarComponentException cce) {
            this.debugWarning("CalendarProvider.isTaskComplete()): ", cce);
        }
        return false;
    }

    private boolean isTaskOverDue(DateTime dt, VTodo tsk) throws OperationNotSupportedException {
        boolean taskOverdue = false;
        try {
            DateTime taskDT = tsk.getDueTime();
            if (taskDT == null) {
                return taskOverdue;
            }
            if (tsk.isAllDay()) {
                if (!(this.matchDayMonthYear(dt, taskDT) || this.isTaskComplete(tsk) || taskDT.after((Object)dt))) {
                    taskOverdue = true;
                }
            } else if (taskDT.before((Object)dt) && !this.isTaskComplete(tsk)) {
                taskOverdue = true;
            }
        }
        catch (Exception e) {
            this.debugMessage("CalendarProvider.isTaskOverDue(): ", e);
        }
        return taskOverdue;
    }

    protected StringBuffer getDayViewContent(DateTime today, String cnfgName, HttpServletRequest rqst, VEvent[] events, VTodo[] tasks, CalendarStore calStore, CalendarApplicationHelper appHelper, String clientURL) throws ProviderException, Exception {
        boolean overdue = false;
        int odTasks = 0;
        Hashtable<String, CharSequence> dayViewTags = new Hashtable<String, CharSequence>();
        StringBuffer dayViewEventList = new StringBuffer();
        StringBuffer dayViewTaskList = new StringBuffer();
        StringBuffer overdueTaskList = new StringBuffer();
        StringBuffer otherTaskList = new StringBuffer();
        this.populateDayTags(dayViewTags, "calendar-display-dayView", today);
        dayViewTags.put("iwtDesktop-fontFace1", this.fontFace);
        if (clientURL != null) {
            dayViewTags.put("calendar-display-client-url", clientURL);
        }
        if (tasks.length == 0) {
            this.debugMessage("CalendarProvider.getDayViewContent():tasks = 0");
            try {
                dayViewTaskList = this.getTemplate("display-dayView-emptyTaskList.template");
            }
            catch (NullPointerException np) {
                this.debugWarning("CalendarProvider.getDayViewContent()No tasks exist!", np);
            }
        } else {
            StringBuffer dayViewTask = null;
            StringBuffer dayViewOverdueTask = null;
            Hashtable<String, String> dayViewTaskTags = new Hashtable<String, String>();
            Hashtable<String, String> dayViewODHash = new Hashtable<String, String>();
            DateFormatSymbols dfSymbols = new DateFormatSymbols(this.userLocale);
            DateTime taskDT = null;
            DateTime currDT = null;
            if (clientURL == null || clientURL.equals("")) {
                this.debugWarning("clientURL is null.  Not displaying client link");
            } else {
                dayViewTaskTags.put("calendar-display-client-url", clientURL);
                dayViewODHash.put("calendar-display-client-url", clientURL);
            }
            dayViewTaskTags.put("iwtDesktop-fontFace1", this.fontFace);
            dayViewODHash.put("iwtDesktop-fontFace1", this.fontFace);
            for (int cnt = 0; cnt < tasks.length; ++cnt) {
                block40: {
                    currDT = this.userTimeZone != null ? new DateTime(this.userTimeZone) : new DateTime();
                    taskDT = tasks[cnt].getDueTime();
                    try {
                        overdue = this.isTaskOverDue(currDT, tasks[cnt]);
                    }
                    catch (OperationNotSupportedException oex) {
                        if (!taskDT.before((Object)currDT)) break block40;
                        overdue = true;
                    }
                }
                if (!this.isTaskComplete(tasks[cnt])) {
                    if (tasks[cnt].getDueTime() != null) {
                        this.debugMessage("CalendarProvider.getDayViewContent(): Due at = " + tasks[cnt].getDueTime().get(10));
                    } else {
                        this.debugMessage("CalendarProvider.getDayViewContent(): No Due Time ");
                    }
                    this.debugMessage("CalendarProvider.getDayViewContent(): Status = " + tasks[cnt].getStatus());
                    if (overdue) {
                        this.tagTime(tasks[cnt].getDueTime(), dayViewODHash, "calendar-display-dayView-task-due", cnfgName, calStore, rqst);
                        dayViewODHash.put("calendar-display-dayView-task-dueMonth", dfSymbols.getMonths()[taskDT.getMonth()]);
                        dayViewODHash.put("calendar-display-dayView-task-dueDay", Integer.toString(taskDT.getDay()));
                        dayViewODHash.put("calendar-display-dayView-task-dueYear", Integer.toString(taskDT.getYear()));
                    } else {
                        this.tagTime(taskDT, dayViewTaskTags, "calendar-display-dayView-task-pend", cnfgName, calStore, rqst);
                    }
                } else {
                    this.debugMessage("CalendarProvider.getDayViewContent()****COMPLETED****" + tasks[cnt].getDescription());
                    this.tagTime(taskDT, dayViewTaskTags, "calendar-display-dayView-task-pend", cnfgName, calStore, rqst);
                    dayViewTaskTags.put("calendar-display-dayView-task-complete-start", this.bundleTaskCompleteStart);
                    dayViewTaskTags.put("calendar-display-dayView-task-complete-end", this.bundleTaskCompleteEnd);
                }
                if (overdue) {
                    try {
                        tasks[cnt].getStatus();
                    }
                    catch (OperationNotSupportedException oe) {
                        this.debugWarning("CalendarProvider.getDayViewContent(): ", oe);
                        tasks[cnt].setStatus("IN-PROCESS");
                    }
                    if (this.isTaskComplete(tasks[cnt])) continue;
                    this.tagTaskSummary(tasks[cnt], dayViewODHash, "calendar-display-dayView-overdueTask", rqst, appHelper);
                    this.tagDescription(this.escapeContent(tasks[cnt].getDescription()), dayViewODHash, "calendar-display-dayView-overdueTask");
                    dayViewOverdueTask = this.getTemplate("display-dayView-overdueTasks.template", dayViewODHash);
                    overdueTaskList.append(dayViewOverdueTask);
                    ++odTasks;
                    continue;
                }
                this.tagTaskSummary(tasks[cnt], dayViewTaskTags, "calendar-display-dayView-task", rqst, appHelper);
                this.tagDescription(this.escapeContent(tasks[cnt].getDescription()), dayViewTaskTags, "calendar-display-dayView-task");
                if (tasks[cnt].getDueTime() == null) {
                    dayViewTask = this.getTemplate("display-dayView-otherTasks.template", dayViewTaskTags);
                    otherTaskList.append(dayViewTask);
                } else {
                    dayViewTask = this.getTemplate("display-dayView-task.template", dayViewTaskTags);
                    dayViewTaskList.append(dayViewTask);
                }
                dayViewTaskTags.clear();
                if (clientURL == null || clientURL.equals("")) {
                    this.debugWarning("clientURL is null.  Not displaying client link");
                } else {
                    dayViewTaskTags.put("calendar-display-client-url", clientURL);
                }
                dayViewTaskTags.put("iwtDesktop-fontFace1", this.fontFace);
            }
        }
        if (events.length == 0) {
            try {
                dayViewEventList = this.getTemplate("display-dayView-emptyEventList.template");
            }
            catch (NullPointerException np) {
                this.debugWarning("CalendarProvider.getDayViewContent()No events!!", np);
            }
        } else {
            events = this.getTransformedEventList(events);
            for (int i = 0; i < events.length; ++i) {
                Hashtable<String, String> dayViewEventTags = new Hashtable<String, String>();
                StringBuffer dayViewEvent = new StringBuffer();
                String dayViewtemplateName = null;
                if (clientURL == null || clientURL.equals("")) {
                    this.debugWarning("clientURL is null.  Not displaying client link");
                } else {
                    dayViewEventTags.put("calendar-display-client-url", clientURL);
                }
                dayViewEventTags.put("iwtDesktop-fontFace1", this.fontFace);
                if (events[i].isAllDay()) {
                    dayViewtemplateName = "display-dayView-eventAllDay.template";
                    dayViewEventTags.put("calendar-display-dayView-event-allDay", this.bundleAllDayEvent);
                } else {
                    dayViewtemplateName = "display-dayView-event.template";
                    this.tagTime(events[i].getStart(), dayViewEventTags, "calendar-display-dayView-event-start", cnfgName, calStore, rqst);
                    this.tagTime(events[i].getEnd(), dayViewEventTags, "calendar-display-dayView-event-end", cnfgName, calStore, rqst);
                }
                boolean conflicted = new Boolean((String)events[i].getProperty("isConflict"));
                if (conflicted) {
                    dayViewEventTags.put("calendar-display-event-conflict", this.bundleConflict);
                }
                if (events[i].getLocation() == null || events[i].getLocation().equals("")) {
                    dayViewEventTags.put("calendar-display-dayView-at", this.bundleAtNoLocation);
                } else {
                    dayViewEventTags.put("calendar-display-dayView-at", this.bundleAtLocation);
                }
                this.tagLocation(this.escapeContent(events[i].getLocation()), dayViewEventTags, "calendar-display-dayView-event");
                this.tagEventSummary(events[i], dayViewEventTags, "calendar-display-dayView-event", rqst, appHelper);
                this.tagDescription(this.escapeContent(events[i].getDescription()), dayViewEventTags, "calendar-display-dayView-event");
                dayViewEvent = this.getTemplate(dayViewtemplateName, dayViewEventTags);
                dayViewEventList.append(dayViewEvent);
                dayViewEventTags.clear();
            }
        }
        if (odTasks > 0) {
            dayViewTags.put("display-dayView-overdueTask-Header", this.bundleOverdueTasks);
            dayViewTags.put("calendar-display-dayView-overdueTaskNum", Integer.toString(odTasks));
            dayViewTags.put("calendar-display-dayView-overdueTaskList", overdueTaskList);
        }
        if (tasks.length > 0) {
            for (int ts = 0; ts < tasks.length; ++ts) {
                if (this.isTaskOverDue(new DateTime(), tasks[ts]) || tasks[ts].getDueTime() == null) continue;
                dayViewTags.put("display-dayView-dueTask-Header", this.bundleDueTasks);
                break;
            }
        }
        dayViewTags.put("calendar-display-dayView-taskList", dayViewTaskList);
        if (otherTaskList.length() > 0) {
            dayViewTags.put("display-dayView-otherTask-Header", this.bundleOtherTasks);
            dayViewTags.put("calendar-display-dayView-otherTaskList", otherTaskList);
        }
        if (events.length > 0) {
            dayViewTags.put("display-dayView-dueEvent-Header", this.bundleDueEvents);
        }
        dayViewTags.put("calendar-display-dayView-eventList", dayViewEventList);
        return this.getTemplate("display-dayView.template", dayViewTags);
    }

    protected StringBuffer getWeekViewContent(DateTime beginDate, DateTime todaysDate, String cfgName, HttpServletRequest request, VEvent[] events, VTodo[] tasks, CalendarStore calStore, CalendarApplicationHelper appHelper, String clientURL, String tagPrefix, String templatePrefix, String endTemplate, boolean addCurrentDayHeader) throws ProviderException, Exception {
        String weekViewTemplateName = null;
        StringBuffer weekView = new StringBuffer();
        Hashtable<String, CharSequence> weekViewTags = new Hashtable<String, CharSequence>();
        DateFormatSymbols symbols = new DateFormatSymbols(this.userLocale);
        int todaysTasks = 0;
        int todaysEvents = 0;
        events = this.getTransformedEventList(events);
        if (addCurrentDayHeader) {
            StringBuffer currentDayHeader = null;
            this.populateHeaderTags(weekViewTags, tagPrefix, todaysDate);
            try {
                currentDayHeader = this.getTemplate(templatePrefix + "-currentDayHeader.template", weekViewTags);
            }
            catch (ProviderException pe) {
                currentDayHeader = null;
            }
            if (currentDayHeader != null) {
                weekViewTags.put(tagPrefix + "-currentDayHeader", currentDayHeader);
            }
        }
        weekViewTags.put("iwtDesktop-fontFace1", this.fontFace);
        if (clientURL == null || clientURL.equals("")) {
            this.debugWarning("clientURL is null.  Not displaying client link");
        } else {
            weekViewTags.put("calendar-display-client-url", clientURL);
        }
        for (int i = 0; i < 7; ++i) {
            DateTime date = (DateTime)beginDate.clone();
            date.add(5, i);
            weekViewTags.put(tagPrefix + "-dayOfWeek" + i, symbols.getShortWeekdays()[date.get(7)]);
            weekViewTags.put(tagPrefix + "-day" + i, Integer.toString(date.getDay()));
            StringBuffer weekViewTaskList = new StringBuffer();
            int nm = 0;
            for (nm = 0; nm < tasks.length; ++nm) {
                if (tasks[nm].getDueTime() == null || !this.matchDayMonthYear(tasks[nm].getDueTime(), date)) continue;
                ++todaysTasks;
            }
            if (todaysTasks == 0) {
                try {
                    weekViewTaskList = this.getTemplate(templatePrefix + "-emptyTaskList.template");
                }
                catch (NullPointerException np) {
                    this.debugError("CalendarProvider.getWeekViewContent(): No tasks Found for the Week", np);
                }
            } else {
                for (int tsk = 0; tsk < tasks.length; ++tsk) {
                    StringBuffer weekViewTask = new StringBuffer();
                    Hashtable<String, String> weekViewTaskTags = new Hashtable<String, String>();
                    weekViewTemplateName = templatePrefix + "-task.template";
                    weekViewTaskTags.put("iwtDesktop-fontFace1", this.fontFace);
                    if (clientURL == null || clientURL.equals("")) {
                        this.debugWarning("clientURL is null.  Not displaying client link");
                    } else {
                        weekViewTaskTags.put("calendar-display-client-url", clientURL);
                    }
                    DateTime tskDT = tasks[tsk].getDueTime();
                    if (tskDT == null || !this.matchDayMonthYear(tskDT, date)) continue;
                    this.tagTime(tskDT, weekViewTaskTags, tagPrefix + "-task-pend", cfgName, calStore, request);
                    if (this.isTaskComplete(tasks[tsk])) {
                        weekViewTaskTags.put(tagPrefix + "-task-complete-start", this.bundleTaskCompleteStart);
                        weekViewTaskTags.put(tagPrefix + "-task-complete-end", this.bundleTaskCompleteEnd);
                    }
                    this.tagTaskSummary(tasks[tsk], weekViewTaskTags, tagPrefix + "-task", request, appHelper);
                    weekViewTask = this.getTemplate(weekViewTemplateName, weekViewTaskTags);
                    weekViewTaskList.append(weekViewTask);
                    weekViewTaskTags.clear();
                }
            }
            StringBuffer weekViewEventList = new StringBuffer();
            for (int num = 0; num < events.length; ++num) {
                if (events[num].getStart() == null || !this.matchDayMonthYear(events[num].getStart(), date)) continue;
                ++todaysEvents;
            }
            if (todaysEvents == 0) {
                weekViewEventList = this.getTemplate(templatePrefix + "-emptyEventList.template");
            } else {
                for (int j = 0; j < events.length; ++j) {
                    StringBuffer weekViewEvent = new StringBuffer();
                    Hashtable<String, String> weekViewEventTags = new Hashtable<String, String>();
                    if (clientURL == null || clientURL.equals("")) {
                        this.debugWarning("clientURL is null.  Not displaying client link");
                    } else {
                        weekViewEventTags.put("calendar-display-client-url", clientURL);
                    }
                    weekViewEventTags.put("iwtDesktop-fontFace1", this.fontFace);
                    if (events[j].isAllDay() && this.matchDayMonthYear(events[j].getStart(), date)) {
                        weekViewTemplateName = templatePrefix + "-eventAllDay.template";
                        weekViewEventTags.put(tagPrefix + "-event-allDay", this.bundleAllDayEvent);
                        this.tagEventSummary(events[j], weekViewEventTags, tagPrefix + "-event", request, appHelper);
                        weekViewEvent = this.getTemplate(weekViewTemplateName, weekViewEventTags);
                        weekViewEventList.append(weekViewEvent);
                    } else if (!events[j].isAllDay() && this.matchDayMonthYear(events[j].getStart(), date)) {
                        boolean conflicted = new Boolean((String)events[j].getProperty("isConflict"));
                        if (conflicted) {
                            weekViewEventTags.put("calendar-display-event-conflict", this.bundleConflict);
                        }
                        weekViewTemplateName = templatePrefix + "-event.template";
                        this.tagTime(events[j].getStart(), weekViewEventTags, tagPrefix + "-event-start", cfgName, calStore, request);
                        this.tagTime(events[j].getEnd(), weekViewEventTags, tagPrefix + "-event-end", cfgName, calStore, request);
                        this.tagEventSummary(events[j], weekViewEventTags, tagPrefix + "-event", request, appHelper);
                        weekViewEvent = this.getTemplate(weekViewTemplateName, weekViewEventTags);
                        weekViewEventList.append(weekViewEvent);
                    }
                    weekViewEventTags.clear();
                }
            }
            weekViewTags.put(tagPrefix + "-eventList" + i, weekViewEventList);
            weekViewTags.put(tagPrefix + "-taskList" + i, weekViewTaskList);
        }
        weekView = endTemplate != null ? this.getTemplate(endTemplate, weekViewTags) : this.getTemplate(templatePrefix + ".template", weekViewTags);
        return weekView;
    }

    private StringBuffer getSummaryContent(int eventCount, int taskCount) throws ProviderException {
        StringBuffer summary = null;
        Hashtable<String, String> summaryTags = new Hashtable<String, String>();
        summaryTags.put("iwtDesktop-fontFace1", this.fontFace);
        summaryTags.put("calendar-display-summary-events", Integer.toString(eventCount));
        summaryTags.put("calendar-display-summary-tasks", Integer.toString(taskCount));
        summary = this.getTemplate("display-summary.template", summaryTags);
        return summary;
    }

    private void tagTime(DateTime time, Hashtable tags, String prefix, String config, CalendarStore calStore, HttpServletRequest request) {
        DateFormatSymbols symbols = new DateFormatSymbols(this.userLocale);
        int usrTimeFmt = 12;
        String usrTimeFmtStr = null;
        Object usrTimeFmtStr1 = null;
        CalendarSession session = null;
        try {
            session = calStore.getSession();
        }
        catch (Exception e) {
            this.debugError("CalendarProvider.tagTime(): getSession ", e);
        }
        if (time == null) {
            tags.put(prefix + "Hour", "");
            tags.put(prefix + "Minute", "");
            tags.put(prefix + "AmPm", "");
        } else {
            int hour = time.get(10);
            int hourOfDay = time.get(11);
            tags.put(prefix + "Hour0", Integer.toString(hour));
            tags.put(prefix + "HourOfDay0", Integer.toString(hourOfDay));
            tags.put(prefix + "Hour1", Integer.toString(hour == 0 ? 12 : hour));
            tags.put(prefix + "HourOfDay1", Integer.toString(hourOfDay == 0 ? 24 : hourOfDay));
            usrTimeFmtStr = session.getProperty("ceClock");
            if (usrTimeFmtStr == null) {
                usrTimeFmtStr = session.getProperty("cal.clock");
            }
            if (usrTimeFmtStr != null) {
                usrTimeFmtStr = usrTimeFmtStr.trim();
            }
            if (usrTimeFmtStr == null) {
                usrTimeFmtStr = "12";
            }
            usrTimeFmt = Integer.parseInt(usrTimeFmtStr);
            this.debugMessage("CalendarProvider.tagTime(): TIME FORMAT: " + Integer.toString(usrTimeFmt));
            try {
                if (usrTimeFmt == 12) {
                    this.debugMessage("Value of Hour2 (12)is : " + Integer.toString(hour));
                    tags.put(prefix + "Hour2", Integer.toString(hour == 0 ? 12 : hour));
                    tags.put(prefix + "AmPm", symbols.getAmPmStrings()[time.get(9)].toLowerCase());
                } else if (usrTimeFmt == 24) {
                    this.debugMessage("Value of Hour2 is: " + Integer.toString(hourOfDay));
                    tags.put(prefix + "Hour2", Integer.toString(hourOfDay));
                    tags.put(prefix + "AmPm", " Hrs");
                }
            }
            catch (Exception xn) {
                this.debugError("CalendarProvider.tagTime() :", xn);
            }
            int timeMinutes = time.getMinutes();
            StringBuffer minute = new StringBuffer();
            if (timeMinutes < 10) {
                minute.append("0");
            }
            minute.append(Integer.toString(timeMinutes));
            tags.put(prefix + "Minute", minute.toString());
        }
    }

    private void tagLocation(String location, Hashtable tags, String prefix) {
        if (location == null) {
            location = "";
        }
        tags.put(prefix + "-location", location);
    }

    private void tagHref(String href, Hashtable tags, String prefix) {
        if (href == null) {
            href = "";
        }
        tags.put(prefix + "-href", href);
    }

    private void tagEventSummary(VEvent event, Hashtable tags, String prefix, HttpServletRequest request, CalendarApplicationHelper appHelper) {
        String url = null;
        String summary = null;
        try {
            if (appHelper != null) {
                url = appHelper.getEventURL(this, request, event);
            }
            summary = event.getSummary();
        }
        catch (Exception e) {
            this.debugError("CalendarProvider.tagEventSummary() failed. ", e);
        }
        this.tagSummary(summary, tags, prefix, url);
    }

    private void tagTaskSummary(VTodo task, Hashtable tags, String prefix, HttpServletRequest request, CalendarApplicationHelper appHelper) {
        String url = null;
        String summary = null;
        try {
            if (appHelper != null) {
                url = appHelper.getTaskURL(this, request, task);
            }
            summary = task.getSummary();
        }
        catch (Exception e) {
            this.debugError("CalendarProvider.tagTaskSummary() failed. ", e);
        }
        this.tagSummary(summary, tags, prefix, url);
    }

    private void tagSummary(String summary, Hashtable tags, String prefix, String link) {
        if (summary == null) {
            summary = this.bundleNoSummary;
        }
        summary = this.escapeContent(summary);
        try {
            if (link != null && !this.getBestBooleanProperty("disableTaskEventURLs", false, this.pflist)) {
                Hashtable<String, String> etags = new Hashtable<String, String>();
                etags.put("link", link);
                etags.put("name", summary);
                summary = this.getTemplate("url.template", etags).toString();
            }
        }
        catch (ProviderException pe) {
            this.debugMessage("CalendarProvider.tagSummary() failed, could not find url.template. ", pe);
        }
        tags.put(prefix + "-summary", summary);
    }

    private void tagDescription(String description, Hashtable tags, String prefix) {
        if (description == null) {
            description = "";
        } else {
            tags.put("calendar-display-dayView-description-seperator", this.bundleDescriptionSeperator);
        }
        tags.put(prefix + "-description", description);
    }

    protected VEvent[] getTransformedEventList(VEvent[] events) throws Exception {
        if (events == null) {
            return null;
        }
        ArrayList<VEvent> eventList = new ArrayList<VEvent>();
        int allDayIdx = 0;
        for (int i = 0; i < events.length; ++i) {
            DateTime eventStart = events[i].getStart();
            DateTime eventEnd = events[i].getEnd();
            String eventID = events[i].getID();
            if (!events[i].hasProperty("isConflict")) {
                events[i].setProperty("isConflict", (Object)"false");
            }
            for (int k = 0; k < events.length; ++k) {
                DateTime conflictEventStart = events[k].getStart();
                String conflictEventID = events[k].getID();
                if (conflictEventID.equals(eventID) || eventEnd == null || conflictEventStart == null || events[k].hasProperty("isConflict") && events[k].getProperty("isConflict").equals("true")) continue;
                if (conflictEventStart.equals((Object)eventStart) || conflictEventStart.after((Object)eventStart) && conflictEventStart.before((Object)eventEnd)) {
                    events[k].setProperty("isConflict", (Object)"true");
                    events[i].setProperty("isConflict", (Object)"true");
                    continue;
                }
                if (conflictEventStart.after((Object)eventEnd)) break;
            }
            if (events[i].isAllDay()) {
                eventList.add(allDayIdx, events[i]);
                ++allDayIdx;
                continue;
            }
            eventList.add(events[i]);
        }
        return eventList.toArray(new VEvent[0]);
    }

    protected String getApplicationStartURL(CalendarApplicationHelper calApplicationHelper, HttpServletRequest request) {
        String applicationURLString = null;
        if (calApplicationHelper != null) {
            applicationURLString = calApplicationHelper.getStartURL(this, request);
        }
        if (applicationURLString == null) {
            this.debugWarning("CalendarProvider.getApplicationStartURL(): applicationURLString is not set.");
        }
        return applicationURLString;
    }

    protected boolean isTodayTask(VTodo task, DateTime today) throws OperationNotSupportedException, CalendarComponentException {
        boolean isToday = false;
        if (task.getDueTime() == null || this.matchDayMonthYear(task.getDueTime(), today)) {
            isToday = true;
        }
        return isToday;
    }

    protected boolean matchDayMonthYear(DateTime date1, DateTime date2) {
        boolean match = false;
        if (date1.getDay() == date2.getDay() && date1.getMonth() == date2.getMonth() && date1.getYear() == date2.getYear()) {
            match = true;
        }
        return match;
    }

    protected void setCalendarSelectOptions(SSOAdapter ssoAdapter) throws ProviderException {
        String eprc;
        Properties props;
        CalendarStore calStore = (CalendarStore)ssoAdapter.getConnection();
        if (calStore == null) {
            return;
        }
        String[] subscribedCalendars = null;
        HashMap<String, String> calsCollection = new HashMap<String, String>();
        try {
            subscribedCalendars = calStore.getSubscribedCalenders();
        }
        catch (CalendarStoreException cse) {
            this.debugMessage(this.getName() + " only supports the user's default calendar", cse);
        }
        catch (OperationNotSupportedException onse) {
            this.debugMessage(this.getName() + " only supports the user's default calendar", onse);
        }
        if (subscribedCalendars != null) {
            for (int k = 0; k < subscribedCalendars.length; ++k) {
                String calid = subscribedCalendars[k];
                calsCollection.put(calid, calid);
            }
        }
        if (!calsCollection.isEmpty()) {
            this.setMapProperty("calendarSelectOptions", calsCollection);
        }
        if ((props = ssoAdapter.getProperties()) != null && (eprc = props.getProperty("enablePerRequestConnection", "false")) != null && eprc.equals("true")) {
            ssoAdapter.closeConnection();
        }
    }

    public DateTime getMonthStart(DateTime today) {
        DateTime start = (DateTime)today.clone();
        start.setDay(1);
        int subtract = (start.get(7) - 1) * -1;
        start.add(5, subtract);
        return start;
    }

    public DateTime getMonthEnd(DateTime today) {
        DateTime end = (DateTime)today.clone();
        end.setDay(end.getMaximum(5));
        int add = 7 - end.get(7);
        end.add(5, add);
        return end;
    }

    public void populateHeaderTags(Hashtable tags, String tagPrefix, DateTime date) {
        if (tags == null || date == null) {
            return;
        }
        try {
            DateFormatSymbols symbols = new DateFormatSymbols(this.userLocale);
            tags.put(tagPrefix + "-currentDayOfWeek", symbols.getWeekdays()[date.get(7)]);
            tags.put(tagPrefix + "-currentMonth", symbols.getMonths()[date.getMonth()]);
            tags.put(tagPrefix + "-currentDay", Integer.toString(date.getDay()));
            tags.put(tagPrefix + "-currentYear", Integer.toString(date.getYear()));
        }
        catch (Exception e) {
            this.debugError(this.getName() + ".populateHeaderTags():", e);
        }
    }

    public void populateDayTags(Hashtable tags, String tagPrefix, DateTime date) {
        if (tags == null || date == null) {
            return;
        }
        try {
            DateFormatSymbols symbols = new DateFormatSymbols(this.userLocale);
            tags.put(tagPrefix + "-dayOfWeek", symbols.getWeekdays()[date.get(7)]);
            tags.put(tagPrefix + "-month", symbols.getMonths()[date.getMonth()]);
            tags.put(tagPrefix + "-day", Integer.toString(date.getDay()));
            tags.put(tagPrefix + "-year", Integer.toString(date.getYear()));
        }
        catch (Exception e) {
            this.debugError(this.getName() + ".populateDayTags():", e);
        }
    }

    public void populateDayOfWeekTags(Hashtable tags, String tagPrefix, DateTime date) {
        if (tags == null || date == null) {
            return;
        }
        try {
            DateFormatSymbols symbols = new DateFormatSymbols(this.userLocale);
            for (int i = 0; i < 7; ++i) {
                date.add(5, 1);
                tags.put(tagPrefix + "-dayOfWeek" + i, symbols.getWeekdays()[date.get(7)]);
            }
        }
        catch (Exception e) {
            this.debugError(this.getName() + ".populateDayOfWeekTags():", e);
        }
    }

    private String escapeContent(String inContent) {
        if (inContent == null) {
            return null;
        }
        try {
            return this.getProviderContext().escape(inContent);
        }
        catch (ProviderContextException e) {
            this.debugError(this.getName() + ".escapeContent():", e);
            return inContent;
        }
    }

    private void debugMessage(String msg, Throwable t) {
        if (this.providerContext.isDebugMessageEnabled()) {
            this.providerContext.debugMessage((Object)(this.getName() + " " + msg), t);
        }
    }

    private void debugWarning(String warn, Throwable th) {
        if (this.providerContext.isDebugWarningEnabled()) {
            this.providerContext.debugWarning((Object)(this.getName() + " " + warn), th);
        }
    }

    private void debugError(String err, Throwable thr) {
        if (this.providerContext.isDebugErrorEnabled()) {
            this.providerContext.debugError((Object)(this.getName() + " " + err), thr);
        }
    }

    private void debugMessage(String msg) {
        if (this.providerContext.isDebugMessageEnabled()) {
            this.providerContext.debugMessage((Object)(this.getName() + " " + msg));
        }
    }

    private void debugWarning(String warn) {
        if (this.providerContext.isDebugWarningEnabled()) {
            this.providerContext.debugWarning((Object)(this.getName() + " " + warn));
        }
    }

    private void debugError(String err) {
        if (this.providerContext.isDebugErrorEnabled()) {
            this.providerContext.debugError((Object)(this.getName() + " " + err));
        }
    }

    public String getBestStringProperty(String key, String def, List pflist) {
        ProviderContext pc = this.getProviderContext();
        try {
            if (key != null) {
                if (pc.existsStringProperty(this.getName(), key, pflist)) {
                    return pc.getStringProperty(this.getName(), key, pflist);
                }
                if (pc.existsStringProperty(this.getName(), key)) {
                    return pc.getStringProperty(this.getName(), key);
                }
            }
            return def;
        }
        catch (ProviderContextException pce) {
            pc.debugWarning((Object)("MailProvider.getBestStringProperty(): Unable to get " + key));
            return def;
        }
    }

    public String getBestStringProperty(String key, List pflist) {
        return this.getBestStringProperty(key, "", pflist);
    }

    public int getBestIntegerProperty(String key, int def, List pflist) {
        ProviderContext pc = this.getProviderContext();
        try {
            if (key != null) {
                if (pc.existsIntegerProperty(this.getName(), key, pflist)) {
                    return pc.getIntegerProperty(this.getName(), key, pflist);
                }
                if (pc.existsIntegerProperty(this.getName(), key)) {
                    return pc.getIntegerProperty(this.getName(), key);
                }
            }
            return def;
        }
        catch (ProviderContextException pce) {
            pc.debugWarning((Object)("MailProvider.getBestIntegerProperty(): Unable to get " + key));
            return def;
        }
    }

    public int getBestIntegerProperty(String key, List pflist) {
        return this.getBestIntegerProperty(key, -1, pflist);
    }

    public Map getBestCollectionProperty(String key, Map def, List pflist) {
        ProviderContext pc = this.getProviderContext();
        try {
            if (key != null) {
                if (pc.existsCollectionProperty(this.getName(), key, pflist)) {
                    return pc.getCollectionProperty(this.getName(), key, pflist);
                }
                if (pc.existsCollectionProperty(this.getName(), key)) {
                    return pc.getCollectionProperty(this.getName(), key);
                }
            }
            return def;
        }
        catch (ProviderContextException pce) {
            pc.debugWarning((Object)("MailProvider.getBestCollectionProperty(): Unable to get " + key));
            return def;
        }
    }

    public Map getBestCollectionProperty(String key, List pflist) {
        return this.getBestCollectionProperty(key, null, pflist);
    }

    public boolean getBestBooleanProperty(String key, boolean def, List pflist) {
        ProviderContext pc = this.getProviderContext();
        try {
            if (key != null) {
                if (pc.existsBooleanProperty(this.getName(), key, pflist)) {
                    return pc.getBooleanProperty(this.getName(), key, pflist);
                }
                if (pc.existsBooleanProperty(this.getName(), key)) {
                    return pc.getBooleanProperty(this.getName(), key);
                }
            }
            return def;
        }
        catch (ProviderContextException pce) {
            pc.debugWarning((Object)("MailProvider.getBestStringProperty(): Unable to get " + key));
            return def;
        }
    }

    public boolean getBestBooleanProperty(String key, List pflist) {
        return this.getBestBooleanProperty(key, false, pflist);
    }
}

