/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.portal.provider;

import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.security.DecryptAction;
import com.sun.identity.security.EncryptAction;
import com.sun.im.portal.provider.IMListener;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionFactory;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceListener;
import com.sun.im.service.ConferenceSession;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.InviteMessageStatusListener;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.Presence;
import com.sun.im.service.PresenceHelper;
import com.sun.im.service.PresenceSession;
import com.sun.im.service.PresenceTuple;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.jsp.JSPProvider;
import java.net.URL;
import java.security.AccessController;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IMProvider
extends JSPProvider {
    public static final String SESSION_FACTORY = "com.iplanet.im.client.api.TransUnidirectionalSessionProvider";
    private static CollaborationSessionFactory factory;
    boolean isSecureModeKnown = false;
    boolean isSecureModeValue = false;
    static final StringBuffer ONLINE_NO;
    static final StringBuffer ONLINE_YES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String n, HttpServletRequest httpreq) throws ProviderException {
        super.init(n, httpreq);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            try {
                if (factory == null) {
                    factory = new CollaborationSessionFactory(SESSION_FACTORY);
                }
            }
            catch (Exception e) {
                throw new ProviderException("IMProvider.init(): Problem creating CollarborationSessionFactory", (Throwable)e);
            }
        }
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String v = req.getParameter("inviteifonline");
        if (v != null && v.equals("yes")) {
            try {
                PresenceTuple t;
                CollaborationSession session = this.getCollaborationSession(req);
                if (session == null) {
                    return ONLINE_NO;
                }
                String me = session.getPrincipal().getUID();
                PresenceSession ps = (PresenceSession)session.accessService("presence");
                PresenceTuple pt = new PresenceTuple(me);
                pt.setStatus("OPEN");
                pt.setPriority(0.0f);
                Presence presence = new Presence(me);
                presence.addTuple(pt);
                ps.publish(presence.toString());
                pt.setStatus("CLOSED");
                pt.setPriority(0.0f);
                presence = new Presence(me);
                presence.addTuple(pt);
                ps.publish(presence.toString());
                String pi = ps.fetch(me);
                PresenceHelper ph = new PresenceHelper(pi);
                Iterator i = ph.getTuples().iterator();
                if (i.hasNext() && !(t = (PresenceTuple)i.next()).getStatus().equals("CLOSED") && !t.getStatus().equals("FORWARDED")) {
                    String username = req.getParameter("username");
                    if (username == null) {
                        throw new ProviderException("IMProvider: inviteifonline invoked without username argument");
                    }
                    String msg = req.getParameter("msg");
                    if (msg == null) {
                        msg = "";
                    }
                    this.startConference(session, me, username, msg);
                    session.logout();
                    return ONLINE_YES;
                }
                session.logout();
            }
            catch (CollaborationException ce) {
                this.getProviderContext().debugError((Object)"IMProvider online check colab problem", (Throwable)ce);
            }
            catch (Exception e) {
                this.getProviderContext().debugError((Object)"IMProvider online check error", (Throwable)e);
            }
            return ONLINE_NO;
        }
        return super.getContent(req, res);
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String val = req.getParameter("contactGroup");
        if (val != null && val.length() > 0) {
            if (val.equals("__ALL__")) {
                val = "";
            }
            if (!val.equals(this.getStringProperty("contactGroup"))) {
                this.setStringProperty("contactGroup", val);
            }
        }
        if ((val = req.getParameter("mux")) != null && val.length() > 0 && !val.equals(this.getStringProperty("mux"))) {
            this.setStringProperty("mux", val);
        }
        if ((val = req.getParameter("muxport")) != null && val.length() > 0 && !val.equals(this.getStringProperty("muxport"))) {
            this.setStringProperty("muxport", val);
        }
        if ((val = req.getParameter("clientRunMode")) != null && (val.equals("plugin") || val.equals("jnlp")) && !val.equals(this.getStringProperty("clientRunMode"))) {
            this.setStringProperty("clientRunMode", val);
        }
        if ((val = req.getParameter("username")) != null && !val.equals(this.getStringProperty("username"))) {
            this.setStringProperty("username", val);
        }
        if ((val = req.getParameter("password")) != null && !val.equals(this.getDummyPassword())) {
            if (!val.equals("")) {
                val = (String)AccessController.doPrivileged(new EncryptAction(val));
            }
            this.setStringProperty("password", val);
        }
        return null;
    }

    public String getDummyPassword() throws ProviderException {
        StringBuffer dummy = new StringBuffer();
        int len = ((String)AccessController.doPrivileged(new DecryptAction(this.getStringProperty("password")))).length();
        for (int i = 0; i < len; ++i) {
            dummy.append("*");
        }
        return dummy.toString();
    }

    public CollaborationSession getCollaborationSession(HttpServletRequest request) throws CollaborationException, Exception, ProviderException {
        String server = this.getStringProperty("mux");
        String port = this.getStringProperty("muxport");
        if (server == null || server.length() == 0) {
            this.getProviderContext().debugWarning((Object)"IMProvider: connection failed: server not specified.");
            return null;
        }
        StringBuffer host = new StringBuffer();
        host.append(server).append(":").append(port);
        String username = this.getUsername();
        String password = this.getToken(request);
        return factory.getSession(host.toString(), username, password, (CollaborationSessionListener)IMListener.getInstance());
    }

    public String getUsername() throws ProviderException {
        String username = null;
        String authMethod = this.getStringProperty("authMethod");
        if (authMethod.equals("idsvr")) {
            username = this.getStringAttribute(this.getStringProperty("authUsernameAttr"));
        } else if (authMethod.equals("ldap")) {
            username = this.getStringProperty("username");
        } else {
            throw new ProviderException("invalid authMethod: " + authMethod);
        }
        return username;
    }

    public String getToken(HttpServletRequest request) throws ProviderException {
        try {
            String token;
            String authMethod = this.getStringProperty("authMethod");
            if (authMethod.equals("idsvr")) {
                token = SSOTokenManager.getInstance().createSSOToken(request).getTokenID().toString();
            } else if (authMethod.equals("ldap")) {
                String pw = this.getStringProperty("password");
                token = pw == null || pw.length() == 0 ? pw : (String)AccessController.doPrivileged(new DecryptAction(pw));
            } else {
                throw new ProviderException("invalid authMethod: " + authMethod);
            }
            return token;
        }
        catch (Exception e) {
            throw new ProviderException("IMProvider.getToken", (Throwable)e);
        }
    }

    private void startConference(CollaborationSession session, String initiator, String invitee, String msg) throws ProviderException {
        try {
            ConferenceSession cs = (ConferenceSession)session.accessService("conference");
            Conference conf = cs.setupConference((ConferenceListener)IMListener.getInstance(), 30);
            InviteMessage inviteMessage = conf.createInviteMessage();
            MessagePart part = inviteMessage.newPart();
            inviteMessage.setOriginator(initiator);
            part.setContent(msg);
            inviteMessage.addPart(part);
            inviteMessage.addRecipient(initiator);
            inviteMessage.addRecipient(invitee);
            conf.invite(30, (Message)inviteMessage, (InviteMessageStatusListener)IMListener.getInstance());
        }
        catch (CollaborationException ce) {
            throw new ProviderException("IMProvider.startConference:", (Throwable)ce);
        }
    }

    static {
        ONLINE_NO = new StringBuffer("n");
        ONLINE_YES = new StringBuffer("y");
    }
}

