/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.util;

public class Semaphore {
    private int value = 0;
    private int waitCount = 0;
    private int notifyCount = 0;

    public Semaphore(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.value = n;
    }

    public synchronized void acquire() throws InterruptedException {
        if (this.value <= this.waitCount) {
            ++this.waitCount;
            try {
                do {
                    this.wait();
                } while (this.notifyCount == 0);
            }
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
            finally {
                --this.waitCount;
            }
            --this.notifyCount;
        }
        --this.value;
    }

    public synchronized void release() {
        ++this.value;
        if (this.waitCount > this.notifyCount) {
            ++this.notifyCount;
            this.notify();
        }
    }
}

