/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.rdm;

import com.sun.portal.search.rdm.RDMCallback;
import com.sun.portal.search.rdm.RDMClassification;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;

public class RDMTaxonomy {
    RDMClassification root = new RDMClassification("ROOT");
    SOIF soif = new SOIF("TAXONOMY", null);
    public static final String RDM_TAXONOMY_ROOT = "ROOT";

    public RDMTaxonomy(SOIFInputStream sOIFInputStream) throws Exception {
        this((String)null);
        SOIF sOIF;
        while ((sOIF = sOIFInputStream.readSOIF()) != null) {
            if (sOIF.getSchemaName().equalsIgnoreCase("TAXONOMY")) {
                this.soif.merge(sOIF);
                this.root.soif.insert("taxonomy-id", this.getId());
                continue;
            }
            if (!sOIF.getSchemaName().equalsIgnoreCase("CLASSIFICATION")) {
                throw new Exception("expected classification");
            }
            String string = sOIF.getValue("taxonomy-id");
            if (string == null || !string.equalsIgnoreCase(this.getId())) continue;
            RDMClassification rDMClassification = new RDMClassification(sOIF.getValue("id"));
            rDMClassification.soif.merge(sOIF);
            this.insert(rDMClassification);
        }
    }

    public RDMTaxonomy(String string) {
        if (string != null) {
            this.soif.insert("id", string);
            this.root.soif.insert("taxonomy-id", string);
        }
    }

    public RDMClassification find(String string) {
        if (string.equals(RDM_TAXONOMY_ROOT)) {
            return this.root;
        }
        if (string.equals(this.getId())) {
            return this.root;
        }
        return this.root.find(string);
    }

    public void insert(RDMClassification rDMClassification) {
        String string = rDMClassification.getParentId();
        if (string != null) {
            rDMClassification.parent = this.find(string);
            if (rDMClassification.parent != null) {
                rDMClassification.parent.insertChild(rDMClassification);
            }
        }
    }

    protected void delete(RDMClassification rDMClassification) {
    }

    public void apply(int n, RDMCallback rDMCallback) throws Exception {
        if (this.root != null) {
            this.root.apply(n, rDMCallback);
        }
    }

    public int depth(RDMClassification rDMClassification) {
        int n = 0;
        RDMClassification rDMClassification2 = rDMClassification;
        while (rDMClassification2 != null && !rDMClassification2.getId().equals(RDM_TAXONOMY_ROOT)) {
            ++n;
            rDMClassification2 = rDMClassification2.parent;
        }
        return n;
    }

    public String getId() {
        return this.soif.getValue("id");
    }

    public String getDescription() {
        return this.soif.getValue("description");
    }

    public String getLMT() {
        return this.soif.getValue("last-modified");
    }

    public String getMaintainer() {
        return this.soif.getValue("maintainer");
    }

    public SOIF getSOIF() {
        return this.soif;
    }

    public void setId(String string) {
        this.soif.replace("id", string);
    }

    public void setDescription(String string) {
        this.soif.replace("description", string);
    }

    public void setLMT(String string) {
        this.soif.replace("last-modified", string);
    }

    public void setMaintainer(String string) {
        this.soif.replace("maintainer", string);
    }
}

