/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.rdm;

import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;

public class RDMHeader {
    SOIF soif = new SOIF("RDMHEADER", null);

    public RDMHeader(SOIFInputStream sOIFInputStream) throws Exception {
        this();
        SOIF sOIF = sOIFInputStream.readSOIF();
        if (sOIF == null || !sOIF.getSchemaName().equalsIgnoreCase("RDMHEADER")) {
            throw new Exception("Invalid header");
        }
        String string = sOIF.getValue("rdm-type");
        if (string == null) {
            string = "unknown";
        }
        this.soif = sOIF;
        String string2 = this.getVersion();
        if (this.getType() == "unknown" || string2 != null && !string2.equalsIgnoreCase("1.0")) {
            throw new Exception("Invalid header");
        }
    }

    public RDMHeader(String string, String string2, String string3, String string4) {
        this(string);
        if (string2 != null) {
            this.setCSID(string2);
        }
        if (string3 != null) {
            this.setQueryLanguage(string3);
        }
        if (string4 != null) {
            this.setResponseInterpret(string4);
        }
    }

    public RDMHeader(String string) {
        this.setType(string);
        this.setVersion("1.0");
    }

    public RDMHeader() {
        this.setVersion("1.0");
    }

    public final String getType() {
        return this.soif.getValue("rdm-type");
    }

    public final String getVersion() {
        return this.soif.getValue("rdm-version");
    }

    public final String getQueryLanguage() {
        return this.soif.getValue("rdm-query-language");
    }

    public final String getCSID() {
        return this.soif.getValue("catalog-service-id");
    }

    public final String getResponseInterpret() {
        return this.soif.getValue("rdm-response-interpret");
    }

    public final String getErrorMessage() {
        return this.soif.getValue("rdm-error-message");
    }

    public final String getErrorNumber() {
        return this.soif.getValue("rdm-error-number");
    }

    public final String getAccessToken() {
        return this.soif.getValue("rdm-access-token");
    }

    public final String getUser() {
        return this.soif.getValue("rdm-user");
    }

    public final String getPassword() {
        return this.soif.getValue("rdm-password");
    }

    public final String getParam(String string) {
        return this.soif.getValue(string);
    }

    public final SOIF getSOIF() {
        return this.soif;
    }

    public final void setType(String string) {
        this.soif.replace("rdm-type", string);
    }

    public final void setVersion(String string) {
        this.soif.replace("rdm-version", string);
    }

    public final void setQueryLanguage(String string) {
        this.soif.replace("rdm-query-language", string);
    }

    public final void setCSID(String string) {
        this.soif.replace("catalog-service-id", string);
    }

    public final void setResponseInterpret(String string) {
        this.soif.replace("rdm-response-interpret", string);
    }

    public final void setErrorMessage(String string) {
        this.soif.replace("rdm-error-message", string);
    }

    public final void setErrorNumber(String string) {
        this.soif.replace("rdm-error-number", string);
    }

    public final void setAccessToken(String string) {
        this.soif.replace("rdm-access-token", string);
    }

    public final void setUser(String string) {
        this.soif.replace("rdm-user", string);
    }

    public final void setPassword(String string) {
        this.soif.replace("rdm-password", string);
    }

    public final void setParam(String string, String string2) {
        this.soif.replace(string, string2);
    }

    public String toString() {
        String string = "";
        if (this.soif != null) {
            string = string + this.soif;
        }
        return string;
    }
}

