/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.db;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbDeadlockException;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import com.sun.portal.search.db.Datum;
import com.sun.portal.search.db.PartitionedDb;
import com.sun.portal.search.rdm.RDMDeadlockException;
import com.sun.portal.search.rdm.RDMException;
import com.sun.portal.search.rdm.RDMTransaction;

public class DbCursor {
    Dbc[] dbc;
    RDMTransaction t;
    PartitionedDb cdbm;
    int current;

    public DbCursor(PartitionedDb partitionedDb, RDMTransaction rDMTransaction, int n) throws RDMException {
        try {
            this.dbc = new Dbc[partitionedDb.extents];
            this.t = rDMTransaction;
            this.cdbm = partitionedDb;
            this.current = 0;
            for (int i = 0; i < this.dbc.length; ++i) {
                DbTxn dbTxn = null;
                if (rDMTransaction != null) {
                    dbTxn = (DbTxn)rDMTransaction.getNativeTxn();
                }
                this.dbc[i] = partitionedDb.db[i].db.cursor(dbTxn, n);
            }
        }
        catch (DbException dbException) {
            throw new RDMException((Exception)((Object)dbException));
        }
    }

    private DbCursor() {
    }

    public void close() throws RDMException {
        try {
            for (int i = 0; i < this.dbc.length; ++i) {
                if (this.dbc[i] == null) continue;
                this.dbc[i].close();
                this.dbc[i] = null;
            }
        }
        catch (DbException dbException) {
            throw new RDMException((Exception)((Object)dbException));
        }
    }

    public int get(Datum datum, Datum datum2, int n) throws RDMException {
        try {
            int n2;
            if (n == Db.DB_FIRST) {
                this.current = -1;
            } else {
                n2 = 0;
                if (this.t != null) {
                    n2 = this.dbc[this.current].get((Dbt)datum, (Dbt)datum2, Db.DB_NEXT);
                } else {
                    while (true) {
                        try {
                            n2 = this.dbc[this.current].get((Dbt)datum, (Dbt)datum2, Db.DB_NEXT);
                        }
                        catch (DbDeadlockException dbDeadlockException) {
                            continue;
                        }
                        break;
                    }
                }
                if (n2 == 0) {
                    return 0;
                }
            }
            ++this.current;
            while (this.current < this.cdbm.extents) {
                n2 = 0;
                if (this.t != null) {
                    n2 = this.dbc[this.current].get((Dbt)datum, (Dbt)datum2, Db.DB_FIRST);
                } else {
                    while (true) {
                        try {
                            n2 = this.dbc[this.current].get((Dbt)datum, (Dbt)datum2, Db.DB_FIRST);
                        }
                        catch (DbDeadlockException dbDeadlockException) {
                            continue;
                        }
                        break;
                    }
                }
                if (n2 == 0) {
                    return 0;
                }
                ++this.current;
            }
        }
        catch (DbDeadlockException dbDeadlockException) {
            throw new RDMDeadlockException((Exception)((Object)dbDeadlockException));
        }
        catch (DbException dbException) {
            throw new RDMException((Exception)((Object)dbException));
        }
        return -30990;
    }

    public int del(int n) throws RDMException {
        int n2;
        block7: {
            n2 = 0;
            try {
                if (this.t != null) {
                    n2 = this.dbc[this.current].del(n);
                    break block7;
                }
                while (true) {
                    try {
                        n2 = this.dbc[this.current].del(n);
                    }
                    catch (DbDeadlockException dbDeadlockException) {
                        continue;
                    }
                    break;
                }
            }
            catch (DbDeadlockException dbDeadlockException) {
                throw new RDMDeadlockException((Exception)((Object)dbDeadlockException));
            }
            catch (DbException dbException) {
                throw new RDMException((Exception)((Object)dbException));
            }
        }
        return n2;
    }

    public int put(Dbt dbt, Dbt dbt2, int n) throws RDMException {
        int n2;
        block7: {
            n2 = 0;
            try {
                if (this.t != null) {
                    n2 = this.dbc[this.current].put(dbt, dbt2, n);
                    break block7;
                }
                while (true) {
                    try {
                        n2 = this.dbc[this.current].put(dbt, dbt2, n);
                    }
                    catch (DbDeadlockException dbDeadlockException) {
                        continue;
                    }
                    break;
                }
            }
            catch (DbDeadlockException dbDeadlockException) {
                throw new RDMDeadlockException((Exception)((Object)dbDeadlockException));
            }
            catch (DbException dbException) {
                throw new RDMException((Exception)((Object)dbException));
            }
        }
        return n2;
    }
}

