/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.mail;

import com.iplanet.sso.SSOToken;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.context.Theme;
import com.sun.portal.providers.mail.MailApplicationHelper;
import com.sun.portal.providers.mail.MailProvider;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.mail.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExchangeMailHelper
implements MailApplicationHelper {
    public MailProvider provider = null;
    public SSOAdapter ssoAdapter = null;
    public Properties adapterProperties = null;
    protected String appName = "";
    protected String containerName = "";

    public void init(MailProvider provider, SSOAdapter ssoAdapter) throws Exception {
        this.provider = provider;
        this.ssoAdapter = ssoAdapter;
        if (ssoAdapter != null) {
            this.adapterProperties = ssoAdapter.getProperties();
        }
    }

    public String getStartURL(MailProvider provider, HttpServletRequest request) {
        String url = null;
        try {
            url = this.getApplicationURL(provider, request);
            ProviderContext pc = provider.getProviderContext();
            url = pc.escape(url);
        }
        catch (Exception e) {
            SSOAdapterDebug.logWarning((String)(this.getClass().getName() + ".getStartURL(): could not determine start url "), (Throwable)e);
        }
        return url;
    }

    public String getApplicationURL(MailProvider provider, HttpServletRequest request) throws Exception {
        String exchangeOperation;
        String host = this.adapterProperties.getProperty("host");
        String clientPort = this.adapterProperties.getProperty("clientPort", this.adapterProperties.getProperty("port", "80"));
        String clientProtocol = this.adapterProperties.getProperty("clientProtocol", "http");
        String exchangeContextPath = this.adapterProperties.getProperty("exchangeContextPath", "/exchange");
        String clientURL = clientProtocol + "://" + host + ":" + clientPort + exchangeContextPath;
        SSOToken tok = this.ssoAdapter.getSSOToken();
        if (tok != null && (exchangeOperation = this.adapterProperties.getProperty("exchangeOperation")) != null) {
            clientURL = clientURL + "/" + this.adapterProperties.getProperty("uid") + "/" + exchangeOperation;
        }
        return clientURL;
    }

    public String getMessageURL(MailProvider provider, HttpServletRequest request, Message message) throws Exception {
        return null;
    }

    public void error(ProviderContext pc, String msg) {
        if (pc.isDebugErrorEnabled()) {
            pc.debugError((Object)msg);
        }
    }

    public void warning(ProviderContext pc, String msg) {
        if (pc.isDebugWarningEnabled()) {
            pc.debugWarning((Object)msg);
        }
    }

    public void message(ProviderContext pc, String msg) {
        if (pc.isDebugMessageEnabled()) {
            pc.debugMessage((Object)msg);
        }
    }

    public void error(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugErrorEnabled()) {
            pc.debugError((Object)msg, t);
        }
    }

    public void warning(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugWarningEnabled()) {
            pc.debugWarning((Object)msg, t);
        }
    }

    public void message(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugMessageEnabled()) {
            pc.debugMessage((Object)msg, t);
        }
    }

    public StringBuffer getAppPrefsEdit(MailProvider mprov, HttpServletRequest req, HttpServletResponse res) {
        StringBuffer content = new StringBuffer();
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        ProviderContext pc = mprov.getProviderContext();
        Map dpEditMap = null;
        String fontTag = "";
        try {
            List pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(mprov.getName(), "dpEditAttributes", pflist);
            fontTag = Theme.getAttribute((String)mprov.getName(), (ProviderContext)pc, (String)"fontFace");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            tagTable.put("isAppHandler", this.getName());
        }
        catch (ProviderContextException pce) {
            this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
        }
        if (dpEditMap != null) {
            try {
                ProviderEditUtility.setDefaultPresentation((String)this.provider.getName(), (ProviderContext)this.provider.getProviderContext(), tagTable);
                content.append(pc.getTemplate(this.provider.getName(), "edit-start.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                while (tok.hasMoreElements()) {
                    String type = tok.nextToken();
                    String header = tok.nextToken();
                    content.append(ProviderEditUtility.createEditContent((String)type, (String)header, (String)key, (String)mprov.getName(), (ProviderContext)pc, (boolean)true));
                }
            }
            try {
                ProviderEditUtility.setDefaultPresentation((String)this.provider.getName(), (ProviderContext)this.provider.getProviderContext(), tagTable);
                content.append(pc.getTemplate(this.provider.getName(), "edit-end.template", tagTable));
            }
            catch (ProviderContextException pce) {
                this.error(pc, "Exception thrown retrieving values from the display profile\n", pce);
            }
        }
        return content;
    }

    public URL processAppPrefsEdit(MailProvider mprov, HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        URL url = null;
        Object props = null;
        Map dpEditMap = null;
        ProviderContext pc = mprov.getProviderContext();
        StringBuffer returnURL = new StringBuffer();
        List pflist = null;
        try {
            url = this.getAppHelperProcessURL(request, mprov);
            pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(mprov.getName(), "dpEditAttributes", pflist);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ExchangeMailHelper.processAppPrefsEdit():\n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                String type = tok.nextToken();
                try {
                    pc.debugMessage((Object)("ExchangeMailHelper.processAppPrefsEdit(): key=" + key));
                    if (type.equals("string") || type.equals("select") || type.equals("password")) {
                        String reqString = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                        if (reqString.equals("")) continue;
                        if (pc.existsStringProperty(mprov.getName(), key, pflist)) {
                            pc.setStringProperty(mprov.getName(), key, reqString, pflist);
                            pc.debugMessage((Object)("ExchangeMailHelper.processAppPrefsEdit(): reqString(filtered)=" + reqString));
                            continue;
                        }
                        if (pc.existsStringProperty(mprov.getName(), key)) {
                            pc.setStringProperty(mprov.getName(), key, reqString);
                            pc.debugMessage((Object)("ExchangeMailHelper.processAppPrefsEdit(): reqString=" + reqString));
                            continue;
                        }
                        pc.debugWarning((Object)("ExchangeMailHelper.processAppPrefsEdit(): Unable to save key=" + key));
                        continue;
                    }
                    if (type.equals("int")) {
                        String reqNumber = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                        if (reqNumber.equals("")) continue;
                        if (pc.existsIntegerProperty(mprov.getName(), key, pflist)) {
                            pc.setIntegerProperty(mprov.getName(), key, Integer.parseInt(reqNumber), pflist);
                            continue;
                        }
                        if (pc.existsIntegerProperty(mprov.getName(), key)) {
                            pc.setIntegerProperty(mprov.getName(), key, Integer.parseInt(reqNumber));
                            continue;
                        }
                        pc.debugWarning((Object)("ExchangeMailHelper.processAppPrefsEdit(): Unable to save key=" + key));
                        continue;
                    }
                    if (!type.equals("check")) continue;
                    String reqBool = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                    Boolean bool = null;
                    bool = reqBool.equals("") ? new Boolean("false") : new Boolean("true");
                    if (pc.existsBooleanProperty(mprov.getName(), key, pflist)) {
                        pc.setBooleanProperty(mprov.getName(), key, bool.booleanValue(), pflist);
                        continue;
                    }
                    if (pc.existsBooleanProperty(mprov.getName(), key)) {
                        pc.setBooleanProperty(mprov.getName(), key, bool.booleanValue());
                        continue;
                    }
                    pc.debugWarning((Object)("ExchangeMailHelper.processAppPrefsEdit(): Unable to save key=" + key));
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("ExchangeMailHelper.processAppPrefsEdit():\n", (Throwable)pce);
                }
            }
        }
        pc.debugMessage((Object)("ExchangeMailHelper::processAppPrefsEdit:  Return url = " + url.toString()));
        return url;
    }

    protected URL getAppHelperProcessURL(HttpServletRequest req, MailProvider prov) {
        ProviderContext pc = prov.getProviderContext();
        StringBuffer link = new StringBuffer();
        URL returnURL = null;
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return null;
        }
        String provider = prov.editContainer;
        String targetProvider = prov.targetProvider;
        String containerName = prov.containerName;
        pc.debugMessage((Object)("ExchangeMailHelper.getAppHelperProcessURL():     provider=" + provider + "\n                                                    targetProvider=" + targetProvider + "\n                                                    containerName=" + containerName));
        if (this.isEmpty(provider) || this.isEmpty(targetProvider) || this.isEmpty(containerName)) {
            pc.debugWarning((Object)"getAppHelperProcessURL():  Missing returnURL parameter and attempting to generate default desktop URL\n");
            try {
                returnURL = new URL(link.toString());
            }
            catch (Exception e) {
                pc.debugWarning((Object)"getAppHelperProcessURL():  Unable to generate default desktop URL\n", (Throwable)e);
                return null;
            }
        }
        link.append("?action=edit&provider=" + provider);
        link.append("&targetprovider=" + targetProvider);
        link.append("&containerName=" + containerName);
        try {
            returnURL = new URL(link.toString());
            pc.debugMessage((Object)("ExchangeMailHelper:getAppHelperProcessURL():  returnURL =" + returnURL));
        }
        catch (Exception e) {
            pc.debugError((Object)"Unable to create returnURL", (Throwable)e);
            return null;
        }
        return returnURL;
    }

    protected boolean isEmpty(String line) {
        return line == null || line.length() > 0;
    }

    public String getAppHelperEditLink(HttpServletRequest req, ProviderContext pc) {
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer link = new StringBuffer();
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return "";
        }
        link.append("?action=edit&provider=");
        link.append(ProviderEditUtility.getRequestParameter((String)"provider", (HttpServletRequest)req));
        link.append("&targetprovider=" + this.provider.getName());
        link.append("&containerName=");
        link.append(ProviderEditUtility.getRequestParameter((String)"containerName", (HttpServletRequest)req));
        link.append("&appPref=" + this.getName());
        tagTable.put("editLink", link.toString());
        String content = null;
        try {
            String fontTag = pc.getStringProperty(this.provider.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            ProviderEditUtility.setDefaultPresentation((String)this.provider.getName(), (ProviderContext)this.provider.getProviderContext(), tagTable);
            content = pc.getTemplate(this.provider.getName(), "edit-link.template", tagTable).toString();
            pc.debugMessage((Object)("content = \n" + content.toString()));
        }
        catch (Exception e) {
            pc.debugError((Object)"unable to create hyperlink\n", (Throwable)e);
            content = "";
        }
        pc.debugMessage((Object)("LDAPABApplicationHelper: returned value is" + content.toString()));
        return content;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public String getName() {
        return this.appName;
    }
}

