/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.cal.socs;

import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.RecurrencePattern;
import com.sun.comclient.calendar.VAlarm;
import com.sun.comclient.calendar.VTodo;
import com.sun.comclient.calendar.socs.SOCSTodo;
import com.sun.portal.wireless.taglibs.base.CollectionIterator;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.cal.TaskBean;
import com.sun.portal.wireless.taglibs.cal.socs.CalIdBean;
import com.sun.portal.wireless.taglibs.cal.socs.EmailReminderBean;
import com.sun.portal.wireless.taglibs.cal.socs.ReminderBean;
import java.util.StringTokenizer;
import java.util.Vector;

public class SOCSTaskBean
extends TaskBean {
    private SOCSTodo theTask;
    private String modifier;
    private ReminderBean firstRemBean;

    public SOCSTaskBean(SOCSTodo task) {
        super((VTodo)task);
        this.theTask = task;
    }

    public VTodo getTask() {
        return this.theTask;
    }

    public boolean isRecurrence() throws Exception {
        return this.theTask.isRecurring();
    }

    public RecurrencePattern getRecurrencePattern() throws Exception {
        if (this.theTask.getRecurrenceRules() != null && this.theTask.getRecurrenceRules().length > 0) {
            return this.theTask.getRecurrenceRules()[0];
        }
        return null;
    }

    public void setRecurrencePattern(RecurrencePattern rPattern) throws Exception {
        RecurrencePattern[] rules = this.theTask.getRecurrenceRules();
        if (rules != null && rules.length > 0) {
            this.theTask.removeAllRecurrenceRules();
        }
        this.theTask.addRecurrenceRule(rPattern);
    }

    public void setLocation(String loc) throws Exception {
        this.theTask.setLocation(loc);
    }

    public String getLocation() throws Exception {
        return this.theTask.getLocation();
    }

    public String getStatus() throws Exception {
        return this.theTask.getStatus();
    }

    public void setStatus(String status) {
        try {
            Util.logMessage((String)("Status = " + status));
            if (status.equalsIgnoreCase("NEEDS-ACTION") || status.equalsIgnoreCase("IN-PROCESS") || status.equalsIgnoreCase("COMPLETED") || status.equalsIgnoreCase("CANCELLED")) {
                if (status.equalsIgnoreCase("COMPLETED")) {
                    this.theTask.setStatus(status);
                    this.theTask.setPercent(100);
                } else {
                    this.theTask.setStatus("IN-PROCESS");
                    this.theTask.setPercent(0);
                }
            }
        }
        catch (Exception ex) {
            Util.logError((String)"TaskBean.setStatus(): ", (Throwable)ex);
        }
    }

    public String getRecurrenceModifier() {
        return this.modifier;
    }

    public String getModifier() {
        return this.getRecurrenceModifier();
    }

    public void setRecurrenceModifier(String mod) {
        this.modifier = mod;
    }

    public void setModifier(String mod) {
        this.setRecurrenceModifier(mod);
    }

    public void setAttendees(String attListCalIds) throws Exception {
        StringTokenizer strTok = new StringTokenizer(attListCalIds, ",;");
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken().trim();
            if (token.equals("")) continue;
            Attendee att = new Attendee("INDIVIDUAL", "REQ-PARTICIPANT", token);
            att.setRSVPRequired(true);
            this.component.addAttendee(att);
        }
    }

    public String getAttendees() throws Exception {
        if (this.component.getAttendees() != null) {
            Attendee[] attArr = this.component.getAttendees();
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < attArr.length; ++i) {
                Attendee att = attArr[i];
                result.append(att.getValue());
                if (i == attArr.length) continue;
                result.append(",");
            }
            return result.toString();
        }
        return new String();
    }

    public boolean isAttendeesEmpty() {
        boolean result = true;
        try {
            result = !this.component.hasAttendee();
        }
        catch (Exception ex) {
            Util.logError((String)"SOCSTaskBean.isAttendeesEmpty(): ", (Throwable)ex);
        }
        return result;
    }

    public CollectionIterator getAttendeesIterator() throws Exception {
        Vector<CalIdBean> result = new Vector<CalIdBean>();
        Attendee[] attArr = this.component.getAttendees();
        if (attArr != null) {
            for (int i = 0; i < attArr.length; ++i) {
                Attendee att = attArr[i];
                if (att == null) continue;
                result.add(new CalIdBean(att.getValue()));
            }
        }
        return new CollectionIterator(result);
    }

    public void setRemovedAttendee(String remove) throws Exception {
        StringTokenizer strTok = new StringTokenizer(remove, ",;");
        while (strTok.hasMoreTokens()) {
            Attendee[] attArr;
            String token = strTok.nextToken().trim();
            if (token.equals("") || (attArr = this.component.getAttendees()) == null) continue;
            for (int i = 0; i < attArr.length; ++i) {
                if (!attArr[i].getValue().equals(token)) continue;
                this.component.removeAttendee(attArr[i]);
            }
        }
    }

    public VAlarm getFirstAlarm() throws Exception {
        VAlarm firstAlarm = null;
        VAlarm[] alarms = this.theTask.getAlarmComponents();
        if (alarms != null && alarms.length > 0) {
            firstAlarm = alarms[0];
        } else {
            firstAlarm = this.theTask.createAlarm();
            this.theTask.addAlarmComponent(firstAlarm);
        }
        if (firstAlarm == null) {
            Util.logError((String)"SOCSTaskBean.getFirstAlarm(): Unable to get any available alarm");
        }
        return firstAlarm;
    }

    public ReminderBean getReminderBean() throws Exception {
        if (this.firstRemBean == null) {
            try {
                this.firstRemBean = this.toReminderBean(this.getFirstAlarm());
            }
            catch (Exception ex) {
                Util.logError((String)"SOCSTaskBean.getReminderBean(): Error: Can not get ReminderBean", (Throwable)ex);
                throw ex;
            }
        }
        return this.firstRemBean;
    }

    protected ReminderBean toReminderBean(VAlarm alarm) {
        return new EmailReminderBean(alarm);
    }

    public boolean isAllDay() throws Exception {
        return this.theTask.isAllDay();
    }

    public void setAllDay(boolean allday) throws Exception {
        if (allday) {
            this.theTask.setAllDay(true);
        } else {
            this.theTask.setAllDay(false);
        }
    }

    public boolean isDue() {
        return this.theTask.hasProperty("DUE");
    }

    public void setDue(boolean flag) {
        if (!flag) {
            this.theTask.removeProperty("DUE");
        }
    }

    public boolean isCompleted() {
        try {
            return this.theTask.isCompleted();
        }
        catch (Exception e) {
            Util.logError((String)"SOCSTaskBean.isCompleted(): Error getting Status: ", (Throwable)e);
            return false;
        }
    }
}

