/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.cal.socs;

import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.VAlarm;
import com.sun.portal.wireless.taglibs.base.Util;

public class ReminderBean {
    private VAlarm alarm = null;
    private int durationMin = 0;
    private int durationHour = 0;
    private int durationDay = 0;
    private boolean isAbsTriggerSet = false;

    public ReminderBean(VAlarm aAlarm) {
        this.alarm = aAlarm;
    }

    public VAlarm getAlarm() {
        return this.alarm;
    }

    protected void setDuration() {
        if (!this.isAbsTriggerSet) {
            try {
                Duration dur = new Duration(this.durationDay, this.durationHour, this.durationMin, 0);
                if (dur != null) {
                    dur.setSign(-1);
                    this.alarm.setTrigger(dur);
                }
            }
            catch (Exception ex) {
                Util.logError((String)"ReminderBean.getAlarm(): Failed to create the Duration", (Throwable)ex);
            }
        }
    }

    public void setDurationMin(String minutes) {
        try {
            if (minutes != null || !minutes.equals("")) {
                this.durationMin = Integer.parseInt(minutes);
                Util.logMessage((String)("ReminderBean.setDurationMin(): Minutes before = " + minutes));
            }
        }
        catch (Exception ex) {
            Util.logError((String)"ReminderBean.setDurationMin(): Failed to create the Duration", (Throwable)ex);
        }
        this.setDuration();
    }

    public void setDurationHour(String hour) {
        try {
            if (hour != null || !hour.equals("")) {
                this.durationHour = Integer.parseInt(hour);
            }
        }
        catch (Exception ex) {
            Util.logError((String)"ReminderBean.setDurationHour(): Failed to create the Duration", (Throwable)ex);
        }
        this.setDuration();
    }

    public void setDurationDay(String day) {
        try {
            if (day != null || !day.equals("")) {
                this.durationDay = Integer.parseInt(day);
            }
        }
        catch (Exception ex) {
            Util.logError((String)"ReminderBean.setDurationDay(): Failed to create the Duration", (Throwable)ex);
        }
        this.setDuration();
    }

    public void setAbsAlarmTime(DateTime alarmTime) {
        try {
            this.alarm.setAbsTrigger(alarmTime.toISO8601());
            this.isAbsTriggerSet = true;
        }
        catch (Exception ex) {
            Util.logError((String)"ReminderBean.setDurationTime(): ", (Throwable)ex);
        }
    }

    public String getTrigger() {
        VAlarm alarm = this.getAlarm();
        if (alarm.getTrigger() != null) {
            return alarm.getTrigger().toString();
        }
        return "";
    }

    public String toString() {
        return this.getTrigger();
    }
}

