/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.re;

import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.StringHelper;
import java.util.ArrayList;

public final class Pattern {
    public static final Pattern[] EMPTY_PATTERN_ARRAY = new Pattern[0];
    private final String orgInput;
    private final String[] subStrings;
    final boolean ignoreCase;
    final boolean starsWithAsterisk;
    final boolean endsWithAsterisk;
    final boolean onlyAsterisk;
    final boolean negate;
    final String input;
    final boolean hasAsterisk;
    boolean recursive = false;

    public Pattern(String aString) {
        this(aString, false);
    }

    public Pattern(String aString, boolean aIgnoreCase) {
        String lInput;
        this.orgInput = aString;
        if (aString.startsWith("REC:")) {
            this.recursive = true;
            aString = aString.substring("REC:".length());
        }
        if (aString.startsWith("!")) {
            this.negate = true;
            lInput = aString.substring(1);
        } else {
            this.negate = false;
            lInput = aString.startsWith("\\!") ? aString.substring(1) : aString;
        }
        this.ignoreCase = aIgnoreCase;
        this.starsWithAsterisk = lInput.startsWith("*");
        this.endsWithAsterisk = !lInput.endsWith("\\*") && lInput.endsWith("*");
        this.onlyAsterisk = lInput.length() == 1 ? this.starsWithAsterisk : false;
        int i = 0;
        boolean lHasAsterisk = false;
        while (i < lInput.length() && !lHasAsterisk) {
            if ((i = lInput.indexOf(42, i)) == -1) {
                lHasAsterisk = false;
                break;
            }
            if (i == 0) {
                lHasAsterisk = true;
                continue;
            }
            if (lInput.charAt(i - 1) == Constants.ESCAPE_FORWARD_SLASH_CHAR) {
                ++i;
                continue;
            }
            lHasAsterisk = true;
        }
        this.hasAsterisk = lHasAsterisk;
        this.subStrings = Pattern.parseSubStrings(lInput, this.ignoreCase);
        this.input = StringHelper.searchAndReplace(lInput, "\\*", "*");
    }

    public String getInput() {
        return this.input;
    }

    public String[] getSubStrings() {
        return this.subStrings;
    }

    private static final String[] parseSubStrings(String aInput, boolean aIgnoreCase) {
        String[] lSubStrings = aIgnoreCase ? StringHelper.tokenize(aInput.toLowerCase(), "*") : StringHelper.tokenize(aInput, "*");
        return lSubStrings;
    }

    public static final Pattern[] convert2Patterns(String[] aArray) {
        return Pattern.convert2Patterns(aArray, false);
    }

    public static final Pattern[] convert2Patterns(String[] aArray, boolean aIgnoreCase) {
        if (aArray == null || aArray.length == 0) {
            return EMPTY_PATTERN_ARRAY;
        }
        ArrayList<Pattern> lList = new ArrayList<Pattern>();
        for (int i = 0; i < aArray.length; ++i) {
            if (aArray[i] == null) continue;
            lList.add(new Pattern(aArray[i], aIgnoreCase));
        }
        return lList.toArray(EMPTY_PATTERN_ARRAY);
    }

    public String toString() {
        return this.orgInput;
    }

    public boolean isRecursive() {
        return this.recursive;
    }
}

