/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.perf;

import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.portal.desktop.perf.DesktopJvmMonitor;
import com.sun.portal.desktop.perf.DesktopPerfStats;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.timer.Timer;

public class DesktopPerfMBeanFactory {
    public static final String METHOD = "perfMBean";
    public static final String SWITCH = "switch";
    public static final String SERVICE = "service";
    public static final String TIMER = "timer";
    public static final String ADAPTOR = "adaptor";
    public static final String RNAME = "name";
    public static final String RTYPE = "type";
    public static final String OPERATION = "action";
    public static final String SUBJECT = "subject";
    public static final String VOID = "";
    public static final int DEFAULT_HTML_ADAPTER_PORT = 8082;

    public static MBeanServer findMBeanServer(String domain) {
        ArrayList<MBeanServer> serverList = MBeanServerFactory.findMBeanServer(null);
        Iterator i = serverList.iterator();
        while (i.hasNext()) {
            MBeanServer server = (MBeanServer)i.next();
            if (!domain.equals(server.getDefaultDomain())) continue;
            return server;
        }
        return null;
    }

    public static MBeanServer createMBeanServer(String defDomain) throws InstanceAlreadyExistsException, MBeanRegistrationException, MalformedObjectNameException, RuntimeOperationsException, NotCompliantMBeanException {
        int[] ports = new int[]{8082};
        return DesktopPerfMBeanFactory.createMBeanServer(defDomain, ports);
    }

    public static MBeanServer createMBeanServer(String defDomain, int[] defPorts) throws InstanceAlreadyExistsException, MBeanRegistrationException, RuntimeOperationsException, MalformedObjectNameException, NotCompliantMBeanException {
        ObjectName oName;
        MBeanServer server = MBeanServerFactory.createMBeanServer(defDomain);
        int portnum = 0;
        int[] ports = defPorts == null || defPorts.length == 0 ? new int[]{8082} : defPorts;
        try {
            HtmlAdaptorServer htmlAdaptor = new HtmlAdaptorServer();
            oName = new ObjectName("Services:type=adaptor,name=com.sun.jdmk.comm.HtmlAdaptorServer");
            server.registerMBean(htmlAdaptor, oName);
            ServerSocket s = null;
            for (int i = 0; i < ports.length; ++i) {
                portnum = ports[i];
                try {
                    s = new ServerSocket(portnum);
                    s.close();
                    break;
                }
                catch (IOException e) {
                    if (i + 1 != ports.length) continue;
                    MBeanServerFactory.releaseMBeanServer(server);
                    throw new RuntimeOperationsException(new IllegalArgumentException("port number(s) specified for HtmlAdaptorServer are already used"), "DesktopPerfMBeanFactory.createMBeanServer(): failed to bind JMX HtmlAdaptorServer");
                }
            }
            htmlAdaptor.setPort(portnum);
            htmlAdaptor.start();
        }
        catch (Exception e) {
            MBeanServerFactory.releaseMBeanServer(server);
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
        try {
            Timer timer = new Timer();
            oName = new ObjectName("Services:type=timer,name=javax.management.timer.Timer");
            server.registerMBean(timer, oName);
            timer.start();
        }
        catch (Exception e) {
            MBeanServerFactory.releaseMBeanServer(server);
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
        try {
            DesktopJvmMonitor jvmMonitor = new DesktopJvmMonitor();
            oName = new ObjectName("Services:type=util,name=" + jvmMonitor.getClass().getName());
            server.registerMBean(jvmMonitor, oName);
        }
        catch (Exception e) {
            MBeanServerFactory.releaseMBeanServer(server);
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
        return server;
    }

    public static ObjectName getPerfStatsMBean(MBeanServer server, String name, boolean flag) throws InstanceAlreadyExistsException, InstanceNotFoundException, MBeanException, ReflectionException, MalformedObjectNameException, MBeanRegistrationException, RuntimeOperationsException, NotCompliantMBeanException {
        if (server == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean Server reference cannot be null"), "DesktopPerfMBeanFactory.createPerfStatsMBean(): invoked with null server pointer");
        }
        ObjectName oName = new ObjectName(name);
        if (server.isRegistered(oName)) {
            server.invoke(oName, "incNbRefs", null, null);
            return oName;
        }
        DesktopPerfStats mbean = new DesktopPerfStats(oName, server, flag);
        server.registerMBean(mbean, oName);
        return oName;
    }

    public static boolean isPerfMBeanActive(MBeanServer server, ObjectName oName) throws ReflectionException, MBeanException, InstanceNotFoundException, RuntimeOperationsException {
        if (server == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean Server reference cannot be null"), "DesktopPerfMBeanFactory.isPerfMBeanActive(): invoked with null server");
        }
        if (oName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object Name reference cannot be null"), "DesktopPerfMBeanFactory.isPerfMBeanActive(): invoked with null object name");
        }
        Boolean value = (Boolean)server.invoke(oName, "isActive", null, null);
        return value;
    }

    public static void logProcessTime(MBeanServer server, ObjectName oName, long ptime) throws InstanceNotFoundException, MBeanException, ReflectionException, RuntimeOperationsException, MBeanException {
        if (server == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean Server reference cannot be null"), "DesktopPerfMBeanFactory.logProcessTime(): invoked with null server");
        }
        if (oName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object Name reference cannot be null"), "DesktopPerfMBeanFactory.logProcessTime(): invoked with null object name");
        }
        Object[] params = new Object[]{new Long(ptime)};
        String[] signature = new String[]{"long"};
        server.invoke(oName, "setCurPTime", params, signature);
    }

    public static String buildSwitchMBeanName(MBeanServer server, String domain, String rName) throws RuntimeOperationsException {
        if (server == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean Server reference cannot be null"), "DesktopPerfMBeanFactory.buildSwitchMBeanName(): invoked with null server");
        }
        if (domain == null) {
            domain = server.getDefaultDomain();
        }
        return domain + ":" + RTYPE + "=" + SWITCH + "," + RNAME + "=" + rName;
    }

    public static String buildPerfMBeanName(MBeanServer server, String domain, String rType, String rName) throws RuntimeOperationsException {
        if (server == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean Server reference cannot be null"), "DesktopPerfMBeanFactory.buildPerfMBeanName(): invoked with null server");
        }
        if (domain == null) {
            domain = server.getDefaultDomain();
        }
        if (!DesktopPerfMBeanFactory.isResourceTypeValid(rType)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Illegal resource type argument"), "DesktopPerfMBeanFactory.buildPerfMBeanName(): resource type =" + rType);
        }
        return domain + ":" + RTYPE + "=" + rType + "," + RNAME + "=" + rName;
    }

    public static String buildPerfMBeanName(MBeanServer server, String domain, String rType, String rName, String operation, String subject) throws RuntimeOperationsException {
        if (server == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean Server reference cannot be null"), "DesktopPerfMBeanFactory.buildPerfMBeanName(): invoked with null server");
        }
        if (domain == null) {
            domain = server.getDefaultDomain();
        }
        if (!DesktopPerfMBeanFactory.isResourceTypeValid(rType)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Illegal resource type argument"), "DesktopPerfMBeanFactory.buildPerfMBeanName(): resource type =" + rType);
        }
        return domain + ":" + RTYPE + "=" + rType + "," + RNAME + "=" + rName + "," + OPERATION + "=" + operation + "," + SUBJECT + "=" + subject;
    }

    public static boolean isResourceTypeValid(String rType) {
        return true;
    }

    public static void releaseMBeanServer(MBeanServer server) throws IllegalArgumentException {
        MBeanServerFactory.releaseMBeanServer(server);
    }
}

