/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.cli;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.https.JSSInit;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.desktop.dp.cli.CLIPParser;
import com.sun.portal.desktop.dp.cli.DPACommand;
import com.sun.portal.desktop.dp.cli.DPAException;
import com.sun.portal.desktop.dp.cli.DPAUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class DPAMain {
    public static final String COMMANDNAME = "dpadmin";
    public static final String COMMANDVERSION = "1.2";
    public static final String LOG_FILENAME = "desktop.dpadmin.debug";
    public static final String DSAME_CACHEON = "com.iplanet.am.sdk.caching.enabled";
    private static Debug debug = null;

    DPAMain(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-l") && !args[i].equals("--locale") || i >= args.length - 1) continue;
            Locale locale = DPAUtil.getLocale(args[i + 1]);
            DPAException.setLocale(locale);
            DPAUtil.setLocale(locale);
        }
        debug = Debug.getInstance((String)LOG_FILENAME);
        if (debug == null) {
            Object[] tokens = new Object[]{LOG_FILENAME};
            System.err.println(DPAUtil.getLocalizedString("errorLogInitFailed", tokens));
        } else {
            debug.setDebug(1);
        }
    }

    private static Map getBatchInput(String batchFile) throws DPAException {
        File f = new File(batchFile);
        TreeMap<Long, String> batch = new TreeMap<Long, String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(batchFile));
            String line = null;
            long lineNum = 1L;
            while ((line = br.readLine()) != null) {
                if (line.length() > 0) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(line + "\n");
                    batch.put(new Long(lineNum), buf.toString());
                }
                ++lineNum;
            }
            br.close();
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{batchFile};
            throw new DPAException("errorFileRead", ioe, tokens);
        }
        if (batch.size() == 0) {
            throw new DPAException("errorEmptyBatch");
        }
        return batch;
    }

    public static void main(String[] args) {
        JSSInit.initialize();
        SystemProperties.initializeProperties((String)"com.sun.identity.security.amadmin", (String)"true");
        DPAMain dpa = new DPAMain(args);
        CLIPParser clipp = null;
        try {
            clipp = DPACommand.getCLIPParser(false);
            DPACommand cmd = new DPACommand(clipp, args, false);
            if (!cmd.isBatch()) {
                cmd.runCommand();
            } else {
                if (System.getProperty(DSAME_CACHEON) == null) {
                    System.setProperty(DSAME_CACHEON, "false");
                }
                DSAMEAdminDPContext dadc = null;
                boolean isPreAuthorized = false;
                if (cmd.isAuthProvided()) {
                    dadc = cmd.doAuth();
                    isPreAuthorized = true;
                }
                Map batch = DPAMain.getBatchInput(cmd.batchFile);
                CLIPParser cp = DPACommand.getCLIPParser(true);
                Set keySet = batch.keySet();
                Iterator i = keySet.iterator();
                while (i.hasNext()) {
                    Long key = (Long)i.next();
                    String cmdline = (String)batch.get(key);
                    if (cmd.verbose) {
                        Object[] tokens = new Object[]{key, cmdline};
                        DPAUtil.debug("dbgProcessingLine", tokens);
                    }
                    try {
                        DPACommand c = new DPACommand(cp, cmdline, true, isPreAuthorized);
                        if (isPreAuthorized) {
                            c.runCommand(dadc);
                            continue;
                        }
                        c.runCommand();
                    }
                    catch (DPAException dpaex) {
                        Object[] tokens;
                        String wrappedMsg = dpaex.getWrappedMessage();
                        if (wrappedMsg != null && wrappedMsg.length() > 0) {
                            tokens = new Object[]{dpaex.getLocalizedMessage(), key, wrappedMsg};
                            System.err.println(DPAUtil.getLocalizedString("msgWrappedErrorLine", tokens));
                        } else {
                            tokens = new Object[]{dpaex.getLocalizedMessage(), key};
                            System.err.println(DPAUtil.getLocalizedString("msgErrorLine", tokens));
                        }
                        debug.setDebug(1);
                        debug.error("Exception: ", (Throwable)dpaex);
                        if (cmd.cont) continue;
                        System.exit(1);
                    }
                    catch (Exception ex) {
                        Object[] tokens = new Object[]{ex.getLocalizedMessage(), key};
                        System.err.println(DPAUtil.getLocalizedString("msgErrorLine", tokens));
                        debug.setDebug(1);
                        debug.error("Exception: ", (Throwable)ex);
                        if (cmd.cont) continue;
                        System.exit(1);
                    }
                }
            }
            System.exit(0);
        }
        catch (DPAException dpaex) {
            String wrappedMsg = dpaex.getWrappedMessage();
            if (wrappedMsg != null && wrappedMsg.length() > 0) {
                Object[] tokens = new Object[]{dpaex.getLocalizedMessage(), wrappedMsg};
                System.err.println(DPAUtil.getLocalizedString("msgWrappedError", tokens));
            } else {
                Object[] tokens = new Object[]{dpaex.getLocalizedMessage()};
                System.err.println(DPAUtil.getLocalizedString("msgError", tokens));
            }
            debug.setDebug(1);
            debug.error("Exception: ", (Throwable)dpaex);
            System.exit(1);
        }
        catch (Exception ex) {
            Object[] tokens = new Object[]{ex.getLocalizedMessage()};
            System.err.println(DPAUtil.getLocalizedString("msgError", tokens));
            debug.setDebug(1);
            debug.error("Exception: ", (Throwable)ex);
            System.exit(1);
        }
    }
}

