/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopContextFactory;
import com.sun.portal.desktop.context.PSContextConstants;
import javax.servlet.ServletContext;

public class PSDesktopContextFactoryManager
implements PSContextConstants {
    private static DesktopContextFactory dcf = null;

    public static synchronized DesktopContextFactory getFactory(ServletContext sc) {
        if (dcf == null) {
            String dcfClassName = sc.getInitParameter("desktop.contextFactoryClassName");
            if (dcfClassName == null) {
                throw new ContextError("DesktopContextFactoryManager.getFactory(): dcf class name was null from servlet context");
            }
            try {
                dcf = (DesktopContextFactory)Class.forName(dcfClassName).newInstance();
                dcf.init(sc);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("DesktopContextFactoryManager.getFactory(): ", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("DesktopContextFactoryManager.getFactory(): ", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("DesktopContextFactoryManager.getFactory(): ", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("DesktopContextFactoryManager.getFactory(): ", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("DesktopContextFactoryManager.getFactory(): ", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("DesktopContextFactoryManager.getFactory(): ", se);
            }
        }
        return dcf;
    }
}

