/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.model;

public class DAConsoleException
extends Throwable {
    public static final String[] errorKeys = new String[]{"generic.error.title", "generic.error.message", "editProperties.error.title.nochannel", "editProperties.error.message.nochannel", "editProperties.error.title.noprovider", "editProperties.error.message.noprovider", "editProperties.error.title.invalidinteger", "editProperties.error.message.invalidinteger", "editProperties.error.title.typeunknown", "editProperties.error.message.typeunknown", "addProperties.error.title.unnamedcollection", "addProperties.error.message.unnamedcollection", "addProperties.error.title.invalidcollectionname", "addProperties.error.message.invalidcollectionname", "addProperties.error.title.invalidunnamedproperty", "addProperties.error.message.invalidunnamedproperty", "addProperties.error.title.propertyexists", "addProperties.error.message.propertyexists", "addProperties.error.title.invalidpropertyname", "addProperties.error.message.invalidpropertyname", "browsecontainer.error.title.containernotfound", "browsecontainer.error.message.containernotfound", "addchannel.error.title.addfailed", "addchannel.error.message.channelexists", "addchannel.error.title.addfailed", "addchannel.error.message.missingname", "addchannel.error.title.addfailed", "addchannel.error.message.namespace", "addProperties.error.title.invalidconditional", "addProperties.error.message.invalidconditional", "editProperties.error.title.invalidvalue", "editProperties.error.message.invalidvalue"};
    private int errorCode = 0;
    private Throwable wrapped = null;

    private int validateErrorCode(int code) {
        if (code * 2 + 1 < errorKeys.length) {
            return code;
        }
        return 0;
    }

    public DAConsoleException(String message) {
        super(message);
    }

    public DAConsoleException(Throwable t) {
        super(t.getMessage());
        this.wrapped = t;
    }

    public DAConsoleException(int errorCode, Throwable t) {
        super(t.getMessage());
        this.wrapped = t;
        this.errorCode = this.validateErrorCode(errorCode);
    }

    public DAConsoleException(int errorCode, String message) {
        super(message);
        this.errorCode = this.validateErrorCode(errorCode);
    }

    public DAConsoleException(int errorCode) {
        this.errorCode = this.validateErrorCode(errorCode);
    }

    public Throwable getWrappedException() {
        if (this.wrapped != null) {
            return this.wrapped;
        }
        return new Throwable("Unknown error");
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getTitleKey() {
        return errorKeys[this.errorCode * 2];
    }

    public String getMessageKey() {
        return errorKeys[this.errorCode * 2 + 1];
    }
}

