/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.model;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.portal.desktop.admin.model.DABrowseContainerModel;
import com.sun.portal.desktop.admin.model.DAConsoleException;
import com.sun.portal.desktop.admin.model.DADPModelImpl;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class DABrowseContainerModelImpl
extends DADPModelImpl
implements DABrowseContainerModel {
    private boolean canViewDTAttributes = true;
    private String containerPath = null;
    private Set containers = Collections.EMPTY_SET;
    private Set channels = Collections.EMPTY_SET;
    private Set existingChannels = Collections.EMPTY_SET;
    private Set availableChannels = Collections.EMPTY_SET;
    private Set selectedChannels = Collections.EMPTY_SET;
    private Set importModules = null;
    private Map viewBeanMap = null;
    private DPNode currentNode = null;

    public DABrowseContainerModelImpl(HttpServletRequest req, String rbName, Map map) throws DAConsoleException {
        super(req, rbName, map);
        this.containerPath = (String)map.get("com.sun.portal.desktop.admin.fqcn");
    }

    public void initData() throws DAConsoleException {
        try {
            Iterator ri = this.dpUser.getRoleDNs().iterator();
            while (ri.hasNext() && this.canViewDTAttributes) {
                String value;
                AMTemplate amTemplate;
                AMRole amRole = this.dpStoreConn.getRole((String)ri.next());
                if (amRole == null || !amRole.isExists() || (amTemplate = amRole.getTemplate("SunPortalDesktopService", 301)) == null || !amTemplate.isExists() || (value = amTemplate.getStringAttribute("sunPortalDesktopDpCanView")).length() <= 0) continue;
                this.canViewDTAttributes = Boolean.valueOf(value);
            }
            this.currentNode = this.containerPath == null || this.containerPath.length() < 2 ? this.dpRoot : this.dpRoot.getChannel(this.containerPath);
            if (this.currentNode == null) {
                throw new DAConsoleException(10);
            }
            short currentNodeType = this.currentNode.getType();
            if (currentNodeType != 13 && currentNodeType != 5) {
                this.currentNode = this.dpRoot;
                this.error("DABrowseContainerModelImpl:initData Incorrect Node");
            }
            this.initChannelData();
            this.initImportModulesData();
            if (this.currentNode.getType() != 13) {
                this.initChannelMgmtData();
            }
        }
        catch (DPError dpe) {
            throw new DAConsoleException(11, (Throwable)dpe);
        }
        catch (AMException ame) {
            throw new DAConsoleException(0, (Throwable)ame);
        }
        catch (SSOException ssoe) {
            throw new DAConsoleException(0, (Throwable)ssoe);
        }
    }

    private void initChannelData() throws DPError {
        this.containers = new TreeSet<Object>(this.getCollator());
        this.channels = new TreeSet<Object>(this.getCollator());
        Set channelNames = this.currentNode.getChannelNames();
        String channelName = null;
        Iterator iterator = channelNames.iterator();
        while (iterator.hasNext()) {
            channelName = (String)iterator.next();
            String fqcn = this.toFullyQualifiedName(this.currentNode, channelName);
            DPChannel channel = this.currentNode.getChannel(channelName);
            if (!this.isDisplayable(fqcn) || !this.canAccess(fqcn)) continue;
            if (channel instanceof DPContainerChannel) {
                this.containers.add(fqcn);
                continue;
            }
            this.channels.add(fqcn);
        }
    }

    private void initChannelMgmtData() throws DPError {
        DPContainerChannel container = (DPContainerChannel)this.currentNode;
        this.existingChannels = this.getAssignableChannels();
        TreeSet<Object> nonExistingChannels = new TreeSet<Object>(this.getCollator());
        String channelName = null;
        this.availableChannels = container.getAvailable().getNames();
        Iterator iterator = this.availableChannels.iterator();
        while (iterator.hasNext()) {
            channelName = (String)iterator.next();
            if (this.dpRoot.channelExists(channelName)) continue;
            nonExistingChannels.add(channelName);
        }
        if (!nonExistingChannels.isEmpty()) {
            this.availableChannels.removeAll(nonExistingChannels);
            container.setAvailable(new ArrayList(this.availableChannels));
        }
        nonExistingChannels.clear();
        this.selectedChannels = container.getSelected().getNames();
        iterator = this.selectedChannels.iterator();
        while (iterator.hasNext()) {
            channelName = (String)iterator.next();
            if (this.dpRoot.channelExists(channelName)) continue;
            nonExistingChannels.add(channelName);
        }
        if (!nonExistingChannels.isEmpty()) {
            this.selectedChannels.removeAll(nonExistingChannels);
            container.setSelected(new ArrayList(this.selectedChannels));
        }
        this.availableChannels.removeAll(this.selectedChannels);
        this.existingChannels.removeAll(this.selectedChannels);
        this.existingChannels.removeAll(this.availableChannels);
    }

    protected Set getAssignableChannels() {
        TreeSet<Object> result = new TreeSet<Object>(this.getCollator());
        Set channelNames = this.currentNode.getChannelNames();
        Iterator iterator = channelNames.iterator();
        while (iterator.hasNext()) {
            String channelName = (String)iterator.next();
            String fQCN = this.toFullyQualifiedName(this.currentNode, channelName);
            if (!this.isDisplayable(fQCN)) continue;
            result.add(fQCN);
        }
        for (DPNode parentNode = this.currentNode.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            channelNames = parentNode.getChannelNames();
            iterator = channelNames.iterator();
            while (iterator.hasNext()) {
                String channelName = (String)iterator.next();
                String fQCN = this.toFullyQualifiedName(parentNode, channelName);
                if (!this.isDisplayable(fQCN)) continue;
                result.add(fQCN);
            }
        }
        result.remove(this.currentNode.getName());
        return result;
    }

    protected String toFullyQualifiedName(DPNode container, String shortName) {
        return (container instanceof DPRoot ? "" : container.getName() + '/') + shortName;
    }

    private boolean isDisplayable(String fqcn) {
        boolean isDisplayable = true;
        DPChannel channel = this.dpRoot.getChannel(fqcn);
        String shortName = this.getTail(fqcn);
        if (channel == null || channel.isAdvanced() || shortName.startsWith("_")) {
            isDisplayable = false;
        }
        return isDisplayable;
    }

    protected boolean canAccess(String channel) {
        boolean canAccess = true;
        if (!this.canViewDTAttributes) {
            boolean isInMergers = false;
            List mergers = this.dpRoot.getMergers();
            if (mergers != null) {
                Iterator iterator = mergers.iterator();
                while (iterator.hasNext()) {
                    DPRoot merger = (DPRoot)iterator.next();
                    if (!merger.channelExists(channel)) continue;
                    isInMergers = true;
                    break;
                }
            }
            canAccess = this.dpRoot.channelExists(channel) && !isInMergers;
        }
        return canAccess;
    }

    public boolean canAddChannels() {
        return this.currentNode != null && this.canAccess(this.currentNode.getName());
    }

    public boolean canViewDTAttributes() {
        return this.canViewDTAttributes;
    }

    public void removeChannels(List channels) throws DAConsoleException {
        Iterator itr = channels.iterator();
        while (itr.hasNext()) {
            String chName = (String)itr.next();
            try {
                this.currentNode.removeChannel(this.getTail(chName));
            }
            catch (DPError e) {
                this.error("Cannot remove channel: " + e.getMessage());
            }
        }
        this.removeReferences(this.dpRoot, channels);
        this.store();
    }

    protected void removeReferences(DPNode node, List removedChannels) {
        Set channelNames = node.getChannelNames();
        Iterator iterator = channelNames.iterator();
        while (iterator.hasNext()) {
            String channelName = (String)iterator.next();
            DPChannel channel = node.getChannel(channelName);
            if (!(channel instanceof DPContainerChannel)) continue;
            DPContainerChannel container = (DPContainerChannel)channel;
            this.removeReferences(container, removedChannels);
            Set available = container.getAvailable().getNames();
            boolean removed = false;
            Iterator rmChItr1 = removedChannels.iterator();
            while (rmChItr1.hasNext()) {
                if (!available.remove((String)rmChItr1.next())) continue;
                removed = true;
            }
            if (removed) {
                container.setAvailable(new ArrayList(available));
            }
            Set selected = container.getSelected().getNames();
            removed = false;
            Iterator rmChItr2 = removedChannels.iterator();
            while (rmChItr2.hasNext()) {
                if (!selected.remove((String)rmChItr2.next())) continue;
                removed = true;
            }
            if (!removed) continue;
            container.setSelected(new ArrayList(selected));
        }
    }

    public void setAvailableAndSelected(List available, List selected) throws DAConsoleException {
        ((DPContainerChannel)this.currentNode).setSelected(selected);
        ArrayList<String> availableList = new ArrayList<String>(selected);
        Iterator avlItr = available.iterator();
        while (avlItr.hasNext()) {
            String fqcn = (String)avlItr.next();
            if (fqcn == null || availableList.contains(fqcn)) continue;
            availableList.add(fqcn);
        }
        ((DPContainerChannel)this.currentNode).setAvailable(availableList);
        this.store();
        this.initChannelMgmtData();
    }

    public Set getExistingChannels() {
        return this.existingChannels;
    }

    public Set getAvailableChannels() {
        return this.availableChannels;
    }

    public Set getSelectedChannels() {
        return this.selectedChannels;
    }

    public Set getChannels() {
        return this.channels;
    }

    public Set getContainers() {
        return this.containers;
    }

    public boolean isDisplayProfileRoot() {
        boolean isDPRoot = false;
        if (this.currentNode == null || this.currentNode.getType() == 13) {
            isDPRoot = true;
        }
        return isDPRoot;
    }

    public String getShortName(String fqcn) {
        return this.getTail(fqcn);
    }

    private void initImportModulesData() {
        ServiceSchema schema = null;
        Set viewBeanSet = null;
        try {
            ServiceSchemaManager sm = this.getServiceSchemaManager("SunPortalDesktopService");
            schema = sm.getSchema(SchemaType.GLOBAL);
        }
        catch (SSOException ssoe) {
            this.error("DABrowseContainerModelImpl.setImportModules():", ssoe);
        }
        catch (SMSException smse) {
            this.error("DABrowseContainerModelImpl.setImportModules():", smse);
        }
        Map attrMap = null;
        if (schema != null) {
            attrMap = schema.getAttributeDefaults();
        }
        if (attrMap != null) {
            this.importModules = (Set)attrMap.get("sunPortalDesktopChannelImportModules");
            viewBeanSet = (Set)attrMap.get("sunPortalDesktopChannelViewBeanMap");
        }
        this.viewBeanMap = new HashMap();
        if (viewBeanSet != null && !viewBeanSet.isEmpty()) {
            Iterator iter = viewBeanSet.iterator();
            while (iter.hasNext()) {
                String entry = (String)iter.next();
                int index = entry.indexOf(124);
                if (index == -1) continue;
                this.viewBeanMap.put(entry.substring(0, index), entry.substring(index + 1));
            }
        }
    }

    public Set getExternalModules() {
        return this.importModules;
    }

    public String getChannelViewBeanClassName(String channelName) {
        String providerName;
        if (channelName == null || channelName.length() == 0) {
            return null;
        }
        String viewBean = null;
        DPChannel channelNode = this.currentNode.getChannel(this.getTail(channelName));
        String string = providerName = channelNode instanceof DPChannel ? channelNode.getProviderName() : null;
        if (providerName != null) {
            DPProvider provider = this.currentNode.getProvider(providerName);
            String className = null;
            if (provider != null) {
                className = provider.getClassName();
            }
            if (className != null) {
                viewBean = (String)this.viewBeanMap.get(className);
            }
        }
        return viewBean;
    }
}

